/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.squareup.spoon.SpoonUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jacoco.core.tools.ExecFileLoader;

final class SpoonCoverageMerger {
    private static final String MERGED_COVERAGE_FILE = "merged-coverage.ec";
    private ExecFileLoader execFileLoader = new ExecFileLoader();

    public void mergeCoverageFiles(Set<String> serials, File outputDirectory) throws IOException {
        Collection sanitizeSerials = Collections2.transform(serials, this.toSanitizeSerials());
        for (String serial : sanitizeSerials) {
            String coverageFilePath = "coverage/" + serial + "/" + "coverage.ec";
            this.execFileLoader.load(new File(outputDirectory, coverageFilePath));
        }
        String mergedCoverageFile = "coverage/merged-coverage.ec";
        this.execFileLoader.save(new File(outputDirectory, mergedCoverageFile), false);
    }

    private Function<String, String> toSanitizeSerials() {
        return new Function<String, String>(){

            public String apply(String serials) {
                return SpoonUtils.sanitizeSerial(serials);
            }
        };
    }
}

