/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.logcat.LogCatListener;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatReceiverTask;
import com.squareup.spoon.DeviceTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SpoonDeviceLogger
implements LogCatListener {
    private static final String TEST_RUNNER = "TestRunner";
    private static final Pattern MESSAGE_START = Pattern.compile("started: ([^(]+)\\(([^)]+)\\)");
    private static final Pattern MESSAGE_END = Pattern.compile("finished: [^(]+\\([^)]+\\)");
    private final List<LogCatMessage> messages = new ArrayList<LogCatMessage>();
    private final LogCatReceiverTask logCatReceiverTask;

    public SpoonDeviceLogger(IDevice device) {
        this.logCatReceiverTask = new LogCatReceiverTask(device);
        this.logCatReceiverTask.addLogCatListener((LogCatListener)this);
        new Thread((Runnable)this.logCatReceiverTask).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(List<LogCatMessage> msgList) {
        List<LogCatMessage> list = this.messages;
        synchronized (list) {
            this.messages.addAll(msgList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DeviceTest, List<LogCatMessage>> getParsedLogs() {
        this.logCatReceiverTask.stop();
        HashMap<DeviceTest, List<LogCatMessage>> logs = new HashMap<DeviceTest, List<LogCatMessage>>();
        DeviceTest current = null;
        int pid = -1;
        List<LogCatMessage> list = this.messages;
        synchronized (list) {
            for (LogCatMessage message : this.messages) {
                Matcher match;
                if (current == null) {
                    match = MESSAGE_START.matcher(message.getMessage());
                    if (!match.matches() || !TEST_RUNNER.equals(message.getTag())) continue;
                    current = new DeviceTest(match.group(2), match.group(1));
                    pid = message.getPid();
                    ArrayList<LogCatMessage> deviceLogMessages = new ArrayList<LogCatMessage>();
                    deviceLogMessages.add(message);
                    logs.put(current, deviceLogMessages);
                    continue;
                }
                if (pid == message.getPid()) {
                    ((List)logs.get(current)).add(message);
                }
                if (!(match = MESSAGE_END.matcher(message.getMessage())).matches() || !TEST_RUNNER.equals(message.getTag())) continue;
                current = null;
                pid = -1;
            }
        }
        return logs;
    }
}

