/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.squareup.spoon.DeviceDetails;
import com.squareup.spoon.DeviceResult;
import com.squareup.spoon.DeviceTest;
import com.squareup.spoon.DeviceTestResult;
import com.squareup.spoon.SpoonDeviceLogger;
import com.squareup.spoon.SpoonInstrumentationInfo;
import com.squareup.spoon.SpoonLogger;
import com.squareup.spoon.SpoonTestRunListener;
import com.squareup.spoon.SpoonUtils;
import com.squareup.spoon.XmlTestRunListener;
import com.squareup.spoon.adapters.TestIdentifierAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public final class SpoonDeviceRunner {
    private static final String FILE_EXECUTION = "execution.json";
    private static final String FILE_RESULT = "result.json";
    private static final String DEVICE_SCREENSHOT_DIR = "app_spoon-screenshots";
    private static final String DEVICE_FILE_DIR = "app_spoon-files";
    private static final String[] DEVICE_DIRS = new String[]{"app_spoon-screenshots", "app_spoon-files"};
    static final String TEMP_DIR = "work";
    static final String JUNIT_DIR = "junit-reports";
    static final String IMAGE_DIR = "image";
    static final String FILE_DIR = "file";
    static final String COVERAGE_FILE = "coverage.ec";
    static final String COVERAGE_DIR = "coverage";
    private final File sdk;
    private final File apk;
    private final File testApk;
    private final String serial;
    private final int shardIndex;
    private final int numShards;
    private final boolean debug;
    private final boolean noAnimations;
    private final int adbTimeout;
    private final List<String> instrumentationArgs;
    private final String className;
    private final String methodName;
    private final IRemoteAndroidTestRunner.TestSize testSize;
    private final File work;
    private final File junitReport;
    private final File imageDir;
    private final File coverageDir;
    private final File fileDir;
    private final String classpath;
    private final SpoonInstrumentationInfo instrumentationInfo;
    private boolean codeCoverage;
    private final List<ITestRunListener> testRunListeners;
    private final boolean grantAll;

    SpoonDeviceRunner(File sdk, File apk, File testApk, File output, String serial, int shardIndex, int numShards, boolean debug, boolean noAnimations, int adbTimeout, String classpath, SpoonInstrumentationInfo instrumentationInfo, List<String> instrumentationArgs, String className, String methodName, IRemoteAndroidTestRunner.TestSize testSize, List<ITestRunListener> testRunListeners, boolean codeCoverage, boolean grantAll) {
        this.sdk = sdk;
        this.apk = apk;
        this.testApk = testApk;
        this.serial = serial;
        this.shardIndex = shardIndex;
        this.numShards = numShards;
        this.debug = debug;
        this.noAnimations = noAnimations;
        this.adbTimeout = adbTimeout;
        this.instrumentationArgs = instrumentationArgs;
        this.className = className;
        this.methodName = methodName;
        this.testSize = testSize;
        this.classpath = classpath;
        this.instrumentationInfo = instrumentationInfo;
        this.codeCoverage = codeCoverage;
        serial = SpoonUtils.sanitizeSerial(serial);
        this.work = FileUtils.getFile((File)output, (String[])new String[]{TEMP_DIR, serial});
        this.junitReport = FileUtils.getFile((File)output, (String[])new String[]{JUNIT_DIR, serial + ".xml"});
        this.imageDir = FileUtils.getFile((File)output, (String[])new String[]{IMAGE_DIR, serial});
        this.fileDir = FileUtils.getFile((File)output, (String[])new String[]{FILE_DIR, serial});
        this.coverageDir = FileUtils.getFile((File)output, (String[])new String[]{COVERAGE_DIR, serial});
        this.testRunListeners = testRunListeners;
        this.grantAll = grantAll;
    }

    public DeviceResult runInNewProcess() throws IOException, InterruptedException {
        SpoonLogger.logDebug(this.debug, "[%s]", this.serial);
        this.work.mkdirs();
        FileWriter executionWriter = new FileWriter(new File(this.work, FILE_EXECUTION));
        SpoonUtils.GSON.toJson((Object)this, (Appendable)executionWriter);
        executionWriter.close();
        String name = SpoonDeviceRunner.class.getName();
        Process process = new ProcessBuilder("java", "-Djava.awt.headless=true", "-cp", this.classpath, name, this.work.getAbsolutePath()).start();
        this.printStream(process.getInputStream(), "STDOUT");
        this.printStream(process.getErrorStream(), "STDERR");
        int exitCode = process.waitFor();
        SpoonLogger.logDebug(this.debug, "Process.waitFor() finished for [%s] with exitCode %d", this.serial, exitCode);
        FileReader resultFile = new FileReader(new File(this.work, FILE_RESULT));
        DeviceResult result = (DeviceResult)SpoonUtils.GSON.fromJson((Reader)resultFile, DeviceResult.class);
        resultFile.close();
        return result;
    }

    private void printStream(InputStream stream, String tag) throws IOException {
        String s;
        BufferedReader stdout = new BufferedReader(new InputStreamReader(stream));
        while ((s = stdout.readLine()) != null) {
            SpoonLogger.logDebug(this.debug, "[%s] %s %s", this.serial, tag, s);
        }
    }

    public DeviceResult run(AndroidDebugBridge adb) {
        String testPackage = this.instrumentationInfo.getInstrumentationPackage();
        String testRunner = this.instrumentationInfo.getTestRunnerClass();
        TestIdentifierAdapter testIdentifierAdapter = TestIdentifierAdapter.fromTestRunner(testRunner);
        SpoonLogger.logDebug(this.debug, "InstrumentationInfo: [%s]", this.instrumentationInfo);
        if (this.debug) {
            SpoonUtils.setDdmlibInternalLoggingLevel();
        }
        DeviceResult.Builder result = new DeviceResult.Builder();
        IDevice device = SpoonUtils.obtainRealDevice(adb, this.serial);
        SpoonLogger.logDebug(this.debug, "Got realDevice for [%s]", this.serial);
        DeviceDetails deviceDetails = DeviceDetails.createForDevice(device);
        result.setDeviceDetails(deviceDetails);
        SpoonLogger.logDebug(this.debug, "[%s] setDeviceDetails %s", this.serial, deviceDetails);
        DdmPreferences.setTimeOut((int)this.adbTimeout);
        try {
            String extraArgument = "";
            if (this.grantAll && deviceDetails.getApiLevel() >= 23) {
                extraArgument = "-g";
            }
            device.installPackage(this.apk.getAbsolutePath(), true, new String[]{extraArgument});
        }
        catch (InstallException e) {
            SpoonLogger.logInfo("InstallException while install app apk on device [%s]", this.serial);
            e.printStackTrace(System.out);
            return result.markInstallAsFailed("Unable to install application APK.").build();
        }
        try {
            device.installPackage(this.testApk.getAbsolutePath(), true, new String[0]);
        }
        catch (InstallException e) {
            SpoonLogger.logInfo("InstallException while install test apk on device [%s]", this.serial);
            e.printStackTrace(System.out);
            return result.markInstallAsFailed("Unable to install instrumentation APK.").build();
        }
        if (deviceDetails.getApiLevel() >= 23) {
            String appPackage = this.instrumentationInfo.getApplicationPackage();
            try {
                CollectingOutputReceiver grantOutputReceiver = new CollectingOutputReceiver();
                device.executeShellCommand("pm grant " + appPackage + " android.permission.READ_EXTERNAL_STORAGE", (IShellOutputReceiver)grantOutputReceiver);
                device.executeShellCommand("pm grant " + appPackage + " android.permission.WRITE_EXTERNAL_STORAGE", (IShellOutputReceiver)grantOutputReceiver);
            }
            catch (Exception e) {
                SpoonLogger.logInfo("Exception while granting external storage access to application apkon device [%s]", this.serial);
                e.printStackTrace(System.out);
                return result.markInstallAsFailed("Unable to grant external storage access to application APK.").build();
            }
        }
        this.work.mkdirs();
        SpoonDeviceLogger deviceLogger = new SpoonDeviceLogger(device);
        try {
            SpoonLogger.logDebug(this.debug, "About to actually run tests for [%s]", this.serial);
            RemoteAndroidTestRunner runner = new RemoteAndroidTestRunner(testPackage, testRunner, (IShellEnabledDevice)device);
            runner.setMaxtimeToOutputResponse(this.adbTimeout);
            if (this.instrumentationArgs != null && this.instrumentationArgs.size() > 0) {
                for (String pair : this.instrumentationArgs) {
                    int firstEqualSignIndex = pair.indexOf("=");
                    if (firstEqualSignIndex <= -1) {
                        SpoonLogger.logDebug(this.debug, "Can't process instrumentationArg [%s] (no equal sign)", pair);
                        continue;
                    }
                    String key = pair.substring(0, firstEqualSignIndex);
                    String value = pair.substring(firstEqualSignIndex + 1);
                    if (Strings.isNullOrEmpty((String)key) || Strings.isNullOrEmpty((String)value)) {
                        SpoonLogger.logDebug(this.debug, "Can't process instrumentationArg [%s] (empty key or value)", pair);
                        continue;
                    }
                    runner.addInstrumentationArg(key, value);
                }
            }
            if (this.codeCoverage) {
                this.addCodeCoverageInstrumentationArgs(runner, device);
            }
            if (this.numShards != 0) {
                this.addShardingInstrumentationArgs(runner);
            }
            if (!Strings.isNullOrEmpty((String)this.className)) {
                if (Strings.isNullOrEmpty((String)this.methodName)) {
                    runner.setClassName(this.className);
                } else {
                    runner.setMethodName(this.className, this.methodName);
                }
            }
            if (this.testSize != null) {
                runner.setTestSize(this.testSize);
            }
            ArrayList<Object> listeners = new ArrayList<Object>();
            listeners.add(new SpoonTestRunListener(result, this.debug, testIdentifierAdapter));
            listeners.add((Object)new XmlTestRunListener(this.junitReport));
            if (this.testRunListeners != null) {
                listeners.addAll(this.testRunListeners);
            }
            runner.run(listeners);
        }
        catch (Exception e) {
            result.addException(e);
        }
        SpoonDeviceRunner.mapLogsToTests(deviceLogger, result);
        try {
            SpoonLogger.logDebug(this.debug, "About to grab screenshots and prepare output for [%s]", this.serial);
            this.pullDeviceFiles(device);
            if (this.codeCoverage) {
                this.pullCoverageFile(device);
            }
            this.cleanScreenshotsDirectory(result);
            this.cleanFilesDirectory(result);
        }
        catch (Exception e) {
            result.addException(e);
        }
        SpoonLogger.logDebug(this.debug, "Done running for [%s]", this.serial);
        return result.build();
    }

    private void addCodeCoverageInstrumentationArgs(RemoteAndroidTestRunner runner, IDevice device) throws Exception {
        String coveragePath = this.getExternalStoragePath(device, COVERAGE_FILE);
        runner.addInstrumentationArg(COVERAGE_DIR, "true");
        runner.addInstrumentationArg("coverageFile", coveragePath);
    }

    private void addShardingInstrumentationArgs(RemoteAndroidTestRunner runner) {
        runner.addInstrumentationArg("numShards", Integer.toString(this.numShards));
        runner.addInstrumentationArg("shardIndex", Integer.toString(this.shardIndex));
    }

    private void cleanScreenshotsDirectory(DeviceResult.Builder result) throws IOException {
        File screenshotDir = new File(this.work, DEVICE_SCREENSHOT_DIR);
        if (screenshotDir.exists()) {
            this.imageDir.mkdirs();
            this.handleImages(result, screenshotDir);
            FileUtils.deleteDirectory((File)screenshotDir);
        }
    }

    private void cleanFilesDirectory(DeviceResult.Builder result) throws IOException {
        File testFilesDir = new File(this.work, DEVICE_FILE_DIR);
        if (testFilesDir.exists()) {
            this.fileDir.mkdirs();
            this.handleFiles(result, testFilesDir);
            FileUtils.deleteDirectory((File)testFilesDir);
        }
    }

    private void pullCoverageFile(IDevice device) {
        String remotePath;
        this.coverageDir.mkdirs();
        File coverageFile = new File(this.coverageDir, COVERAGE_FILE);
        try {
            remotePath = this.getExternalStoragePath(device, COVERAGE_FILE);
        }
        catch (Exception exception) {
            throw new RuntimeException("error while calculating coverage file path.", exception);
        }
        this.adbPullFile(device, remotePath, coverageFile.getAbsolutePath());
    }

    private void handleImages(DeviceResult.Builder result, File screenshotDir) throws IOException {
        SpoonLogger.logDebug(this.debug, "Moving screenshots to the image folder on [%s]", this.serial);
        File[] classNameDirs = screenshotDir.listFiles();
        if (classNameDirs != null) {
            ArrayListMultimap testScreenshots = ArrayListMultimap.create();
            for (File classNameDir : classNameDirs) {
                String className = classNameDir.getName();
                File destDir = new File(this.imageDir, className);
                FileUtils.copyDirectory((File)classNameDir, (File)destDir);
                ArrayList screenshots = new ArrayList(FileUtils.listFiles((File)destDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE));
                Collections.sort(screenshots);
                for (File screenshot : screenshots) {
                    String methodName = screenshot.getParentFile().getName();
                    DeviceTest testIdentifier = new DeviceTest(className, methodName);
                    DeviceTestResult.Builder builder = result.getMethodResultBuilder(testIdentifier);
                    if (builder != null) {
                        builder.addScreenshot(screenshot);
                        testScreenshots.put((Object)testIdentifier, (Object)screenshot);
                        continue;
                    }
                    SpoonLogger.logError("Unable to find test for %s", testIdentifier);
                }
            }
            SpoonLogger.logDebug(this.debug, "Generating animated gifs for [%s]", this.serial);
            if (!this.noAnimations) {
                for (DeviceTest deviceTest : testScreenshots.keySet()) {
                    ArrayList<File> screenshots = new ArrayList<File>(testScreenshots.get((Object)deviceTest));
                    if (screenshots.size() == 1) continue;
                    File animatedGif = FileUtils.getFile((File)this.imageDir, (String[])new String[]{deviceTest.getClassName(), deviceTest.getMethodName() + ".gif"});
                    SpoonUtils.createAnimatedGif(screenshots, animatedGif);
                    result.getMethodResultBuilder(deviceTest).setAnimatedGif(animatedGif);
                }
            }
        }
    }

    private void handleFiles(DeviceResult.Builder result, File testFileDir) throws IOException {
        Object[] classNameDirs = testFileDir.listFiles();
        if (classNameDirs != null) {
            SpoonLogger.logInfo("Found class name dirs: " + Arrays.toString(classNameDirs), new Object[0]);
            for (Object classNameDir : classNameDirs) {
                String className = ((File)classNameDir).getName();
                File destDir = new File(this.fileDir, className);
                FileUtils.copyDirectory((File)classNameDir, (File)destDir);
                SpoonLogger.logInfo("Copied " + classNameDir + " to " + destDir, new Object[0]);
                ArrayList files = new ArrayList(FileUtils.listFiles((File)destDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE));
                Collections.sort(files);
                for (File file : files) {
                    String methodName = file.getParentFile().getName();
                    DeviceTest testIdentifier = new DeviceTest(className, methodName);
                    DeviceTestResult.Builder resultBuilder = result.getMethodResultBuilder(testIdentifier);
                    if (resultBuilder != null) {
                        resultBuilder.addFile(file);
                        SpoonLogger.logInfo("Added file as result: " + file + " for " + testIdentifier, new Object[0]);
                        continue;
                    }
                    SpoonLogger.logError("Unable to find test for %s", testIdentifier);
                }
            }
        }
    }

    private void pullDeviceFiles(IDevice device) throws Exception {
        for (String dir : DEVICE_DIRS) {
            this.pullDirectory(device, dir);
        }
    }

    private void pullDirectory(IDevice device, String name) throws Exception {
        FileListingService.FileEntry internalDir = this.getDirectoryOnInternalStorage(name);
        SpoonLogger.logDebug(this.debug, "Internal path is " + internalDir.getFullPath(), new Object[0]);
        FileListingService.FileEntry externalDir = this.getDirectoryOnExternalStorage(device, name);
        SpoonLogger.logDebug(this.debug, "External path is " + externalDir.getFullPath(), new Object[0]);
        SpoonLogger.logDebug(this.debug, "Pulling files from external dir on [%s]", this.serial);
        String localDirName = this.work.getAbsolutePath();
        this.adbPull(device, externalDir, localDirName);
        SpoonLogger.logDebug(this.debug, "Pulling files from internal dir on [%s]", this.serial);
        this.adbPull(device, internalDir, localDirName);
        SpoonLogger.logDebug(this.debug, "Done pulling %s from on [%s]", name, this.serial);
    }

    private void adbPull(IDevice device, FileListingService.FileEntry remoteDirName, String localDirName) {
        try {
            device.getSyncService().pull(new FileListingService.FileEntry[]{remoteDirName}, localDirName, SyncService.getNullProgressMonitor());
        }
        catch (Exception e) {
            SpoonLogger.logDebug(this.debug, e.getMessage(), e);
        }
    }

    private void adbPullFile(IDevice device, String remoteFile, String localDir) {
        try {
            device.getSyncService().pullFile(remoteFile, localDir, SyncService.getNullProgressMonitor());
        }
        catch (Exception e) {
            SpoonLogger.logDebug(this.debug, e.getMessage(), e);
        }
    }

    private FileListingService.FileEntry getDirectoryOnInternalStorage(String dir) {
        String internalPath = this.getInternalPath(dir);
        return SpoonUtils.obtainDirectoryFileEntry(internalPath);
    }

    private String getInternalPath(String path) {
        String appPackage = this.instrumentationInfo.getApplicationPackage();
        return "/data/data/" + appPackage + "/" + path;
    }

    private FileListingService.FileEntry getDirectoryOnExternalStorage(IDevice device, String dir) throws Exception {
        String externalPath = this.getExternalStoragePath(device, dir);
        return SpoonUtils.obtainDirectoryFileEntry(externalPath);
    }

    private String getExternalStoragePath(IDevice device, String path) throws Exception {
        CollectingOutputReceiver pathNameOutputReceiver = new CollectingOutputReceiver();
        device.executeShellCommand("echo $EXTERNAL_STORAGE", (IShellOutputReceiver)pathNameOutputReceiver);
        return pathNameOutputReceiver.getOutput().trim() + "/" + path;
    }

    private static void mapLogsToTests(SpoonDeviceLogger deviceLogger, DeviceResult.Builder result) {
        Map<DeviceTest, List<LogCatMessage>> logs = deviceLogger.getParsedLogs();
        for (Map.Entry<DeviceTest, List<LogCatMessage>> entry : logs.entrySet()) {
            DeviceTestResult.Builder builder = result.getMethodResultBuilder(entry.getKey());
            if (builder == null) continue;
            builder.setLog(entry.getValue());
        }
    }

    public static void main(String ... args) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Must be started with a device directory.");
        }
        try {
            String outputDirName = args[0];
            File outputDir = new File(outputDirName);
            File executionFile = new File(outputDir, FILE_EXECUTION);
            if (!executionFile.exists()) {
                throw new IllegalArgumentException("Device directory and/or execution file doesn't exist.");
            }
            FileReader reader = new FileReader(executionFile);
            SpoonDeviceRunner target = (SpoonDeviceRunner)SpoonUtils.GSON.fromJson((Reader)reader, SpoonDeviceRunner.class);
            reader.close();
            AndroidDebugBridge adb = SpoonUtils.initAdb(target.sdk, target.adbTimeout);
            DeviceResult result = target.run(adb);
            AndroidDebugBridge.terminate();
            FileWriter writer = new FileWriter(new File(outputDir, FILE_RESULT));
            SpoonUtils.GSON.toJson((Object)result, (Appendable)writer);
            writer.close();
        }
        catch (Throwable ex) {
            SpoonLogger.logInfo("ERROR: Unable to execute test for target.  Exception message: %s", ex.getMessage());
            ex.printStackTrace(System.out);
            System.exit(1);
        }
    }
}

