/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.google.common.base.Preconditions;
import com.squareup.spoon.axmlparser.AXMLParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

final class SpoonInstrumentationInfo {
    private final String applicationPackage;
    private final Integer minSdkVersion;
    private final String instrumentationPackage;
    private final String testRunnerClass;

    SpoonInstrumentationInfo(String applicationPackage, Integer minSdkVersion, String instrumentationPackage, String testRunnerClass) {
        this.applicationPackage = applicationPackage;
        this.minSdkVersion = minSdkVersion;
        this.instrumentationPackage = instrumentationPackage;
        this.testRunnerClass = testRunnerClass;
    }

    String getApplicationPackage() {
        return this.applicationPackage;
    }

    Integer getMinSdkVersion() {
        return this.minSdkVersion;
    }

    String getInstrumentationPackage() {
        return this.instrumentationPackage;
    }

    String getTestRunnerClass() {
        return this.testRunnerClass;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    static SpoonInstrumentationInfo parseFromFile(File apkTestFile) {
        SpoonInstrumentationInfo spoonInstrumentationInfo;
        InputStream is = null;
        try {
            ZipFile zip = new ZipFile(apkTestFile);
            ZipEntry entry = zip.getEntry("AndroidManifest.xml");
            is = zip.getInputStream(entry);
            AXMLParser parser = new AXMLParser(is);
            int eventType = parser.getType();
            String appPackage = null;
            Integer minSdkVersion = null;
            String testPackage = null;
            String testRunnerClass = null;
            while (eventType != 1) {
                if (eventType == 2) {
                    String parserName = parser.getName();
                    boolean isManifest = "manifest".equals(parserName);
                    boolean isUsesSdk = "uses-sdk".equals(parserName);
                    boolean isInstrumentation = "instrumentation".equals(parserName);
                    if (isManifest || isInstrumentation || isUsesSdk) {
                        for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            String parserAttributeName = parser.getAttributeName(i);
                            if (isManifest && "package".equals(parserAttributeName)) {
                                testPackage = parser.getAttributeValueString(i);
                                continue;
                            }
                            if (isUsesSdk && "minSdkVersion".equals(parserAttributeName)) {
                                minSdkVersion = parser.getAttributeValue(i);
                                continue;
                            }
                            if (isInstrumentation && "targetPackage".equals(parserAttributeName)) {
                                appPackage = parser.getAttributeValueString(i);
                                continue;
                            }
                            if (!isInstrumentation || !"name".equals(parserAttributeName)) continue;
                            testRunnerClass = parser.getAttributeValueString(i);
                        }
                    }
                }
                eventType = parser.next();
            }
            Preconditions.checkNotNull(testPackage, (Object)"Could not find test application package.");
            Preconditions.checkNotNull(appPackage, (Object)"Could not find application package.");
            Preconditions.checkNotNull(testRunnerClass, (Object)"Could not find test runner class.");
            if (testRunnerClass.startsWith(".")) {
                testRunnerClass = testPackage + testRunnerClass;
            } else if (!testRunnerClass.contains(".")) {
                testRunnerClass = testPackage + "." + testRunnerClass;
            }
            spoonInstrumentationInfo = new SpoonInstrumentationInfo(appPackage, minSdkVersion, testPackage, testRunnerClass);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to parse test app AndroidManifest.xml.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return spoonInstrumentationInfo;
    }
}

