/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.google.common.base.Preconditions;
import com.squareup.spoon.DeviceResult;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class SpoonSummary {
    private final String title;
    private final IRemoteAndroidTestRunner.TestSize testSize;
    private final long started;
    private final long duration;
    private final Map<String, DeviceResult> results;

    private SpoonSummary(String title, IRemoteAndroidTestRunner.TestSize testSize, long started, long duration, Map<String, DeviceResult> results) {
        this.title = title;
        this.testSize = testSize;
        this.started = started;
        this.duration = duration;
        this.results = Collections.unmodifiableMap(new HashMap<String, DeviceResult>(results));
    }

    public String getTitle() {
        return this.title;
    }

    public IRemoteAndroidTestRunner.TestSize getTestSize() {
        return this.testSize;
    }

    public long getStarted() {
        return this.started;
    }

    public long getDuration() {
        return this.duration;
    }

    public Map<String, DeviceResult> getResults() {
        return this.results;
    }

    static class Builder {
        private final Map<String, DeviceResult> results = new HashMap<String, DeviceResult>();
        private String title;
        private IRemoteAndroidTestRunner.TestSize testSize;
        private long started;
        private long start;
        private long duration = -1L;

        Builder() {
        }

        Builder setTitle(String title) {
            Preconditions.checkNotNull((Object)title);
            Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"Title already set.");
            this.title = title;
            return this;
        }

        Builder setTestSize(IRemoteAndroidTestRunner.TestSize testSize) {
            Preconditions.checkNotNull((Object)testSize);
            Preconditions.checkArgument((testSize != null ? 1 : 0) != 0, (Object)"Test size already set.");
            this.testSize = testSize;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Builder addResult(String serial, DeviceResult result) {
            Preconditions.checkNotNull((Object)serial);
            Preconditions.checkNotNull((Object)result);
            Preconditions.checkArgument((this.start != 0L ? 1 : 0) != 0, (Object)"Start must be called before results can be added.");
            Map<String, DeviceResult> map = this.results;
            synchronized (map) {
                Preconditions.checkArgument((!this.results.containsKey(serial) ? 1 : 0) != 0, (Object)"Result for serial already added.");
                this.results.put(serial, result);
            }
            return this;
        }

        Builder start() {
            Preconditions.checkArgument((this.start == 0L ? 1 : 0) != 0, (Object)"Start already called.");
            this.start = System.nanoTime();
            this.started = new Date().getTime();
            return this;
        }

        Builder end() {
            Preconditions.checkArgument((this.start != 0L ? 1 : 0) != 0, (Object)"Start must be called before end.");
            Preconditions.checkArgument((this.duration == -1L ? 1 : 0) != 0, (Object)"End already called.");
            this.duration = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.start);
            return this;
        }

        SpoonSummary build() {
            Preconditions.checkNotNull((Object)this.title, (Object)"Title is required.");
            Preconditions.checkNotNull((Object)this.started, (Object)"Never started.");
            return new SpoonSummary(this.title, this.testSize, this.started, this.duration, this.results);
        }
    }
}

