/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon.html;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.squareup.spoon.DeviceDetails;
import com.squareup.spoon.DeviceResult;
import com.squareup.spoon.DeviceTest;
import com.squareup.spoon.DeviceTestResult;
import com.squareup.spoon.SpoonSummary;
import com.squareup.spoon.html.HtmlDevice;
import com.squareup.spoon.html.HtmlIndex;
import com.squareup.spoon.html.HtmlLog;
import com.squareup.spoon.html.HtmlTest;
import com.squareup.spoon.html.HtmlTv;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.lesscss.LessCompiler;

public final class HtmlRenderer {
    public static final String INDEX_FILENAME = "index.html";
    private static final String STATIC_DIRECTORY = "static";
    private static final String[] STATIC_ASSETS = new String[]{"bootstrap.min.css", "bootstrap-responsive.min.css", "bootstrap.min.js", "jquery.min.js", "jquery.nivo.slider.pack.js", "nivo-slider.css", "icon-animated.png", "icon-devices.png", "icon-log.png", "ceiling_android.png", "arrows.png", "bullets.png", "loading.gif"};
    private final SpoonSummary summary;
    private final Gson gson;
    private final File output;

    public HtmlRenderer(SpoonSummary summary, Gson gson, File output) {
        this.summary = summary;
        this.gson = gson;
        this.output = output;
    }

    public void render() {
        this.output.mkdirs();
        this.copyStaticAssets();
        this.generateCssFromLess();
        this.writeResultJson();
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory();
        this.generateTvHtml((MustacheFactory)mustacheFactory);
        this.generateIndexHtml((MustacheFactory)mustacheFactory);
        this.generateDeviceHtml((MustacheFactory)mustacheFactory);
        this.generateTestHtml((MustacheFactory)mustacheFactory);
        this.generateLogHtml((MustacheFactory)mustacheFactory);
    }

    private void copyStaticAssets() {
        File statics = new File(this.output, STATIC_DIRECTORY);
        statics.mkdir();
        for (String staticAsset : STATIC_ASSETS) {
            HtmlRenderer.copyStaticToOutput(staticAsset, statics);
        }
    }

    private void generateCssFromLess() {
        try {
            LessCompiler compiler = new LessCompiler();
            String less = Resources.toString((URL)this.getClass().getResource("/spoon.less"), (Charset)Charsets.UTF_8);
            String css = compiler.compile(less);
            File cssFile = FileUtils.getFile((File)this.output, (String[])new String[]{STATIC_DIRECTORY, "spoon.css"});
            FileUtils.writeStringToFile((File)cssFile, (String)css);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeResultJson() {
        FileWriter result = null;
        try {
            result = new FileWriter(new File(this.output, "result.json"));
            this.gson.toJson((Object)this.summary, (Appendable)result);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to write result.json file.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(result);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)result);
    }

    private void generateTvHtml(MustacheFactory mustacheFactory) {
        Mustache mustache = mustacheFactory.compile("page/tv.html");
        HtmlTv scope = HtmlTv.from(this.gson, this.summary, this.output);
        File file = new File(this.output, "tv.html");
        HtmlRenderer.renderMustacheToFile(mustache, scope, file);
    }

    private void generateIndexHtml(MustacheFactory mustacheFactory) {
        Mustache mustache = mustacheFactory.compile("page/index.html");
        HtmlIndex scope = HtmlIndex.from(this.summary);
        File file = new File(this.output, INDEX_FILENAME);
        HtmlRenderer.renderMustacheToFile(mustache, scope, file);
    }

    private void generateDeviceHtml(MustacheFactory mustacheFactory) {
        Mustache mustache = mustacheFactory.compile("page/device.html");
        for (Map.Entry<String, DeviceResult> entry : this.summary.getResults().entrySet()) {
            String serial = entry.getKey();
            HtmlDevice scope = HtmlDevice.from(serial, entry.getValue(), this.output);
            File file = FileUtils.getFile((File)this.output, (String[])new String[]{"device", serial + ".html"});
            HtmlRenderer.renderMustacheToFile(mustache, scope, file);
        }
    }

    private void generateTestHtml(MustacheFactory mustacheFactory) {
        Mustache mustache = mustacheFactory.compile("page/test.html");
        LinkedHashSet<DeviceTest> tests = new LinkedHashSet<DeviceTest>();
        for (DeviceResult deviceResult : this.summary.getResults().values()) {
            tests.addAll(deviceResult.getTestResults().keySet());
        }
        for (DeviceTest test : tests) {
            HtmlTest scope = HtmlTest.from(test, this.summary, this.output);
            File file = FileUtils.getFile((File)this.output, (String[])new String[]{"test", test.getClassName(), test.getMethodName() + ".html"});
            HtmlRenderer.renderMustacheToFile(mustache, scope, file);
        }
    }

    private void generateLogHtml(MustacheFactory mustacheFactory) {
        Mustache mustache = mustacheFactory.compile("page/log.html");
        for (Map.Entry<String, DeviceResult> resultEntry : this.summary.getResults().entrySet()) {
            String serial = resultEntry.getKey();
            DeviceResult result = resultEntry.getValue();
            DeviceDetails details = result.getDeviceDetails();
            String name = details != null ? details.getName() : serial;
            for (Map.Entry<DeviceTest, DeviceTestResult> entry : result.getTestResults().entrySet()) {
                DeviceTest test = entry.getKey();
                HtmlLog scope = HtmlLog.from(name, test, entry.getValue());
                File file = FileUtils.getFile((File)this.output, (String[])new String[]{"logs", serial, test.getClassName(), test.getMethodName() + ".html"});
                HtmlRenderer.renderMustacheToFile(mustache, scope, file);
            }
        }
    }

    private static void renderMustacheToFile(Mustache mustache, Object scope, File file) {
        FileWriter writer = null;
        try {
            file.getParentFile().mkdirs();
            writer = new FileWriter(file);
            mustache.execute((Writer)writer, scope);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    private static void copyStaticToOutput(String resource, File output) {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = HtmlRenderer.class.getResourceAsStream("/static/" + resource);
            os = new FileOutputStream(new File(output, resource));
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to copy static resource " + resource + " to " + output, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }
}

