/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jetbrains.annotations.NotNull;

public abstract class FileSetTestCase
extends TestSuite {
    private final File[] myFiles;
    protected Project myProject;
    private Pattern myPattern;

    public FileSetTestCase(@NotNull String path2) {
        if (path2 == null) {
            FileSetTestCase.$$$reportNull$$$0(0);
        }
        File f = new File(path2);
        if (f.isDirectory()) {
            this.myFiles = f.listFiles();
        } else if (f.exists()) {
            this.myFiles = new File[]{f};
        } else {
            throw new IllegalArgumentException("invalid path: " + path2);
        }
        String pattern = System.getProperty("fileset.pattern");
        this.myPattern = pattern != null ? Pattern.compile(pattern) : null;
        this.addAllTests();
    }

    protected FileSetTestCase(File @NotNull [] files2) {
        if (files2 == null) {
            FileSetTestCase.$$$reportNull$$$0(1);
        }
        this.myFiles = files2;
        this.addAllTests();
    }

    protected void setUp() {
    }

    protected void tearDown() {
        this.myProject = null;
    }

    private void addAllTests() {
        for (File file2 : this.myFiles) {
            if (!file2.isFile()) continue;
            this.addFileTest(file2);
        }
    }

    public abstract String transform(String var1, String[] var2) throws Exception;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void addFileTest(File file2) {
        if (!StringUtil.startsWithChar(file2.getName(), '_') && !"CVS".equals(file2.getName())) {
            if (this.myPattern != null && !this.myPattern.matcher(file2.getPath()).matches()) {
                return;
            }
            ActualTest t = new ActualTest(file2, FileSetTestCase.createTestName(file2));
            this.addTest((Test)t);
        }
    }

    protected String loadFile(File testFile) throws IOException {
        return FileUtil.loadFile(testFile);
    }

    protected String getDelimiter() {
        return "---";
    }

    private static String createTestName(File testFile) {
        return testFile.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "path";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "files";
                break;
            }
        }
        objectArray[1] = "com/intellij/FileSetTestCase";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ActualTest
    extends LightPlatformTestCase {
        private final File myTestFile;
        private final String myTestName;

        ActualTest(File testFile, String testName) {
            this.myTestFile = testFile;
            this.myTestName = testName;
        }

        @Override
        protected void setUp() throws Exception {
            super.setUp();
            FileSetTestCase.this.setUp();
        }

        @Override
        protected void tearDown() throws Exception {
            FileSetTestCase.this.tearDown();
            super.tearDown();
        }

        public int countTestCases() {
            return 1;
        }

        @Override
        protected void runTest() throws Throwable {
            int separatorIndex;
            String content2 = FileSetTestCase.this.loadFile(this.myTestFile);
            ActualTest.assertNotNull((Object)content2);
            ArrayList<String> input = new ArrayList<String>();
            content2 = StringUtil.replace(content2, "\r", "");
            while ((separatorIndex = content2.indexOf(FileSetTestCase.this.getDelimiter())) >= 0) {
                input.add(content2.substring(0, separatorIndex));
                content2 = content2.substring(separatorIndex);
                while (StringUtil.startsWithChar(content2, '-') || StringUtil.startsWithChar(content2, '\n')) {
                    content2 = content2.substring(1);
                }
            }
            String result2 = content2;
            ActualTest.assertTrue((String)"No data found in source file", (!input.isEmpty() ? 1 : 0) != 0);
            while (StringUtil.startsWithChar(result2, '-') || StringUtil.startsWithChar(result2, '\n') || StringUtil.startsWithChar(result2, '\r')) {
                result2 = result2.substring(1);
            }
            FileSetTestCase.this.myProject = this.getProject();
            String testName = this.myTestFile.getName();
            int dotIdx = testName.indexOf(46);
            if (dotIdx >= 0) {
                testName = testName.substring(0, dotIdx);
            }
            String transformed = StringUtil.replace(FileSetTestCase.this.transform(testName, ArrayUtilRt.toStringArray(input)), "\r", "");
            result2 = StringUtil.replace(result2, "\r", "");
            ActualTest.assertEquals((String)result2.trim(), (String)transformed.trim());
        }

        @Override
        @NotNull
        protected String getTestName(boolean lowercaseFirstLetter) {
            return "";
        }

        public String toString() {
            return this.myTestFile.getAbsolutePath() + " ";
        }

        @Override
        protected void resetAllFields() {
        }

        public String getName() {
            return this.myTestName;
        }
    }
}

