/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.dialog;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.annotations.Nullable;

public class VcsScopeItem
implements ModelScopeItem {
    private final ChangeListManager myChangeListManager;
    private final DefaultComboBoxModel<String> myModel;
    private final Project myProject;

    @Nullable
    public static VcsScopeItem createIfHasVCS(Project project2) {
        if (ChangeListManager.getInstance(project2).getAffectedFiles().isEmpty()) {
            return null;
        }
        return new VcsScopeItem(project2);
    }

    private VcsScopeItem(Project project2) {
        this.myProject = project2;
        this.myChangeListManager = ChangeListManager.getInstance(project2);
        assert (!this.myChangeListManager.getAffectedFiles().isEmpty());
        this.myModel = new DefaultComboBoxModel();
        this.myModel.addElement(VcsScopeItem.getAll());
        List<LocalChangeList> changeLists = this.myChangeListManager.getChangeListsCopy();
        for (ChangeList changeList : changeLists) {
            this.myModel.addElement(changeList.getName());
        }
    }

    @Override
    public AnalysisScope getScope() {
        Object selectedItem = this.myModel.getSelectedItem();
        if (selectedItem == null) {
            return null;
        }
        List<VirtualFile> files2 = selectedItem == VcsScopeItem.getAll() ? this.myChangeListManager.getAffectedFiles() : this.myChangeListManager.getChangeListsCopy().stream().filter(l -> Comparing.strEqual(l.getName(), (String)selectedItem)).flatMap(l -> ChangesUtil.getAfterRevisionsFiles(l.getChanges().stream())).collect(Collectors.toList());
        return new AnalysisScope(this.myProject, new HashSet<VirtualFile>(files2));
    }

    public DefaultComboBoxModel<String> getChangeListsModel() {
        return this.myModel;
    }

    private static String getAll() {
        return CodeInsightBundle.message("scope.option.uncommitted.files.all.changelists.choice", new Object[0]);
    }
}

