/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface AnalysisProblem {
    @NotNull
    public String getErrorMessage();

    @Nullable
    public String getCorrectionMessage();

    @Nullable
    public String getUrl();

    @NotNull
    public String getCode();

    public String getSeverity();

    public int getLineNumber();

    public int getOffset();

    @NotNull
    public String getSystemIndependentPath();

    @NotNull
    public String getPresentableLocationWithoutLineNumber();

    @NotNull
    public String getPresentableLocation();

    @Nullable
    public VirtualFile getFile();

    @Nullable
    public VirtualFile getPackageRoot();

    @Nullable
    public VirtualFile getContentRoot();

    @NotNull
    public List<AnalysisProblem> getSecondaryMessages();

    @NotNull
    public String getTooltip();

    @NotNull
    public static String generateTooltipText(@NotNull String message, @Nullable String correction, @Nullable String url) {
        if (message == null) {
            AnalysisProblem.$$$reportNull$$$0(0);
        }
        StringBuilder tooltip = new StringBuilder("<html>").append(XmlStringUtil.escapeString(message));
        if (StringUtil.isNotEmpty(correction)) {
            tooltip.append("<br/><br/>").append(XmlStringUtil.escapeString(correction));
        }
        if (StringUtil.isNotEmpty(url)) {
            tooltip.append("<br/><a href='").append(url).append("'>Open documentation</a>");
        }
        tooltip.append("</html>");
        String string = tooltip.toString();
        if (string == null) {
            AnalysisProblem.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/problemsView/AnalysisProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/problemsView/AnalysisProblem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateTooltipText";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

