/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.inspection;

import com.intellij.analysis.problemsView.AnalysisProblem;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HighlightingProblem
implements AnalysisProblem {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final HighlightInfo myInfo;

    HighlightingProblem(@NotNull Project project2, @NotNull VirtualFile virtualFile2, @NotNull HighlightInfo highlightInfo) {
        if (project2 == null) {
            HighlightingProblem.$$$reportNull$$$0(0);
        }
        if (virtualFile2 == null) {
            HighlightingProblem.$$$reportNull$$$0(1);
        }
        if (highlightInfo == null) {
            HighlightingProblem.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myVirtualFile = virtualFile2;
        this.myInfo = highlightInfo;
    }

    @Override
    @NotNull
    public String getErrorMessage() {
        String string = this.myInfo.getDescription();
        if (string == null) {
            HighlightingProblem.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public String getCorrectionMessage() {
        return null;
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.getFile().getUrl();
    }

    @Override
    @NotNull
    public String getCode() {
        return "";
    }

    @Override
    public String getSeverity() {
        if (this.myInfo.getSeverity() == HighlightSeverity.ERROR) {
            return "ERROR";
        }
        if (this.myInfo.getSeverity() == HighlightSeverity.WARNING) {
            return "WARNING";
        }
        return "INFO";
    }

    @Override
    public int getLineNumber() {
        Document document;
        PsiFile psiFile = PsiManager.getInstance(this.myProject).findFile(this.myVirtualFile);
        Document document2 = document = psiFile == null ? null : PsiDocumentManager.getInstance(this.myProject).getDocument(psiFile);
        if (document == null) {
            return 0;
        }
        return document.getLineNumber(this.myInfo.getActualStartOffset()) + 1;
    }

    @Override
    public int getOffset() {
        return this.myInfo.getActualStartOffset();
    }

    @Override
    @NotNull
    public String getSystemIndependentPath() {
        String string = this.getFile().getPath();
        if (string == null) {
            HighlightingProblem.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableLocationWithoutLineNumber() {
        String string = this.myVirtualFile.getName();
        if (string == null) {
            HighlightingProblem.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableLocation() {
        String string = this.getPresentableLocationWithoutLineNumber() + ":" + this.getLineNumber();
        if (string == null) {
            HighlightingProblem.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myVirtualFile;
        if (virtualFile2 == null) {
            HighlightingProblem.$$$reportNull$$$0(7);
        }
        return virtualFile2;
    }

    @Override
    @Nullable
    public VirtualFile getPackageRoot() {
        return null;
    }

    @Override
    @Nullable
    public VirtualFile getContentRoot() {
        return null;
    }

    @Override
    @NotNull
    public List<AnalysisProblem> getSecondaryMessages() {
        List<AnalysisProblem> list2 = Collections.emptyList();
        if (list2 == null) {
            HighlightingProblem.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getTooltip() {
        String string = ObjectUtils.notNull(this.myInfo.getToolTip(), this.getErrorMessage());
        if (string == null) {
            HighlightingProblem.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HighlightingProblem problem = (HighlightingProblem)o;
        return this.myInfo.equals(problem.myInfo);
    }

    public int hashCode() {
        return this.myInfo.hashCode();
    }

    public String toString() {
        return "H: " + this.getPresentableLocation();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/problemsView/inspection/HighlightingProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/problemsView/inspection/HighlightingProblem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemIndependentPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableLocationWithoutLineNumber";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableLocation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryMessages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

