/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.inspection;

import com.intellij.analysis.problemsView.AnalysisProblem;
import com.intellij.analysis.problemsView.AnalysisProblemsPresentationHelper;
import com.intellij.analysis.problemsView.inspection.InspectionProblemsViewSettings;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InspectionProblemsPresentationHelper
extends AnalysisProblemsPresentationHelper {
    @NotNull
    private InspectionProblemsViewSettings mySettings = new InspectionProblemsViewSettings();
    @Nullable
    private VirtualFile myCurrentFile;

    InspectionProblemsPresentationHelper() {
    }

    public void setSettings(@NotNull InspectionProblemsViewSettings settings) {
        if (settings == null) {
            InspectionProblemsPresentationHelper.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
    }

    @NotNull
    public InspectionProblemsViewSettings getSettings() {
        InspectionProblemsViewSettings inspectionProblemsViewSettings = this.mySettings;
        if (inspectionProblemsViewSettings == null) {
            InspectionProblemsPresentationHelper.$$$reportNull$$$0(1);
        }
        return inspectionProblemsViewSettings;
    }

    @Override
    public void resetAllFilters() {
        this.mySettings.showErrors = true;
        this.mySettings.showWarnings = true;
        this.mySettings.showHints = true;
        assert (!this.areFiltersApplied());
    }

    @Override
    public boolean areFiltersApplied() {
        if (!this.mySettings.showErrors) {
            return true;
        }
        if (!this.mySettings.showWarnings) {
            return true;
        }
        return !this.mySettings.showHints;
    }

    boolean setCurrentFile(@Nullable VirtualFile file2) {
        if (Comparing.equal(this.myCurrentFile, file2)) {
            return false;
        }
        this.myCurrentFile = file2;
        return true;
    }

    @Override
    public boolean isAutoScrollToSource() {
        return this.mySettings.autoScrollToSource;
    }

    @Override
    public void setAutoScrollToSource(boolean autoScroll) {
        this.mySettings.autoScrollToSource = autoScroll;
    }

    @Override
    public boolean isGroupBySeverity() {
        return this.mySettings.groupBySeverity;
    }

    @Override
    public void setGroupBySeverity(boolean groupBySeverity) {
        this.mySettings.groupBySeverity = groupBySeverity;
    }

    @Override
    public boolean isShowErrors() {
        return this.mySettings.showErrors;
    }

    @Override
    public boolean isShowWarnings() {
        return this.mySettings.showWarnings;
    }

    @Override
    public boolean isShowHints() {
        return this.mySettings.showHints;
    }

    @Override
    @Nullable
    public VirtualFile getCurrentFile() {
        return this.myCurrentFile;
    }

    @Override
    public boolean shouldShowProblem(@NotNull AnalysisProblem problem) {
        if (problem == null) {
            InspectionProblemsPresentationHelper.$$$reportNull$$$0(2);
        }
        if (!this.isShowErrors() && "ERROR".equals(problem.getSeverity())) {
            return false;
        }
        if (!this.isShowWarnings() && "WARNING".equals(problem.getSeverity())) {
            return false;
        }
        return this.isShowHints() || !"INFO".equals(problem.getSeverity());
    }

    @Override
    @NotNull
    public String getFilterTypeText() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("filtering by current file");
        if (!(this.isShowErrors() && this.isShowWarnings() && this.isShowHints())) {
            builder2.append(builder2.length() == 0 ? "filtering by severity" : " and severity");
        }
        String string = builder2.toString();
        if (string == null) {
            InspectionProblemsPresentationHelper.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/problemsView/inspection/InspectionProblemsPresentationHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/problemsView/inspection/InspectionProblemsPresentationHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

