/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.inspection;

import com.intellij.analysis.problemsView.AnalysisProblem;
import com.intellij.analysis.problemsView.inspection.InspectionProblemsPresentationHelper;
import com.intellij.analysis.problemsView.inspection.InspectionProblemsViewPanel;
import com.intellij.analysis.problemsView.inspection.InspectionProblemsViewSettings;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InspectionProblemsView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class InspectionProblemsView
implements PersistentStateComponent<InspectionProblemsViewSettings> {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup(InspectionProblemsView.getToolWindowId(), InspectionProblemsView.getToolWindowId(), false);
    private final Project myProject;
    private final InspectionProblemsPresentationHelper myPresentationHelper;
    private final Object myLock;
    private final Alarm myAlarm;
    @NotNull
    private Icon myCurrentIcon;
    private boolean myAnalysisIsBusy;
    private Notification myNotification;
    private boolean myDisabledForSession;
    private final Queue<AnalysisProblem> myProblems;
    private static final String OPEN_DART_ANALYSIS_LINK = "open.dart.analysis";

    public InspectionProblemsView(@NotNull Project project2) {
        if (project2 == null) {
            InspectionProblemsView.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myCurrentIcon = AllIcons.Toolwindows.NoEvents;
        this.myProblems = new ConcurrentLinkedQueue<AnalysisProblem>();
        this.myProject = project2;
        this.myPresentationHelper = new InspectionProblemsPresentationHelper();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, project2);
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, new FileEditorManagerListener(){

            @Override
            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                InspectionProblemsView.this.updateCurrentFile();
            }

            @Override
            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                InspectionProblemsView.this.updateCurrentFile();
            }

            @Override
            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                InspectionProblemsView.this.updateCurrentFile();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/analysis/problemsView/inspection/InspectionProblemsView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ApplicationManager.getApplication().invokeLater(this::updateCurrentFile, project2.getDisposed());
    }

    private void updateCurrentFile() {
        FileEditor editor = FileEditorManager.getInstance(this.myProject).getSelectedEditor();
        VirtualFile file2 = editor == null ? null : editor.getFile();
        this.setCurrentFile(file2);
    }

    @NotNull
    InspectionProblemsPresentationHelper getPresentationHelper() {
        InspectionProblemsPresentationHelper inspectionProblemsPresentationHelper = this.myPresentationHelper;
        if (inspectionProblemsPresentationHelper == null) {
            InspectionProblemsView.$$$reportNull$$$0(1);
        }
        return inspectionProblemsPresentationHelper;
    }

    ToolWindow getToolWindow() {
        return ToolWindowManager.getInstance(this.myProject).getToolWindow(InspectionProblemsView.getToolWindowId());
    }

    private InspectionProblemsViewPanel getProblemsViewPanel() {
        ToolWindow toolWindow = this.getToolWindow();
        Content content2 = toolWindow != null ? toolWindow.getContentManager().getContent(0) : null;
        return content2 != null ? (InspectionProblemsViewPanel)content2.getComponent() : null;
    }

    void setHeaderText(@NotNull String headerText) {
        ToolWindow toolWindow;
        Content content2;
        if (headerText == null) {
            InspectionProblemsView.$$$reportNull$$$0(2);
        }
        Content content3 = content2 = (toolWindow = this.getToolWindow()) != null ? toolWindow.getContentManager().getContent(0) : null;
        if (content2 != null) {
            content2.setDisplayName(headerText);
        }
    }

    void setToolWindowIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            InspectionProblemsView.$$$reportNull$$$0(3);
        }
        this.myCurrentIcon = icon2;
        this.updateIcon();
    }

    private void updateIcon() {
        ToolWindow toolWindow = this.getToolWindow();
        if (toolWindow == null) {
            return;
        }
        if (this.myAnalysisIsBusy) {
            toolWindow.setIcon(ExecutionUtil.getLiveIndicator(this.myCurrentIcon));
        } else {
            toolWindow.setIcon(this.myCurrentIcon);
        }
    }

    public static InspectionProblemsView getInstance(@NotNull Project project2) {
        if (project2 == null) {
            InspectionProblemsView.$$$reportNull$$$0(4);
        }
        return ServiceManager.getService(project2, InspectionProblemsView.class);
    }

    public VirtualFile getCurrentFile() {
        return this.myPresentationHelper.getCurrentFile();
    }

    public void showWarningNotification(@NotNull String title, @Nullable String content2, @Nullable Icon icon2) {
        if (title == null) {
            InspectionProblemsView.$$$reportNull$$$0(5);
        }
        this.showNotification(NotificationType.WARNING, title, content2, icon2, false);
    }

    public void showErrorNotificationTerse(@NotNull String title) {
        if (title == null) {
            InspectionProblemsView.$$$reportNull$$$0(6);
        }
        this.showNotification(NotificationType.ERROR, title, null, null, true);
    }

    public void showErrorNotification(@NotNull String title, @Nullable String content2, @Nullable Icon icon2) {
        if (title == null) {
            InspectionProblemsView.$$$reportNull$$$0(7);
        }
        this.showNotification(NotificationType.ERROR, title, content2, icon2, false);
    }

    private void clearNotifications() {
        if (this.myNotification != null) {
            this.myNotification.expire();
            this.myNotification = null;
        }
    }

    private void showNotification(@NotNull NotificationType notificationType, @NotNull String title, @Nullable String content2, @Nullable Icon icon2, boolean terse) {
        if (notificationType == null) {
            InspectionProblemsView.$$$reportNull$$$0(8);
        }
        if (title == null) {
            InspectionProblemsView.$$$reportNull$$$0(9);
        }
        this.clearNotifications();
        if (this.myDisabledForSession) {
            return;
        }
        content2 = StringUtil.notNullize(content2);
        if (!terse) {
            if (!content2.endsWith("<br>")) {
                content2 = content2 + "<br>";
            }
            content2 = content2 + "<br><a href='disable.for.session'>Don't show for this session</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href='never.show.again'>Never show again</a>";
        }
        this.myNotification = NOTIFICATION_GROUP.createNotification(title, content2, notificationType, new NotificationListener.Adapter(){

            @Override
            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                notification.expire();
                if (InspectionProblemsView.OPEN_DART_ANALYSIS_LINK.equals(e.getDescription())) {
                    ToolWindow toolWindow = InspectionProblemsView.this.getToolWindow();
                    if (toolWindow != null) {
                        toolWindow.activate(null);
                    }
                } else if ("disable.for.session".equals(e.getDescription())) {
                    InspectionProblemsView.this.myDisabledForSession = true;
                } else if ("never.show.again".equals(e.getDescription())) {
                    NOTIFICATION_GROUP.createNotification("Warning disabled.", "You can enable it back in the <a href=''>Event Log</a> settings.", NotificationType.INFORMATION, new NotificationListener.Adapter(){

                        @Override
                        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                            if (notification == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (e == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            notification.expire();
                            ToolWindow toolWindow = EventLog.getEventLog(InspectionProblemsView.this.myProject);
                            if (toolWindow != null) {
                                toolWindow.activate(null);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "notification";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "e";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/analysis/problemsView/inspection/InspectionProblemsView$2$1";
                            objectArray[2] = "hyperlinkActivated";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }).notify(InspectionProblemsView.this.myProject);
                    NotificationSettings oldSettings = NotificationsConfigurationImpl.getSettings(notification.getGroupId());
                    NotificationsConfigurationImpl.getInstanceImpl().changeSettings(oldSettings.getGroupId(), NotificationDisplayType.NONE, oldSettings.isShouldLog(), oldSettings.isShouldReadAloud());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/analysis/problemsView/inspection/InspectionProblemsView$2";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (icon2 != null) {
            this.myNotification.setIcon(icon2);
        }
        this.myNotification.notify(this.myProject);
    }

    @Override
    public InspectionProblemsViewSettings getState() {
        return this.myPresentationHelper.getSettings();
    }

    @Override
    public void loadState(@NotNull InspectionProblemsViewSettings state) {
        if (state == null) {
            InspectionProblemsView.$$$reportNull$$$0(10);
        }
        this.myPresentationHelper.setSettings(state);
    }

    private void setCurrentFile(@Nullable VirtualFile file2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        InspectionProblemsViewPanel panel2 = this.getProblemsViewPanel();
        if (panel2 != null) {
            this.myPresentationHelper.setCurrentFile(file2);
            panel2.setCurrentFile(file2);
            panel2.fireGroupingOrFilterChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            this.myAlarm.cancelAllRequests();
        }
        InspectionProblemsViewPanel panel2 = this.getProblemsViewPanel();
        if (panel2 != null) {
            panel2.clearAll();
        }
    }

    @NotNull
    private static String getToolWindowId() {
        return "Problems View";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/problemsView/inspection/InspectionProblemsView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/problemsView/inspection/InspectionProblemsView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setHeaderText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindowIcon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showWarningNotification";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotificationTerse";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

