/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.inspection;

import com.intellij.analysis.problemsView.AnalysisProblem;
import com.intellij.analysis.problemsView.AnalysisProblemsTableModel;
import com.intellij.analysis.problemsView.AnalysisProblemsViewPanel;
import com.intellij.analysis.problemsView.inspection.HighlightingProblem;
import com.intellij.analysis.problemsView.inspection.InspectionProblemsPresentationHelper;
import com.intellij.analysis.problemsView.inspection.InspectionProblemsView;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InspectionProblemsViewPanel
extends AnalysisProblemsViewPanel {
    @NotNull
    private final InspectionProblemsPresentationHelper myPresentationHelper;
    private Disposable myCurrentFileDisposable;

    InspectionProblemsViewPanel(@NotNull Project project2, @NotNull InspectionProblemsPresentationHelper presentationHelper) {
        if (project2 == null) {
            InspectionProblemsViewPanel.$$$reportNull$$$0(0);
        }
        if (presentationHelper == null) {
            InspectionProblemsViewPanel.$$$reportNull$$$0(1);
        }
        super(project2, presentationHelper);
        this.myCurrentFileDisposable = Disposer.newDisposable();
        this.myPresentationHelper = presentationHelper;
    }

    @Override
    protected void addQuickFixActions(@NotNull DefaultActionGroup group, @Nullable AnalysisProblem problem) {
        VirtualFile selectedVFile;
        if (group == null) {
            InspectionProblemsViewPanel.$$$reportNull$$$0(2);
        }
        VirtualFile virtualFile2 = selectedVFile = problem != null ? problem.getFile() : null;
        if (selectedVFile == null) {
            return;
        }
    }

    @Override
    protected void updateStatusDescription() {
        InspectionProblemsView problemsView = InspectionProblemsView.getInstance(this.myProject);
        problemsView.setHeaderText(this.getModel().getStatusText());
        problemsView.setToolWindowIcon(this.getStatusIcon());
    }

    @Override
    protected void addActionsTo(@NotNull DefaultActionGroup group) {
        if (group == null) {
            InspectionProblemsViewPanel.$$$reportNull$$$0(3);
        }
        group.addSeparator();
        this.addAutoScrollToSourceAction(group);
        this.addGroupBySeverityAction(group);
        group.addSeparator();
    }

    void addProblem(@NotNull AnalysisProblem problem) {
        if (problem == null) {
            InspectionProblemsViewPanel.$$$reportNull$$$0(4);
        }
        AnalysisProblem oldSelectedProblem = (AnalysisProblem)this.myTable.getSelectedObject();
        AnalysisProblemsTableModel model = this.getModel();
        model.removeRows(p -> p.equals(problem));
        AnalysisProblem updatedSelectedProblem = model.addProblemsAndReturnReplacementForSelection(Collections.singletonList(problem), oldSelectedProblem);
        if (updatedSelectedProblem != null) {
            this.myTable.setSelection(Collections.singletonList(updatedSelectedProblem));
        }
        this.updateStatusDescription();
    }

    public void setCurrentFile(@Nullable VirtualFile file2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        AnalysisProblemsTableModel model = this.getModel();
        model.removeRows(problem -> !Comparing.equal(problem.getFile(), file2));
        if (file2 != null) {
            Document document;
            PsiFile psiFile = PsiManager.getInstance(this.myProject).findFile(file2);
            Document document2 = document = psiFile == null ? null : PsiDocumentManager.getInstance(this.myProject).getDocument(psiFile);
            if (document != null) {
                Disposer.dispose(this.myCurrentFileDisposable);
                this.myCurrentFileDisposable = Disposer.newDisposable();
                Disposer.register(this.myProject, this.myCurrentFileDisposable);
                MarkupModelEx markupModelEx = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.myProject, true);
                markupModelEx.addMarkupModelListener(this.myCurrentFileDisposable, new MarkupModelListener(){

                    @Override
                    public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                        if (highlighter == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        InspectionProblemsViewPanel.this.highlighterAdded(highlighter);
                    }

                    @Override
                    public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                        if (highlighter == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        InspectionProblemsViewPanel.this.highlighterRemoved(highlighter);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "highlighter";
                        objectArray2[1] = "com/intellij/analysis/problemsView/inspection/InspectionProblemsViewPanel$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "afterAdded";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "beforeRemoved";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                markupModelEx.processRangeHighlightersOverlappingWith(0, document.getTextLength(), r -> {
                    this.highlighterAdded((RangeHighlighterEx)r);
                    return true;
                });
            }
        }
        this.updateStatusDescription();
    }

    private void highlighterRemoved(@NotNull RangeHighlighterEx highlighter) {
        HighlightInfo info;
        Object tooltip;
        if (highlighter == null) {
            InspectionProblemsViewPanel.$$$reportNull$$$0(5);
        }
        if ((tooltip = highlighter.getErrorStripeTooltip()) instanceof HighlightInfo && (info = (HighlightInfo)tooltip).getDescription() != null) {
            HighlightingProblem problem = new HighlightingProblem(this.myProject, this.myPresentationHelper.getCurrentFile(), info);
            this.getModel().removeRows(p -> p.equals(problem));
            this.updateStatusDescription();
        }
    }

    private void highlighterAdded(@NotNull RangeHighlighterEx highlighter) {
        HighlightInfo info;
        Object tooltip;
        if (highlighter == null) {
            InspectionProblemsViewPanel.$$$reportNull$$$0(6);
        }
        if ((tooltip = highlighter.getErrorStripeTooltip()) instanceof HighlightInfo && (info = (HighlightInfo)tooltip).getDescription() != null) {
            HighlightingProblem problem = new HighlightingProblem(this.myProject, this.myPresentationHelper.getCurrentFile(), info);
            this.addProblem(problem);
        }
    }

    @Override
    @NotNull
    protected Icon getStatusIcon() {
        AnalysisProblemsTableModel model = this.getModel();
        Icon icon2 = model.hasErrors() ? AllIcons.Toolwindows.ErrorEvents : (model.hasWarnings() ? AllIcons.Toolwindows.Problems : AllIcons.Toolwindows.NoEvents);
        if (icon2 == null) {
            InspectionProblemsViewPanel.$$$reportNull$$$0(7);
        }
        return icon2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/problemsView/inspection/InspectionProblemsViewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/problemsView/inspection/InspectionProblemsViewPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addQuickFixActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addActionsTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addProblem";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "highlighterRemoved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "highlighterAdded";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

