/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public class ExperimentsDialog
extends DialogWrapper {
    protected ExperimentsDialog(@Nullable Project project2) {
        super(project2);
        this.init();
        this.setTitle(IdeBundle.message("dialog.title.experimental.features", new Object[0]));
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        ExperimentalFeature[] features = Experiments.EP_NAME.getExtensions();
        JBTable table = new JBTable(ExperimentsDialog.createModel(features));
        table.getEmptyText().setText(IdeBundle.message("empty.text.no.features.available", new Object[0]));
        table.getColumnModel().getColumn(0).setCellRenderer(ExperimentsDialog.getIdRenderer());
        table.getColumnModel().getColumn(1).setCellRenderer(ExperimentsDialog.getValueRenderer());
        table.getColumnModel().getColumn(1).setCellEditor(new BooleanTableCellEditor());
        table.setStriped(true);
        table.getSelectionModel().setSelectionMode(0);
        JTextArea myDescription = new JTextArea(4, 50);
        myDescription.setMargin(JBUI.insets(2));
        myDescription.setWrapStyleWord(true);
        myDescription.setLineWrap(true);
        myDescription.setEditable(false);
        table.getSelectionModel().addListSelectionListener(e -> myDescription.setText(features[table.getSelectedRow()].description));
        JScrollPane label2 = ScrollPaneFactory.createScrollPane(myDescription);
        BorderLayoutPanel descriptionPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel(label2).withBorder(IdeBorderFactory.createTitledBorder(IdeBundle.message("border.title.description", new Object[0]), false));
        return JBUI.Panels.simplePanel(ScrollPaneFactory.createScrollPane(table)).addToBottom(descriptionPanel);
    }

    @Override
    @Nullable
    protected String getDimensionServiceKey() {
        return "ExperimentsDialog";
    }

    private static TableCellRenderer getValueRenderer() {
        return new BooleanTableCellRenderer(0);
    }

    private static TableCellRenderer getIdRenderer() {
        return new ColoredTableCellRenderer(){

            @Override
            protected void customizeCellRenderer(JTable table, @Nullable Object value2, boolean selected2, boolean hasFocus, int row, int column) {
                this.append(String.valueOf(value2));
            }
        };
    }

    private static TableModel createModel(final ExperimentalFeature[] experimentalFeatures) {
        return new AbstractTableModel(){
            final ExperimentalFeature[] features;
            {
                this.features = experimentalFeatures;
            }

            @Override
            public int getRowCount() {
                return this.features.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                String id2 = this.features[rowIndex].id;
                switch (columnIndex) {
                    case 0: {
                        return id2;
                    }
                    case 1: {
                        return Experiments.getInstance().isFeatureEnabled(id2);
                    }
                }
                throw new IllegalArgumentException("Wrong column number");
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Enabled";
                    }
                }
                throw new IllegalArgumentException("Wrong column number");
            }

            @Override
            public void setValueAt(Object value2, int rowIndex, int columnIndex) {
                if (value2 instanceof Boolean) {
                    Experiments.getInstance().setFeatureEnabled(this.features[rowIndex].id, (Boolean)value2);
                }
            }
        };
    }
}

