/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.DynamicBundle;
import com.intellij.application.options.OptionId;
import com.intellij.application.options.OptionsApplicabilityFilter;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DataManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class CodeCompletionPanel {
    JPanel myPanel;
    private JCheckBox myCbAutocompletion;
    private JCheckBox myCbAutopopupJavaDoc;
    private JTextField myAutopopupJavaDocField;
    private JLabel myAutoInsertLabel;
    private JCheckBox myCbOnCodeCompletion;
    private JCheckBox myCbOnSmartTypeCompletion;
    private JCheckBox myCbParameterInfoPopup;
    private JTextField myParameterInfoDelayField;
    private JCheckBox myCbShowFullParameterSignatures;
    private JCheckBox myCbSorting;
    private JBCheckBox myCbSelectByChars;
    private JCheckBox myCbCompleteFunctionWithParameters;
    private JBCheckBox myCbMatchCase;
    private JBRadioButton myFirstLetterOnly;
    private JBRadioButton myAllLetters;
    private JBLabel myBasicShortcut;
    private JBLabel mySmartShortcut;
    private JPanel myCbOnCodeCompletionPanel;
    private JPanel myCbOnSmartTypeCompletionPanel;
    private JPanel myAddonPanelAfter;
    private JPanel myAddonPanelBefore;

    public CodeCompletionPanel(List<? extends JComponent> optionAddons, List<? extends JComponent> sectionAddons) {
        ChangeListener updateCaseCheckboxes = __ -> {
            this.myFirstLetterOnly.setEnabled(this.myCbMatchCase.isSelected());
            this.myAllLetters.setEnabled(this.myCbMatchCase.isSelected());
        };
        this.$$$setupUI$$$();
        this.myCbMatchCase.addChangeListener(updateCaseCheckboxes);
        updateCaseCheckboxes.stateChanged(null);
        ActionManager actionManager = ActionManager.getInstance();
        this.myBasicShortcut.setText(KeymapUtil.getFirstKeyboardShortcutText(actionManager.getAction("CodeCompletion")));
        this.mySmartShortcut.setText(KeymapUtil.getFirstKeyboardShortcutText(actionManager.getAction("SmartTypeCompletion")));
        this.myBasicShortcut.setForeground(JBColor.GRAY);
        this.mySmartShortcut.setForeground(JBColor.GRAY);
        this.myCbSelectByChars.setText(IdeUICustomization.getInstance().getSelectAutopopupByCharsText());
        this.myCbAutocompletion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean selected2 = CodeCompletionPanel.this.myCbAutocompletion.isSelected();
                CodeCompletionPanel.this.myCbSelectByChars.setEnabled(selected2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/CodeCompletionPanel$1", "actionPerformed"));
            }
        });
        this.myCbAutopopupJavaDoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                CodeCompletionPanel.this.myAutopopupJavaDocField.setEnabled(CodeCompletionPanel.this.myCbAutopopupJavaDoc.isSelected());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/CodeCompletionPanel$2", "actionPerformed"));
            }
        });
        this.myCbParameterInfoPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                CodeCompletionPanel.this.myParameterInfoDelayField.setEnabled(CodeCompletionPanel.this.myCbParameterInfoPopup.isSelected());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/application/options/CodeCompletionPanel$3", "actionPerformed"));
            }
        });
        CodeCompletionPanel.hideOption(this.myCbOnSmartTypeCompletionPanel, OptionId.COMPLETION_SMART_TYPE);
        CodeCompletionPanel.hideOption(this.myCbOnCodeCompletionPanel, OptionId.AUTOCOMPLETE_ON_BASIC_CODE_COMPLETION);
        CodeCompletionPanel.hideOption(this.myCbCompleteFunctionWithParameters, OptionId.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION);
        if (!this.myCbOnSmartTypeCompletionPanel.isVisible() && !this.myCbOnCodeCompletionPanel.isVisible()) {
            this.myAutoInsertLabel.setVisible(false);
        }
        CodeCompletionPanel.addExtensions(optionAddons, this.myAddonPanelBefore);
        CodeCompletionPanel.addExtensions(sectionAddons, this.myAddonPanelAfter);
        this.reset();
    }

    private static void addExtensions(@NotNull List<? extends JComponent> customComponents, @NotNull JPanel addonPanel) {
        if (customComponents == null) {
            CodeCompletionPanel.$$$reportNull$$$0(0);
        }
        if (addonPanel == null) {
            CodeCompletionPanel.$$$reportNull$$$0(1);
        }
        if (customComponents.isEmpty()) {
            addonPanel.setVisible(false);
            return;
        }
        GridLayoutManager manager = new GridLayoutManager(customComponents.size(), 1);
        addonPanel.setLayout((LayoutManager)manager);
        GridConstraints gc = new GridConstraints();
        gc.setUseParentLayout(true);
        gc.setFill(3);
        gc.setVSizePolicy(1);
        for (int i = 0; i < customComponents.size(); ++i) {
            JComponent c = customComponents.get(i);
            gc.setRow(i);
            addonPanel.add((Component)c, gc);
        }
    }

    private static void hideOption(JComponent component2, OptionId id2) {
        component2.setVisible(OptionsApplicabilityFilter.isApplicable(id2));
    }

    public void reset() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        switch (codeInsightSettings.COMPLETION_CASE_SENSITIVE) {
            case 1: {
                this.myCbMatchCase.setSelected(true);
                this.myAllLetters.setSelected(true);
                break;
            }
            case 2: {
                this.myCbMatchCase.setSelected(false);
                break;
            }
            default: {
                this.myCbMatchCase.setSelected(true);
                this.myFirstLetterOnly.setSelected(true);
            }
        }
        this.myCbSelectByChars.setSelected(codeInsightSettings.isSelectAutopopupSuggestionsByChars());
        this.myCbOnCodeCompletion.setSelected(codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION);
        this.myCbOnSmartTypeCompletion.setSelected(codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION);
        this.myCbAutocompletion.setSelected(codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP);
        this.myCbAutopopupJavaDoc.setSelected(codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        this.myAutopopupJavaDocField.setEnabled(codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        this.myAutopopupJavaDocField.setText(String.valueOf(codeInsightSettings.JAVADOC_INFO_DELAY));
        this.myCbParameterInfoPopup.setSelected(codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        this.myParameterInfoDelayField.setEnabled(codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        this.myParameterInfoDelayField.setText(String.valueOf(codeInsightSettings.PARAMETER_INFO_DELAY));
        this.myCbShowFullParameterSignatures.setSelected(codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO);
        this.myCbCompleteFunctionWithParameters.setSelected(codeInsightSettings.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION);
        this.myCbAutocompletion.setSelected(codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP);
        this.myCbSorting.setSelected(UISettings.getInstance().getSortLookupElementsLexicographically());
        this.myCbAutocompletion.setText(ApplicationBundle.message("editbox.auto.complete", new Object[0]) + (PowerSaveMode.isEnabled() ? LangBundle.message("label.not.available.in.power.save.mode", new Object[0]) : ""));
    }

    public void apply() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        codeInsightSettings.COMPLETION_CASE_SENSITIVE = this.getCaseSensitiveValue();
        codeInsightSettings.setSelectAutopopupSuggestionsByChars(this.myCbSelectByChars.isSelected());
        codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION = this.myCbOnCodeCompletion.isSelected();
        codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION = this.myCbOnSmartTypeCompletion.isSelected();
        codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO = this.myCbShowFullParameterSignatures.isSelected();
        codeInsightSettings.AUTO_POPUP_PARAMETER_INFO = this.myCbParameterInfoPopup.isSelected();
        codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP = this.myCbAutocompletion.isSelected();
        codeInsightSettings.AUTO_POPUP_JAVADOC_INFO = this.myCbAutopopupJavaDoc.isSelected();
        codeInsightSettings.PARAMETER_INFO_DELAY = CodeCompletionPanel.getIntegerValue(this.myParameterInfoDelayField.getText());
        codeInsightSettings.JAVADOC_INFO_DELAY = CodeCompletionPanel.getIntegerValue(this.myAutopopupJavaDocField.getText());
        codeInsightSettings.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION = this.myCbCompleteFunctionWithParameters.isSelected();
        UISettings.getInstance().setSortLookupElementsLexicographically(this.myCbSorting.isSelected());
        Project project2 = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(this.myPanel));
        if (project2 != null) {
            DaemonCodeAnalyzer.getInstance(project2).settingsChanged();
        }
    }

    public boolean isModified() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        boolean isModified = false;
        isModified |= this.getCaseSensitiveValue() != codeInsightSettings.COMPLETION_CASE_SENSITIVE;
        isModified |= CodeCompletionPanel.isModified(this.myCbOnCodeCompletion, codeInsightSettings.AUTOCOMPLETE_ON_CODE_COMPLETION);
        isModified |= CodeCompletionPanel.isModified(this.myCbSelectByChars, codeInsightSettings.isSelectAutopopupSuggestionsByChars());
        isModified |= CodeCompletionPanel.isModified(this.myCbOnSmartTypeCompletion, codeInsightSettings.AUTOCOMPLETE_ON_SMART_TYPE_COMPLETION);
        isModified |= CodeCompletionPanel.isModified(this.myCbShowFullParameterSignatures, codeInsightSettings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myCbParameterInfoPopup, codeInsightSettings.AUTO_POPUP_PARAMETER_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myCbAutocompletion, codeInsightSettings.AUTO_POPUP_COMPLETION_LOOKUP);
        isModified |= CodeCompletionPanel.isModified(this.myCbCompleteFunctionWithParameters, codeInsightSettings.SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION);
        isModified |= CodeCompletionPanel.isModified(this.myCbAutopopupJavaDoc, codeInsightSettings.AUTO_POPUP_JAVADOC_INFO);
        isModified |= CodeCompletionPanel.isModified(this.myParameterInfoDelayField, codeInsightSettings.PARAMETER_INFO_DELAY);
        isModified |= CodeCompletionPanel.isModified(this.myAutopopupJavaDocField, codeInsightSettings.JAVADOC_INFO_DELAY);
        return isModified |= CodeCompletionPanel.isModified(this.myCbSorting, UISettings.getInstance().getSortLookupElementsLexicographically());
    }

    private static boolean isModified(JCheckBox checkBox2, boolean value2) {
        return checkBox2.isSelected() != value2;
    }

    private static boolean isModified(JTextField textField2, int value2) {
        return CodeCompletionPanel.getIntegerValue(textField2.getText()) != value2;
    }

    private static int getIntegerValue(String s) {
        int value2 = StringUtilRt.parseInt(s, 0);
        return value2 < 0 ? 0 : value2;
    }

    private int getCaseSensitiveValue() {
        if (!this.myCbMatchCase.isSelected()) {
            return 2;
        }
        return this.myAllLetters.isSelected() ? 1 : 3;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JBLabel jBLabel;
        JCheckBox jCheckBox4;
        JPanel jPanel3;
        JBLabel jBLabel2;
        JCheckBox jCheckBox5;
        JPanel jPanel4;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JTextField jTextField2;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JLabel jLabel;
        JCheckBox jCheckBox8;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel5).setEnabled(true);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.putClientProperty("html.disable", Boolean.FALSE);
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myCbSorting = jCheckBox8 = new JCheckBox();
        jCheckBox8.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox8, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("completion.option.sort.suggestions.alphabetically"));
        jPanel7.add((Component)jCheckBox8, new GridConstraints(4, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myAutoInsertLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("label.autocomplete.when.only.one.choice"));
        jPanel7.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbAutocompletion = jCheckBox7 = new JCheckBox();
        jCheckBox7.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("editbox.auto.complete"));
        jPanel7.add((Component)jCheckBox7, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbAutopopupJavaDoc = jCheckBox6 = new JCheckBox();
        jCheckBox6.setMargin(new Insets(2, 2, 0, 2));
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("editbox.autopopup.javadoc.in"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel9.add((Component)jCheckBox6, gridBagConstraints);
        this.myAutopopupJavaDocField = jTextField2 = new JTextField();
        jTextField2.setColumns(4);
        jTextField2.setText("1000");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
        jPanel9.add((Component)jTextField2, gridBagConstraints2);
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$(jBLabel3, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("editbox.ms"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.anchor = 17;
        jPanel9.add((Component)jBLabel3, gridBagConstraints3);
        this.myCbSelectByChars = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$(jBCheckBox2, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("completion.option.insert.selected.suggestion"));
        jPanel7.add((Component)jBCheckBox2, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridBagLayout());
        jPanel7.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 8, 2, 1, 3, null, null, null));
        this.myCbMatchCase = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$(jBCheckBox, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("completion.option.match.case"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        jPanel10.add((Component)jBCheckBox, gridBagConstraints4);
        this.myFirstLetterOnly = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jBRadioButton2, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("completion.option.first.letter.only"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 0;
        jPanel10.add((Component)jBRadioButton2, gridBagConstraints5);
        this.myAllLetters = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$(jBRadioButton, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("completion.option.all.letters"));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 0;
        jPanel10.add((Component)jBRadioButton, gridBagConstraints6);
        this.myCbOnCodeCompletionPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbOnCodeCompletion = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("checkbox.autocomplete.basic"));
        jPanel4.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myBasicShortcut = jBLabel2 = new JBLabel();
        ((JLabel)jBLabel2).setText("Ctrl+Space");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCbOnSmartTypeCompletionPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbOnSmartTypeCompletion = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(2, 2, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("checkbox.autocomplete.smart.type"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.mySmartShortcut = jBLabel = new JBLabel();
        ((JLabel)jBLabel).setText("Ctrl+Shift+Space");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel11, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel11.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("title.parameter.info"), 0, 0, null, null));
        this.myCbShowFullParameterSignatures = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("checkbox.show.full.signatures"));
        jPanel11.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(186, 22), null));
        this.myCbCompleteFunctionWithParameters = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("editbox.complete.with.parameters"));
        jPanel11.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(186, 22), null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridBagLayout());
        jPanel11.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbParameterInfoPopup = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("editbox.autopopup.in"));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 0;
        gridBagConstraints7.weighty = 1.0;
        gridBagConstraints7.anchor = 17;
        jPanel12.add((Component)jCheckBox, gridBagConstraints7);
        this.myParameterInfoDelayField = jTextField = new JTextField();
        jTextField.setColumns(4);
        jTextField.setText("1000");
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 0;
        gridBagConstraints8.weighty = 1.0;
        gridBagConstraints8.insets = new Insets(0, 5, 0, 5);
        jPanel12.add((Component)jTextField, gridBagConstraints8);
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$(jBLabel4, DynamicBundle.getBundle("messages/ApplicationBundle", CodeCompletionPanel.class).getString("editbox.ms"));
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 2;
        gridBagConstraints9.gridy = 0;
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.weighty = 1.0;
        gridBagConstraints9.anchor = 17;
        jPanel12.add((Component)jBLabel4, gridBagConstraints9);
        this.myAddonPanelAfter = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        this.myAddonPanelBefore = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jBRadioButton2);
        buttonGroup2.add(jBRadioButton2);
        buttonGroup2.add(jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "customComponents";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "addonPanel";
                break;
            }
        }
        objectArray[1] = "com/intellij/application/options/CodeCompletionPanel";
        objectArray[2] = "addExtensions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

