/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleCachedValueProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.AppCodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.FileCodeStyleProvider;
import com.intellij.psi.codeStyle.ProjectCodeStyleSettingsManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyle {
    private CodeStyle() {
    }

    @NotNull
    public static CodeStyleSettings getDefaultSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance().getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(0);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull Project project2) {
        if (project2 == null) {
            CodeStyle.$$$reportNull$$$0(1);
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance(project2).getCurrentSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(2);
        }
        return codeStyleSettings;
    }

    @NotNull
    public static CodeStyleSettings getProjectOrDefaultSettings(@Nullable Project project2) {
        return project2 != null ? CodeStyle.getSettings(project2) : CodeStyle.getDefaultSettings();
    }

    @NotNull
    public static CodeStyleSettings getSettings(@NotNull PsiFile file2) {
        Project project2;
        CodeStyleSettings tempSettings;
        if (file2 == null) {
            CodeStyle.$$$reportNull$$$0(3);
        }
        if ((tempSettings = CodeStyleSettingsManager.getInstance(project2 = file2.getProject()).getTemporarySettings()) != null) {
            CodeStyleSettings codeStyleSettings = tempSettings;
            if (codeStyleSettings == null) {
                CodeStyle.$$$reportNull$$$0(4);
            }
            return codeStyleSettings;
        }
        CodeStyleSettings result2 = FileCodeStyleProvider.EP_NAME.computeSafeIfAny(provider -> provider.getSettings(file2));
        if (result2 != null) {
            CodeStyleSettings codeStyleSettings = result2;
            if (codeStyleSettings == null) {
                CodeStyle.$$$reportNull$$$0(5);
            }
            return codeStyleSettings;
        }
        if (!file2.isPhysical()) {
            return CodeStyle.getSettings(project2);
        }
        CodeStyleSettings codeStyleSettings = CodeStyleCachedValueProvider.getInstance(file2).tryGetSettings();
        if (codeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(6);
        }
        return codeStyleSettings;
    }

    public static CodeStyleSettings getSettings(@NotNull Editor editor) {
        Project project2;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(7);
        }
        if ((project2 = editor.getProject()) != null) {
            PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
            if (file2 != null) {
                return CodeStyle.getSettings(file2);
            }
            return CodeStyle.getSettings(project2);
        }
        return CodeStyle.getDefaultSettings();
    }

    @Nullable
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull Editor editor) {
        PsiFile file2;
        Project project2;
        if (editor == null) {
            CodeStyle.$$$reportNull$$$0(8);
        }
        if ((project2 = editor.getProject()) != null && (file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument())) != null) {
            return CodeStyle.getLanguageSettings(file2);
        }
        return null;
    }

    @NotNull
    public static <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull PsiFile file2, Class<T> customSettingsClass) {
        if (file2 == null) {
            CodeStyle.$$$reportNull$$$0(9);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file2);
        T t = rootSettings.getCustomSettings(customSettingsClass);
        if (t == null) {
            CodeStyle.$$$reportNull$$$0(10);
        }
        return t;
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyle.$$$reportNull$$$0(11);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file2);
        CommonCodeStyleSettings commonCodeStyleSettings = rootSettings.getCommonSettings(file2.getLanguage());
        if (commonCodeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(12);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static CommonCodeStyleSettings getLanguageSettings(@NotNull PsiFile file2, @NotNull Language language2) {
        if (file2 == null) {
            CodeStyle.$$$reportNull$$$0(13);
        }
        if (language2 == null) {
            CodeStyle.$$$reportNull$$$0(14);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file2);
        CommonCodeStyleSettings commonCodeStyleSettings = rootSettings.getCommonSettings(language2);
        if (commonCodeStyleSettings == null) {
            CodeStyle.$$$reportNull$$$0(15);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyle.$$$reportNull$$$0(16);
        }
        CodeStyleSettings rootSettings = CodeStyle.getSettings(file2);
        CommonCodeStyleSettings.IndentOptions indentOptions = rootSettings.getIndentOptionsByFile(file2);
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(17);
        }
        return indentOptions;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptionsByFileType(@NotNull Project project2, @Nullable VirtualFile file2) {
        if (project2 == null) {
            CodeStyle.$$$reportNull$$$0(18);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = file2 != null ? CodeStyle.getSettings(project2).getIndentOptions(file2.getFileType()) : CodeStyle.getSettings(project2).getIndentOptions();
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(19);
        }
        return indentOptions;
    }

    @NotNull
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull Project project2, @NotNull Document document) {
        PsiFile file2;
        if (project2 == null) {
            CodeStyle.$$$reportNull$$$0(20);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(21);
        }
        if ((file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document)) != null) {
            return CodeStyle.getIndentOptions(file2);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings(project2).getIndentOptions((FileType)null);
        if (indentOptions == null) {
            CodeStyle.$$$reportNull$$$0(22);
        }
        return indentOptions;
    }

    public static int getIndentSize(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyle.$$$reportNull$$$0(23);
        }
        return CodeStyle.getIndentOptions((PsiFile)file2).INDENT_SIZE;
    }

    public static void setTemporarySettings(@Nullable Project project2, @NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CodeStyle.$$$reportNull$$$0(24);
        }
        CodeStyleSettingsManager.getInstance(project2).setTemporarySettings(settings);
    }

    public static void dropTemporarySettings(@Nullable Project project2) {
        CodeStyleSettingsManager codeStyleSettingsManager = project2 == null || project2.isDefault() ? (CodeStyleSettingsManager)ApplicationManager.getApplication().getServiceIfCreated(AppCodeStyleSettingsManager.class) : (CodeStyleSettingsManager)project2.getServiceIfCreated(ProjectCodeStyleSettingsManager.class);
        if (codeStyleSettingsManager != null) {
            codeStyleSettingsManager.dropTemporarySettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doWithTemporarySettings(@NotNull Project project2, @NotNull CodeStyleSettings tempSettings, @NotNull Runnable runnable2) {
        if (project2 == null) {
            CodeStyle.$$$reportNull$$$0(25);
        }
        if (tempSettings == null) {
            CodeStyle.$$$reportNull$$$0(26);
        }
        if (runnable2 == null) {
            CodeStyle.$$$reportNull$$$0(27);
        }
        CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance(project2);
        CodeStyleSettings tempSettingsBefore = settingsManager.getTemporarySettings();
        try {
            settingsManager.setTemporarySettings(tempSettings);
            runnable2.run();
        }
        finally {
            if (tempSettingsBefore != null) {
                settingsManager.setTemporarySettings(tempSettingsBefore);
            } else {
                settingsManager.dropTemporarySettings();
            }
        }
    }

    public static boolean usesOwnSettings(@NotNull Project project2) {
        if (project2 == null) {
            CodeStyle.$$$reportNull$$$0(28);
        }
        return CodeStyleSettingsManager.getInstance((Project)project2).USE_PER_PROJECT_SETTINGS;
    }

    public static void updateDocumentIndentOptions(@NotNull Project project2, @NotNull Document document) {
        PsiFile file2;
        PsiDocumentManager documentManager;
        if (project2 == null) {
            CodeStyle.$$$reportNull$$$0(29);
        }
        if (document == null) {
            CodeStyle.$$$reportNull$$$0(30);
        }
        if (!project2.isDisposed() && (documentManager = PsiDocumentManager.getInstance(project2)) != null && (file2 = documentManager.getPsiFile(document)) != null) {
            CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings(file2).getIndentOptionsByFile(file2, null, true, null);
            indentOptions.associateWithDocument(document);
        }
    }

    public static void setMainProjectSettings(@NotNull Project project2, @NotNull CodeStyleSettings settings) {
        if (project2 == null) {
            CodeStyle.$$$reportNull$$$0(31);
        }
        if (settings == null) {
            CodeStyle.$$$reportNull$$$0(32);
        }
        CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance(project2);
        codeStyleSettingsManager.setMainProjectCodeStyle(settings);
        codeStyleSettingsManager.USE_PER_PROJECT_SETTINGS = true;
    }

    public static boolean isFormattingEnabled(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyle.$$$reportNull$$$0(33);
        }
        return !CodeStyle.getSettings(file2).getExcludedFiles().contains(file2);
    }

    public static void reformatWithFileContext(@NotNull PsiFile fileToReformat, @NotNull PsiFile contextFile) {
        if (fileToReformat == null) {
            CodeStyle.$$$reportNull$$$0(34);
        }
        if (contextFile == null) {
            CodeStyle.$$$reportNull$$$0(35);
        }
        Project project2 = contextFile.getProject();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project2);
        CodeStyleSettings realFileSettings = CodeStyle.getSettings(contextFile);
        CodeStyle.doWithTemporarySettings(project2, realFileSettings, () -> codeStyleManager.reformat(fileToReformat));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyle";
                break;
            }
            case 1: 
            case 18: 
            case 20: 
            case 25: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 23: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 24: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempSettings";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToReformat";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSettings";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyle";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageSettings";
                break;
            }
            case 17: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentOptionsByFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 16: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptionsByFileType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSize";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setTemporarySettings";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doWithTemporarySettings";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "usesOwnSettings";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateDocumentIndentOptions";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setMainProjectSettings";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isFormattingEnabled";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "reformatWithFileContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

