/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class SchemesToImportPopup<T> {
    private final Component myParent;

    public SchemesToImportPopup(Component parent) {
        this.myParent = parent;
    }

    public void show(Collection<T> schemes) {
        if (schemes.isEmpty()) {
            Messages.showMessageDialog(IdeBundle.message("message.there.are.no.available.schemes.to.import", new Object[0]), IdeBundle.message("dialog.title.import", new Object[0]), Messages.getWarningIcon());
            return;
        }
        JBList<T> list2 = new JBList<T>(new CollectionListModel<T>(schemes));
        list2.setSelectionMode(0);
        ((JList)list2).setCellRenderer(new SchemesToImportListCellRenderer());
        Runnable selectAction = () -> this.onSchemeSelected(list2.getSelectedValue());
        this.showList(list2, selectAction);
    }

    private void showList(JList list2, Runnable selectAction) {
        ((PopupChooserBuilder)JBPopupFactory.getInstance().createListPopupBuilder(list2).setTitle(IdeBundle.message("popup.title.import.scheme", new Object[0]))).setItemChoosenCallback(selectAction).createPopup().showInCenterOf(this.myParent);
    }

    protected abstract void onSchemeSelected(T var1);

    private static class SchemesToImportListCellRenderer
    implements ListCellRenderer {
        private final JPanel myPanel = new JPanel(new BorderLayout());
        private final JLabel myNameLabel = new JLabel("", 2);

        SchemesToImportListCellRenderer() {
            this.myPanel.add((Component)this.myNameLabel, "Center");
        }

        public Component getListCellRendererComponent(@NotNull JList list2, Object val, int i, boolean isSelected, boolean cellHasFocus) {
            if (list2 == null) {
                SchemesToImportListCellRenderer.$$$reportNull$$$0(0);
            }
            Scheme c = (Scheme)val;
            this.myNameLabel.setText(c.getName());
            this.updateColors(isSelected);
            return this.myPanel;
        }

        private void updateColors(boolean isSelected) {
            Color bg = isSelected ? UIUtil.getTableSelectionBackground(true) : UIUtil.getTableBackground();
            Color fg = isSelected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
            SchemesToImportListCellRenderer.setColors(bg, fg, this.myPanel, this.myNameLabel);
        }

        private static void setColors(Color bg, Color fg, JComponent ... cc) {
            for (JComponent c : cc) {
                c.setBackground(bg);
                c.setForeground(fg);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/SchemesToImportPopup$SchemesToImportListCellRenderer", "getListCellRendererComponent"));
        }
    }
}

