/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesActions;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBDimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesPanel
extends SimpleSchemesPanel<CodeStyleScheme> {
    private final CodeStyleSchemesModel myModel;
    private boolean myIsReset;
    private JLabel myBottomLabel;
    private JPanel myBottomPanel;

    public CodeStyleSchemesPanel(CodeStyleSchemesModel model, int vGap) {
        super(vGap);
        this.myModel = model;
    }

    CodeStyleSchemesPanel(CodeStyleSchemesModel model) {
        super(8);
        this.myModel = model;
        this.showOverridingMessage(this.myModel.getOverridingStatus());
    }

    private void onCombo() {
        CodeStyleScheme selected2 = (CodeStyleScheme)this.getSelectedScheme();
        if (selected2 != null) {
            this.myModel.selectScheme(selected2, this);
        }
    }

    public void resetSchemesCombo() {
        this.myIsReset = true;
        try {
            ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>(this.myModel.getAllSortedSchemes());
            this.resetSchemes(schemes);
            this.selectScheme(this.myModel.getSelectedScheme());
        }
        finally {
            this.myIsReset = false;
        }
    }

    public void onSelectedSchemeChanged() {
        this.myIsReset = true;
        try {
            this.selectScheme(this.myModel.getSelectedScheme());
        }
        finally {
            this.myIsReset = false;
        }
    }

    @Override
    @NotNull
    protected AbstractSchemeActions<CodeStyleScheme> createSchemeActions() {
        return new CodeStyleSchemesActions(this){

            @Override
            protected void onSchemeChanged(@Nullable CodeStyleScheme scheme) {
                if (!CodeStyleSchemesPanel.this.myIsReset) {
                    ApplicationManager.getApplication().invokeLater(() -> CodeStyleSchemesPanel.this.onCombo());
                }
            }

            @Override
            protected void renameScheme(@NotNull CodeStyleScheme scheme, @NotNull String newName) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newName == null) {
                    1.$$$reportNull$$$0(1);
                }
                CodeStyleSchemeImpl newScheme = new CodeStyleSchemeImpl(newName, false, scheme);
                CodeStyleSchemesPanel.this.myModel.addScheme(newScheme, false);
                CodeStyleSchemesPanel.this.myModel.removeScheme(scheme);
                CodeStyleSchemesPanel.this.myModel.selectScheme(newScheme, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scheme";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newName";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel$1";
                objectArray[2] = "renameScheme";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public SchemesModel<CodeStyleScheme> getModel() {
        CodeStyleSchemesModel codeStyleSchemesModel = this.myModel;
        if (codeStyleSchemesModel == null) {
            CodeStyleSchemesPanel.$$$reportNull$$$0(0);
        }
        return codeStyleSchemesModel;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return true;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return true;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }

    @Override
    @Nullable
    protected JComponent createBottomComponent() {
        this.myBottomPanel = new JPanel(new FlowLayout(0));
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(AllIcons.General.Warning);
        this.myBottomPanel.add(iconLabel);
        this.myBottomPanel.add(Box.createRigidArea(new JBDimension(5, 0)));
        this.myBottomLabel = new JLabel();
        this.myBottomPanel.add(this.myBottomLabel);
        LinkLabel<Object> disableHyperLink = new LinkLabel<Object>(LangBundle.message("action.link.disable", new Object[0]), null, new LinkListener<Object>(){

            @Override
            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                CodeStyleSchemesPanel.this.disableOverriding();
            }
        });
        this.myBottomPanel.add(disableHyperLink);
        this.myBottomPanel.setVisible(false);
        return this.myBottomPanel;
    }

    private void disableOverriding() {
        CodeStyleSchemesModel.OverridingStatus status = this.myModel.getOverridingStatus();
        if (status != null) {
            CodeStyleScheme currScheme = (CodeStyleScheme)this.getSelectedScheme();
            CodeStyleSettings currSettings = currScheme.getCodeStyleSettings();
            CodeStyleSettings modelSettings = this.myModel.getCloneSettings(currScheme);
            for (CodeStyleSettingsModifier modifier : status.getModifiers()) {
                Consumer<CodeStyleSettings> disablingFunction = modifier.getDisablingFunction();
                if (disablingFunction == null) continue;
                disablingFunction.accept(currSettings);
                CodeStyleSettingsManager.getInstance(this.myModel.getProject()).notifyCodeStyleSettingsChanged();
                disablingFunction.accept(modelSettings);
            }
            this.myModel.updateOverridingStatus();
            this.myModel.fireModelSettingsChanged(modelSettings);
        } else {
            this.myBottomPanel.setVisible(false);
        }
    }

    public final void updateOverridingMessage() {
        this.showOverridingMessage(this.myModel.getOverridingStatus());
    }

    private void showOverridingMessage(@Nullable CodeStyleSchemesModel.OverridingStatus overridingStatus) {
        if (overridingStatus != null) {
            CodeStyleSettingsModifier[] modifiers = overridingStatus.getModifiers();
            this.myBottomLabel.setText(CodeStyleSchemesPanel.getMessage(modifiers));
            this.myBottomPanel.setVisible(true);
            return;
        }
        this.myBottomPanel.setVisible(false);
    }

    private static String getMessage(CodeStyleSettingsModifier @NotNull [] modifiers) {
        if (modifiers == null) {
            CodeStyleSchemesPanel.$$$reportNull$$$0(1);
        }
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Settings may be overridden by ");
        boolean isList = false;
        for (CodeStyleSettingsModifier modifier : modifiers) {
            if (isList) {
                messageBuilder.append(", ");
            }
            messageBuilder.append(modifier.getName());
            isList = true;
        }
        messageBuilder.append('.');
        return messageBuilder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

