/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomizableLanguageCodeStylePanel
extends CodeStyleAbstractPanel
implements CodeStyleSettingsCustomizable {
    private static final Logger LOG = Logger.getInstance(CustomizableLanguageCodeStylePanel.class);

    protected CustomizableLanguageCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
    }

    protected void init() {
        this.customizeSettings();
    }

    protected void customizeSettings() {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(this.getDefaultLanguage());
        if (provider != null) {
            provider.customizeSettings(this, this.getSettingsType());
        }
    }

    public abstract LanguageCodeStyleSettingsProvider.SettingsType getSettingsType();

    protected void resetDefaultNames() {
    }

    @Override
    protected String getPreviewText() {
        if (this.getDefaultLanguage() == null) {
            return "";
        }
        String sample = LanguageCodeStyleSettingsProvider.getCodeSample(this.getDefaultLanguage(), this.getSettingsType());
        if (sample == null) {
            return "";
        }
        return sample;
    }

    @Override
    protected int getRightMargin() {
        if (this.getDefaultLanguage() == null) {
            return -1;
        }
        return LanguageCodeStyleSettingsProvider.getRightMargin(this.getDefaultLanguage(), this.getSettingsType());
    }

    @Override
    protected String getFileExt() {
        String fileExt = LanguageCodeStyleSettingsProvider.getFileExt(this.getDefaultLanguage());
        if (fileExt != null) {
            return fileExt;
        }
        return super.getFileExt();
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType assocType;
        if (this.getDefaultLanguage() != null && (assocType = this.getDefaultLanguage().getAssociatedFileType()) != null) {
            LanguageFileType languageFileType = assocType;
            if (languageFileType == null) {
                CustomizableLanguageCodeStylePanel.$$$reportNull$$$0(0);
            }
            return languageFileType;
        }
        LanguageFileType languageFileType = StdFileTypes.JAVA;
        if (languageFileType == null) {
            CustomizableLanguageCodeStylePanel.$$$reportNull$$$0(1);
        }
        return languageFileType;
    }

    @Override
    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        FileType fileType = this.getFileType();
        return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(ProjectUtil.guessCurrentProject(this.getPanel()), fileType, null, scheme);
    }

    @Override
    protected PsiFile doReformat(Project project2, PsiFile psiFile) {
        String text2 = psiFile.getText();
        PsiDocumentManager manager = PsiDocumentManager.getInstance(project2);
        Document doc = manager.getDocument(psiFile);
        CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (doc != null) {
                doc.replaceString(0, doc.getTextLength(), text2);
                manager.commitDocument(doc);
            }
            try {
                CodeStyleManager.getInstance(project2).reformat(psiFile);
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }), "", "");
        if (doc != null) {
            manager.commitDocument(doc);
        }
        return psiFile;
    }

    protected static JPanel createPreviewPanel() {
        return new JPanel(new BorderLayout());
    }

    @Override
    public void moveStandardOption(String fieldName, String newGroup) {
        throw new UnsupportedOperationException();
    }

    protected <T extends OrderedOption> List<T> sortOptions(Collection<? extends T> options) {
        THashSet<String> names2 = new THashSet<String>(ContainerUtil.map(options, option2 -> option2.getOptionName()));
        ArrayList<OrderedOption> order = new ArrayList<OrderedOption>(options.size());
        MultiMap<String, OrderedOption> afters = new MultiMap<String, OrderedOption>();
        MultiMap<String, OrderedOption> befores = new MultiMap<String, OrderedOption>();
        for (OrderedOption each : options) {
            String anchorOptionName = each.getAnchorOptionName();
            if (anchorOptionName != null && names2.contains(anchorOptionName)) {
                if (each.getAnchor() == CodeStyleSettingsCustomizable.OptionAnchor.AFTER) {
                    afters.putValue(anchorOptionName, each);
                    continue;
                }
                if (each.getAnchor() == CodeStyleSettingsCustomizable.OptionAnchor.BEFORE) {
                    befores.putValue(anchorOptionName, each);
                    continue;
                }
            }
            order.add(each);
        }
        ArrayList<Object> result2 = new ArrayList<Object>(options.size());
        for (OrderedOption each : order) {
            result2.addAll(befores.get(each.getOptionName()));
            result2.add(each);
            result2.addAll(afters.get(each.getOptionName()));
        }
        assert (result2.size() == options.size());
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/CustomizableLanguageCodeStylePanel", "getFileType"));
    }

    protected static abstract class OrderedOption {
        @NotNull
        private final String optionName;
        @Nullable
        private final CodeStyleSettingsCustomizable.OptionAnchor anchor;
        @Nullable
        private final String anchorOptionName;

        protected OrderedOption(@NotNull String optionName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor2, @Nullable String anchorOptionName) {
            if (optionName == null) {
                OrderedOption.$$$reportNull$$$0(0);
            }
            this.optionName = optionName;
            this.anchor = anchor2;
            this.anchorOptionName = anchorOptionName;
        }

        @NotNull
        public String getOptionName() {
            String string = this.optionName;
            if (string == null) {
                OrderedOption.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public CodeStyleSettingsCustomizable.OptionAnchor getAnchor() {
            return this.anchor;
        }

        @Nullable
        public String getAnchorOptionName() {
            return this.anchorOptionName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/CustomizableLanguageCodeStylePanel$OrderedOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/CustomizableLanguageCodeStylePanel$OrderedOption";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

