/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.additional;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.OptionGroup;
import com.intellij.util.ui.JBUI;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForceArrangementPanel {
    @NotNull
    private final JComboBox myForceRearrangeComboBox = new JComboBox();
    @NotNull
    private final JPanel myPanel;

    public ForceArrangementPanel() {
        this.myForceRearrangeComboBox.setModel(new EnumComboBoxModel<SelectedMode>(SelectedMode.class));
        this.myForceRearrangeComboBox.setMaximumSize(this.myForceRearrangeComboBox.getPreferredSize());
        this.myPanel = this.createPanel();
    }

    public int getRearrangeMode() {
        return this.getSelectedMode().rearrangeMode;
    }

    public void setSelectedMode(@NotNull SelectedMode mode) {
        if (mode == null) {
            ForceArrangementPanel.$$$reportNull$$$0(0);
        }
        this.myForceRearrangeComboBox.setSelectedItem((Object)mode);
    }

    public void setSelectedMode(int mode) {
        SelectedMode toSetUp = SelectedMode.getByMode(mode);
        assert (toSetUp != null);
        this.setSelectedMode(toSetUp);
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ForceArrangementPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    private JPanel createPanel() {
        OptionGroup group = new OptionGroup(ApplicationBundle.message("arrangement.settings.additional.title", new Object[0]));
        JPanel textWithComboPanel = new JPanel();
        textWithComboPanel.setLayout(new BoxLayout(textWithComboPanel, 2));
        textWithComboPanel.add(new JLabel(ApplicationBundle.message("arrangement.settings.additional.force.combobox.name", new Object[0])));
        textWithComboPanel.add(Box.createRigidArea(JBUI.size(5, 0)));
        textWithComboPanel.add(this.myForceRearrangeComboBox);
        group.add(textWithComboPanel);
        JPanel jPanel = group.createPanel();
        if (jPanel == null) {
            ForceArrangementPanel.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    private SelectedMode getSelectedMode() {
        SelectedMode selectedMode = (SelectedMode)((Object)this.myForceRearrangeComboBox.getSelectedItem());
        if (selectedMode == null) {
            ForceArrangementPanel.$$$reportNull$$$0(3);
        }
        return selectedMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedMode";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum SelectedMode {
        FROM_DIALOG(ApplicationBundle.message("arrangement.settings.additional.force.rearrange.according.to.dialog", new Object[0]), 0),
        ALWAYS(ApplicationBundle.message("arrangement.settings.additional.force.rearrange.always", new Object[0]), 1),
        NEVER(ApplicationBundle.message("arrangement.settings.additional.force.rearrange.never", new Object[0]), 2);

        public final int rearrangeMode;
        @NotNull
        private final String myName;

        private SelectedMode(String name, int mode) {
            if (name == null) {
                SelectedMode.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.rearrangeMode = mode;
        }

        @Nullable
        private static SelectedMode getByMode(int mode) {
            for (SelectedMode currentMode : SelectedMode.values()) {
                if (currentMode.rearrangeMode != mode) continue;
                return currentMode;
            }
            return null;
        }

        @NotNull
        public String toString() {
            String string = this.myName;
            if (string == null) {
                SelectedMode.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel$SelectedMode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel$SelectedMode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

