/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.color;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementColorsAware;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementColorsProviderImpl
implements ArrangementColorsProvider {
    @NotNull
    private final Map<ArrangementSettingsToken, TextAttributes> myNormalAttributesCache = new HashMap<ArrangementSettingsToken, TextAttributes>();
    @NotNull
    private final Map<ArrangementSettingsToken, TextAttributes> mySelectedAttributesCache = new HashMap<ArrangementSettingsToken, TextAttributes>();
    @NotNull
    private final TextAttributes myDefaultNormalAttributes = new TextAttributes();
    @NotNull
    private final TextAttributes myDefaultSelectedAttributes = new TextAttributes();
    @NotNull
    private final Color myDefaultNormalBorderColor;
    @NotNull
    private final Color myDefaultSelectedBorderColor;
    @Nullable
    private final ArrangementColorsAware myColorsAware;
    @Nullable
    private Color myCachedNormalBorderColor;
    @Nullable
    private Color myCachedSelectedBorderColor;

    public ArrangementColorsProviderImpl(@Nullable ArrangementColorsAware colorsAware) {
        this.myColorsAware = colorsAware;
        this.myDefaultNormalAttributes.setForegroundColor(UIUtil.getTreeForeground());
        this.myDefaultNormalAttributes.setBackgroundColor(UIUtil.getPanelBackground());
        this.myDefaultSelectedAttributes.setForegroundColor(UIUtil.getTreeSelectionForeground());
        this.myDefaultSelectedAttributes.setBackgroundColor(UIUtil.getTreeSelectionBackground());
        this.myDefaultNormalBorderColor = JBColor.border();
        Color selectionBorderColor = UIUtil.getTreeSelectionBorderColor();
        if (selectionBorderColor == null) {
            selectionBorderColor = JBColor.black;
        }
        this.myDefaultSelectedBorderColor = selectionBorderColor;
    }

    @Override
    @NotNull
    public Color getBorderColor(boolean selected2) {
        Color cached = selected2 ? this.myCachedSelectedBorderColor : this.myCachedNormalBorderColor;
        if (cached != null) {
            Color color = cached;
            if (color == null) {
                ArrangementColorsProviderImpl.$$$reportNull$$$0(0);
            }
            return color;
        }
        Color result2 = null;
        if (this.myColorsAware != null) {
            result2 = this.myColorsAware.getBorderColor(EditorColorsManager.getInstance().getGlobalScheme(), selected2);
        }
        if (result2 == null) {
            Color color = result2 = selected2 ? this.myDefaultSelectedBorderColor : this.myDefaultNormalBorderColor;
        }
        if (selected2) {
            this.myCachedSelectedBorderColor = result2;
        } else {
            this.myCachedNormalBorderColor = result2;
        }
        Color color = result2;
        if (color == null) {
            ArrangementColorsProviderImpl.$$$reportNull$$$0(1);
        }
        return color;
    }

    @Override
    @NotNull
    public TextAttributes getTextAttributes(@NotNull ArrangementSettingsToken token, boolean selected2) {
        TextAttributes cached;
        if (token == null) {
            ArrangementColorsProviderImpl.$$$reportNull$$$0(2);
        }
        if ((cached = selected2 ? this.mySelectedAttributesCache.get(token) : this.myNormalAttributesCache.get(token)) != null) {
            TextAttributes textAttributes = cached;
            if (textAttributes == null) {
                ArrangementColorsProviderImpl.$$$reportNull$$$0(3);
            }
            return textAttributes;
        }
        TextAttributes result2 = null;
        if (this.myColorsAware != null) {
            result2 = this.myColorsAware.getTextAttributes(EditorColorsManager.getInstance().getGlobalScheme(), token, selected2);
        }
        if (result2 == null) {
            TextAttributes textAttributes = result2 = selected2 ? this.myDefaultSelectedAttributes : this.myDefaultNormalAttributes;
        }
        if (selected2) {
            this.mySelectedAttributesCache.put(token, result2);
        } else {
            this.myNormalAttributesCache.put(token, result2);
        }
        TextAttributes textAttributes = result2;
        if (textAttributes == null) {
            ArrangementColorsProviderImpl.$$$reportNull$$$0(4);
        }
        return textAttributes;
    }

    public void refresh() {
        if (this.myColorsAware != null) {
            this.myNormalAttributesCache.clear();
            this.mySelectedAttributesCache.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/color/ArrangementColorsProviderImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/color/ArrangementColorsProviderImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

