/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.ArrangementConstants;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRuleManager;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.tokens.ArrangementRuleAliasDialog;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionRulesControl
extends ArrangementMatchingRulesControl {
    @NotNull
    public static final DataKey<ArrangementSectionRulesControl> KEY = DataKey.create("Arrangement.Rule.Match.Control");
    @NotNull
    private static final Logger LOG = Logger.getInstance(ArrangementSectionRulesControl.class);
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    @NotNull
    private final ArrangementStandardSettingsManager mySettingsManager;
    @Nullable
    private final ArrangementSectionRuleManager mySectionRuleManager;
    @Nullable
    private ArrangementStandardSettingsManager myExtendedSettingsManager;

    public ArrangementSectionRulesControl(@NotNull Language language2, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementMatchingRulesControl.RepresentationCallback callback2) {
        if (language2 == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(0);
        }
        if (settingsManager == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(1);
        }
        if (colorsProvider == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(2);
        }
        if (callback2 == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(3);
        }
        super(settingsManager, colorsProvider, callback2);
        this.mySectionRuleManager = ArrangementSectionRuleManager.getInstance(language2, settingsManager, colorsProvider, this);
        this.mySettingsManager = settingsManager;
        this.myColorsProvider = colorsProvider;
    }

    private static void appendBufferedSectionRules(@NotNull List<? super ArrangementSectionRule> result2, @NotNull List<? extends StdArrangementMatchRule> buffer, @Nullable String currentSectionStart) {
        if (result2 == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(4);
        }
        if (buffer == null) {
            ArrangementSectionRulesControl.$$$reportNull$$$0(5);
        }
        if (currentSectionStart == null) {
            return;
        }
        if (buffer.isEmpty()) {
            result2.add(ArrangementSectionRule.create(currentSectionStart, null, new StdArrangementMatchRule[0]));
        } else {
            result2.add(ArrangementSectionRule.create(currentSectionStart, null, buffer.get(0)));
            for (int j = 1; j < buffer.size(); ++j) {
                result2.add(ArrangementSectionRule.create(buffer.get(j)));
            }
            buffer.clear();
        }
    }

    @Override
    protected ArrangementMatchingRulesControl.MatchingRulesRendererBase createRender() {
        return new MatchingRulesRenderer();
    }

    @Override
    @NotNull
    protected ArrangementMatchingRulesValidator createValidator() {
        return new ArrangementSectionRulesValidator(this.getModel(), this.mySectionRuleManager);
    }

    @Nullable
    public ArrangementSectionRuleManager getSectionRuleManager() {
        return this.mySectionRuleManager;
    }

    public List<ArrangementSectionRule> getSections() {
        if (this.getModel().getSize() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<ArrangementSectionRule> result2 = new ArrayList<ArrangementSectionRule>();
        ArrayList<StdArrangementMatchRule> buffer = new ArrayList<StdArrangementMatchRule>();
        String currentSectionStart = null;
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            ArrangementSectionRuleManager.ArrangementSectionRuleData sectionRule;
            Object element2 = this.getModel().getElementAt(i);
            if (!(element2 instanceof StdArrangementMatchRule)) continue;
            ArrangementSectionRuleManager.ArrangementSectionRuleData arrangementSectionRuleData = sectionRule = this.mySectionRuleManager == null ? null : this.mySectionRuleManager.getSectionRuleData((StdArrangementMatchRule)element2);
            if (sectionRule != null) {
                if (sectionRule.isSectionStart()) {
                    ArrangementSectionRulesControl.appendBufferedSectionRules(result2, buffer, currentSectionStart);
                    currentSectionStart = sectionRule.getText();
                    continue;
                }
                result2.add(ArrangementSectionRule.create(StringUtil.notNullize(currentSectionStart), sectionRule.getText(), buffer));
                buffer.clear();
                currentSectionStart = null;
                continue;
            }
            if (currentSectionStart == null) {
                result2.add(ArrangementSectionRule.create((StdArrangementMatchRule)element2));
                continue;
            }
            buffer.add((StdArrangementMatchRule)element2);
        }
        ArrangementSectionRulesControl.appendBufferedSectionRules(result2, buffer, currentSectionStart);
        return result2;
    }

    public void setSections(@Nullable List<? extends ArrangementSectionRule> sections) {
        List<StdArrangementMatchRule> rules = sections == null ? null : ArrangementUtil.collectMatchRules(sections);
        this.myComponents.clear();
        this.getModel().clear();
        if (rules == null) {
            return;
        }
        for (StdArrangementMatchRule rule2 : rules) {
            this.getModel().add(rule2);
        }
        if (ArrangementConstants.LOG_RULE_MODIFICATION) {
            LOG.info("Arrangement matching rules list is refreshed. Given rules:");
            for (StdArrangementMatchRule rule2 : rules) {
                LOG.info("  " + rule2.toString());
            }
        }
    }

    @Nullable
    public Collection<StdArrangementRuleAliasToken> getRulesAliases() {
        return this.myExtendedSettingsManager == null ? null : this.myExtendedSettingsManager.getRuleAliases();
    }

    public void setRulesAliases(@Nullable Collection<StdArrangementRuleAliasToken> aliases) {
        if (aliases != null) {
            this.myExtendedSettingsManager = new ArrangementStandardSettingsManager(this.mySettingsManager.getDelegate(), this.myColorsProvider, aliases);
            this.myEditor = new ArrangementMatchingRuleEditor(this.myExtendedSettingsManager, this.myColorsProvider, this);
        }
    }

    @Override
    public void showEditor(int rowToEdit) {
        if (this.mySectionRuleManager != null && this.mySectionRuleManager.isSectionRule(this.getModel().getElementAt(rowToEdit))) {
            this.mySectionRuleManager.showEditor(rowToEdit);
        } else {
            super.showEditor(rowToEdit);
        }
    }

    @NotNull
    public ArrangementRuleAliasDialog createRuleAliasEditDialog() {
        final THashSet<String> tokenIds = new THashSet<String>();
        List<ArrangementSectionRule> sections = this.getSections();
        for (ArrangementSectionRule section : sections) {
            for (StdArrangementMatchRule rule2 : section.getMatchRules()) {
                rule2.getMatcher().getCondition().invite(new ArrangementMatchConditionVisitor(){

                    @Override
                    public void visit(@NotNull ArrangementAtomMatchCondition condition2) {
                        if (condition2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (ArrangementUtil.isAliasedCondition(condition2)) {
                            tokenIds.add(condition2.getType().getId());
                        }
                    }

                    @Override
                    public void visit(@NotNull ArrangementCompositeMatchCondition condition2) {
                        if (condition2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        for (ArrangementMatchCondition operand : condition2.getOperands()) {
                            operand.invite(this);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl$1", "visit"));
                    }
                });
            }
        }
        Collection<StdArrangementRuleAliasToken> aliases = this.getRulesAliases();
        assert (aliases != null);
        return new ArrangementRuleAliasDialog(null, this.mySettingsManager, this.myColorsProvider, aliases, tokenIds);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesControl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendBufferedSectionRules";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MatchingRulesRenderer
    extends ArrangementMatchingRulesControl.MatchingRulesRendererBase {
        private MatchingRulesRenderer() {
        }

        @Override
        public boolean allowModifications(StdArrangementMatchRule rule2) {
            return ArrangementSectionRulesControl.this.mySectionRuleManager == null || !ArrangementSectionRulesControl.this.mySectionRuleManager.isSectionRule(rule2);
        }
    }
}

