/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRuleManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionRulesValidator
extends ArrangementMatchingRulesValidator {
    private final ArrangementSectionRuleManager mySectionRuleManager;

    public ArrangementSectionRulesValidator(ArrangementMatchingRulesModel model, ArrangementSectionRuleManager sectionRuleManager) {
        super(model);
        this.mySectionRuleManager = sectionRuleManager;
    }

    @Override
    @Nullable
    protected String validate(int index) {
        ArrangementSectionRuleManager.ArrangementSectionRuleData data2;
        if (this.myRulesModel.getSize() < index) {
            return null;
        }
        if (this.mySectionRuleManager != null && (data2 = this.extractSectionText(index)) != null) {
            return this.validateSectionRule(data2, index);
        }
        return super.validate(index);
    }

    @Nullable
    private String validateSectionRule(@NotNull ArrangementSectionRuleManager.ArrangementSectionRuleData data2, int index) {
        if (data2 == null) {
            ArrangementSectionRulesValidator.$$$reportNull$$$0(0);
        }
        int startSectionIndex = -1;
        HashSet<String> sectionRules = new HashSet<String>();
        for (int i = 0; i < index; ++i) {
            ArrangementSectionRuleManager.ArrangementSectionRuleData section = this.extractSectionText(i);
            if (section == null) continue;
            int n = startSectionIndex = section.isSectionStart() ? i : -1;
            if (!StringUtil.isNotEmpty(section.getText())) continue;
            sectionRules.add(section.getText());
        }
        if (StringUtil.isNotEmpty(data2.getText()) && sectionRules.contains(data2.getText())) {
            return ApplicationBundle.message("arrangement.settings.validation.duplicate.section.text", new Object[0]);
        }
        if (!data2.isSectionStart()) {
            if (startSectionIndex == -1) {
                return ApplicationBundle.message("arrangement.settings.validation.end.section.rule.without.start", new Object[0]);
            }
            if (startSectionIndex == index - 1) {
                return ApplicationBundle.message("arrangement.settings.validation.empty.section.rule", new Object[0]);
            }
        }
        return null;
    }

    @Nullable
    private ArrangementSectionRuleManager.ArrangementSectionRuleData extractSectionText(int i) {
        Object element2 = this.myRulesModel.getElementAt(i);
        if (element2 instanceof StdArrangementMatchRule) {
            assert (this.mySectionRuleManager != null);
            return this.mySectionRuleManager.getSectionRuleData((StdArrangementMatchRule)element2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRulesValidator", "validateSectionRule"));
    }
}

