/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.excludedFiles;

import com.intellij.DynamicBundle;
import com.intellij.formatting.fileSet.PatternDescriptor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.valueEditors.TextFieldValueEditor;
import com.intellij.ui.components.fields.valueEditors.ValueEditor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExcludedFilesPatternForm {
    private JPanel myTopPanel;
    private JBTextField myPatternField;

    public ExcludedFilesPatternForm() {
        this.$$$setupUI$$$();
        int minWidth = JBUIScale.scale(400);
        int minHeight = this.myPatternField.getMinimumSize().height;
        this.myPatternField.setMinimumSize(new Dimension(minWidth, minHeight));
    }

    protected abstract void updateOnError();

    protected abstract void updateOnValue(@NotNull String var1);

    public JPanel getTopPanel() {
        return this.myTopPanel;
    }

    public void setFileSpec(@NotNull String fileSpec) {
        if (fileSpec == null) {
            ExcludedFilesPatternForm.$$$reportNull$$$0(0);
        }
        ((PatternField)this.myPatternField).getValueEditor().setValue(fileSpec);
    }

    public String getFileSpec() {
        return ((PatternField)this.myPatternField).getValueEditor().getValue();
    }

    private void createUIComponents() {
        this.myPatternField = new PatternField();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBTextField jBTextField = this.myPatternField;
        jPanel.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$(jBLabel, DynamicBundle.getBundle("messages/ApplicationBundle", ExcludedFilesPatternForm.class).getString("settings.code.style.general.file.pattern"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSpec", "com/intellij/application/options/codeStyle/excludedFiles/ExcludedFilesPatternForm", "setFileSpec"));
    }

    private class PatternField
    extends JBTextField {
        private final ValueEditor<String> myValueEditor;

        private PatternField() {
            this.myValueEditor = new TextFieldValueEditor<String>((JTextField)this, "Pattern", ""){

                @Override
                @NotNull
                public String parseValue(@Nullable String text2) throws InvalidDataException {
                    if (text2 != null && !PatternDescriptor.isValidPattern(text2)) {
                        throw new InvalidDataException("Invalid pattern");
                    }
                    return text2 != null ? text2 : "";
                }

                @Override
                public String valueToString(@NotNull String value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return value2;
                }

                @Override
                public boolean isValid(@NotNull String value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return PatternDescriptor.isValidPattern(value2);
                }

                @Override
                protected String validateTextOnChange(String text2, DocumentEvent e) {
                    String err = super.validateTextOnChange(text2, e);
                    if (!StringUtil.isEmpty(err)) {
                        ExcludedFilesPatternForm.this.updateOnError();
                    }
                    return err;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "value";
                    objectArray2[1] = "com/intellij/application/options/codeStyle/excludedFiles/ExcludedFilesPatternForm$PatternField$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "valueToString";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isValid";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myValueEditor.addListener(new ValueEditor.Listener<String>(){

                @Override
                public void valueChanged(@NotNull String newValue) {
                    if (newValue == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ExcludedFilesPatternForm.this.updateOnValue(newValue);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/application/options/codeStyle/excludedFiles/ExcludedFilesPatternForm$PatternField$2", "valueChanged"));
                }
            });
        }

        public ValueEditor<String> getValueEditor() {
            return this.myValueEditor;
        }
    }
}

