/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStyleChoiceList;
import com.intellij.application.options.codeStyle.properties.ExternalStringAccessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.BidirectionalMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumPropertyAccessor
extends ExternalStringAccessor<Enum<?>>
implements CodeStyleChoiceList {
    private final Class<? extends Enum<?>> myEnumClass;
    private final BidirectionalMap<String, Enum<?>> myEnumMap;

    public EnumPropertyAccessor(@NotNull Object object, @NotNull Field field) {
        if (object == null) {
            EnumPropertyAccessor.$$$reportNull$$$0(0);
        }
        if (field == null) {
            EnumPropertyAccessor.$$$reportNull$$$0(1);
        }
        super(object, field);
        this.myEnumMap = new BidirectionalMap();
        this.myEnumClass = field.getType().asSubclass(Enum.class);
        this.fillEnumMap();
    }

    private void fillEnumMap() {
        Enum<?>[] enumConstants = this.myEnumClass.getEnumConstants();
        if (enumConstants != null) {
            for (Enum<?> enumConstant : enumConstants) {
                this.myEnumMap.put(StringUtil.toLowerCase(enumConstant.toString()), enumConstant);
            }
        }
    }

    @Override
    @NotNull
    public List<String> getChoices() {
        return new ArrayList<String>(this.myEnumMap.keySet());
    }

    @Override
    @Nullable
    protected Enum<?> fromExternal(@NotNull String str) {
        if (str == null) {
            EnumPropertyAccessor.$$$reportNull$$$0(2);
        }
        return this.myEnumMap.get(str);
    }

    @Override
    @NotNull
    protected String toExternal(@NotNull Enum<?> value2) {
        if (value2 == null) {
            EnumPropertyAccessor.$$$reportNull$$$0(3);
        }
        List<String> names2 = this.myEnumMap.getKeysByValue(value2);
        assert (names2 != null && names2.size() > 0) : "Unexpected value " + value2.toString();
        String string = names2.get(0);
        if (string == null) {
            EnumPropertyAccessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/properties/EnumPropertyAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/properties/EnumPropertyAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toExternal";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

