/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStylePropertiesUtil;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisualGuidesAccessor
extends CodeStylePropertyAccessor<List<Integer>> {
    private final CodeStyleSettings mySettings;
    @Nullable
    private final Language myLanguage;
    public static final String VISUAL_GUIDES_PROPERTY_NAME = "visual_guides";

    VisualGuidesAccessor(@NotNull CodeStyleSettings settings, @Nullable Language language2) {
        if (settings == null) {
            VisualGuidesAccessor.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
        this.myLanguage = language2;
    }

    @Override
    public boolean set(@NotNull List<Integer> extVal) {
        if (extVal == null) {
            VisualGuidesAccessor.$$$reportNull$$$0(1);
        }
        if (this.myLanguage != null) {
            this.mySettings.setSoftMargins(this.myLanguage, extVal);
        } else {
            this.mySettings.setDefaultSoftMargins(extVal);
        }
        return true;
    }

    @Override
    @Nullable
    public List<Integer> get() {
        List<Integer> values2 = this.myLanguage != null ? this.mySettings.getCommonSettings(this.myLanguage).getSoftMargins() : this.mySettings.getDefaultSoftMargins();
        return !values2.isEmpty() ? values2 : null;
    }

    @Override
    protected List<Integer> parseString(@NotNull String string) {
        if (string == null) {
            VisualGuidesAccessor.$$$reportNull$$$0(2);
        }
        return CodeStylePropertiesUtil.getValueList(string).stream().map(s -> VisualGuidesAccessor.safeToInt(s)).filter(integer -> integer >= 0).collect(Collectors.toList());
    }

    @Override
    @Nullable
    protected String valueToString(@NotNull List<Integer> value2) {
        if (value2 == null) {
            VisualGuidesAccessor.$$$reportNull$$$0(3);
        }
        return CodeStylePropertiesUtil.toCommaSeparatedString(value2);
    }

    private static int safeToInt(@NotNull String s) {
        if (s == null) {
            VisualGuidesAccessor.$$$reportNull$$$0(4);
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    @Override
    public String getPropertyName() {
        return VISUAL_GUIDES_PROPERTY_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extVal";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/codeStyle/properties/VisualGuidesAccessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "valueToString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "safeToInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

