/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FontEditorPreview
implements PreviewPanel {
    private static final String PREVIEW_TEXT_KEY = "FontPreviewText";
    private final EditorEx myEditor;
    private final Supplier<? extends EditorColorsScheme> mySchemeSupplier;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public FontEditorPreview(Supplier<? extends EditorColorsScheme> schemeSupplier, boolean editable) {
        this.mySchemeSupplier = schemeSupplier;
        @Nls String text2 = PropertiesComponent.getInstance().getValue(PREVIEW_TEXT_KEY, FontEditorPreview.getIDEDemoText());
        this.myEditor = (EditorEx)FontEditorPreview.createPreviewEditor(text2, this.mySchemeSupplier.get(), editable);
        FontEditorPreview.registerRestoreAction(this.myEditor);
        FontEditorPreview.installTrafficLights(this.myEditor);
    }

    private static void registerRestoreAction(EditorEx editor) {
        editor.putUserData(RestorePreviewTextAction.OUR_EDITOR, Boolean.TRUE);
        AnAction restoreAction = ActionManager.getInstance().getAction("RestoreFontPreviewTextAction");
        if (restoreAction != null) {
            String originalGroupId = editor.getContextMenuGroupId();
            AnAction originalGroup = originalGroupId == null ? null : ActionManager.getInstance().getAction(originalGroupId);
            DefaultActionGroup group = new DefaultActionGroup();
            if (originalGroup instanceof ActionGroup) {
                group.addAll(((ActionGroup)originalGroup).getChildren(null));
            }
            group.add(restoreAction);
            editor.installPopupHandler(new ContextMenuPopupHandler.Simple(group));
        }
    }

    private static String getIDEDemoText() {
        return ApplicationNamesInfo.getInstance().getFullProductName() + " is a full-featured IDE\nwith a high level of usability and outstanding\nadvanced code editing and refactoring support.\n\nabcdefghijklmnopqrstuvwxyz 0123456789 (){}[]\nABCDEFGHIJKLMNOPQRSTUVWXYZ +-*/= .,;:!? #&$%@|^\n\n<!-- -- != := === >= >- >=> |-> -> <$> </> #[ |||> |= ~@\n\n";
    }

    static void installTrafficLights(@NotNull EditorEx editor) {
        if (editor == null) {
            FontEditorPreview.$$$reportNull$$$0(0);
        }
        EditorMarkupModel markupModel = (EditorMarkupModel)((Object)editor.getMarkupModel());
        markupModel.setErrorStripeRenderer(new DumbTrafficLightRenderer());
        markupModel.setErrorStripeVisible(true);
    }

    static Editor createPreviewEditor(String text2, EditorColorsScheme scheme, boolean editable) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument(text2);
        FileDocumentManagerImpl.registerDocument(editorDocument, new LightVirtualFile());
        EditorEx editor = (EditorEx)(editable ? editorFactory.createEditor(editorDocument) : editorFactory.createViewer(editorDocument));
        editor.setColorsScheme(scheme);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(true);
        settings.setWhitespacesShown(true);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        return editor;
    }

    @Override
    public Component getPanel() {
        return this.myEditor.getComponent();
    }

    @Override
    public void updateView() {
        EditorColorsScheme scheme = this.updateOptionsScheme(this.mySchemeSupplier.get());
        this.myEditor.setColorsScheme(scheme);
        this.myEditor.reinitSettings();
    }

    protected EditorColorsScheme updateOptionsScheme(EditorColorsScheme selectedScheme) {
        return selectedScheme;
    }

    @Override
    public void blinkSelectedHighlightType(Object description) {
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            FontEditorPreview.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener(listener2);
    }

    @Override
    public void disposeUIResources() {
        String previewText = this.myEditor.getDocument().getText();
        if (previewText.equals(FontEditorPreview.getIDEDemoText())) {
            PropertiesComponent.getInstance().unsetValue(PREVIEW_TEXT_KEY);
        } else {
            PropertiesComponent.getInstance().setValue(PREVIEW_TEXT_KEY, previewText);
        }
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installTrafficLights";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RestorePreviewTextAction
    extends DumbAwareAction {
        private static final Key<Boolean> OUR_EDITOR = Key.create("RestorePreviewTextAction.editor");

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestorePreviewTextAction.$$$reportNull$$$0(0);
            }
            Editor editor = e.getData(CommonDataKeys.EDITOR);
            e.getPresentation().setEnabledAndVisible(editor != null && editor.getUserData(OUR_EDITOR) != null && !editor.getDocument().getText().equals(FontEditorPreview.getIDEDemoText()));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor;
            if (e == null) {
                RestorePreviewTextAction.$$$reportNull$$$0(1);
            }
            if ((editor = e.getData(CommonDataKeys.EDITOR)) != null) {
                WriteCommandAction.runWriteCommandAction(editor.getProject(), null, null, () -> editor.getDocument().setText(FontEditorPreview.getIDEDemoText()), new PsiFile[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview$RestorePreviewTextAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DumbTrafficLightRenderer
    implements ErrorStripeRenderer {
        private DumbTrafficLightRenderer() {
        }

        @Override
        public void paint(Component c, Graphics g, Rectangle r) {
            Icon icon2 = AllIcons.General.InspectionsOK;
            icon2.paintIcon(c, g, r.x, r.y);
        }
    }
}

