/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorOptionsTree;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsPanelImpl
extends JPanel
implements OptionsPanel {
    public static final String SELECTED_COLOR_OPTION_PROPERTY = "selected.color.option.type";
    private final ColorOptionsTree myOptionsTree;
    private final ColorDescriptionPanel myOptionsPanel;
    private final ColorAndFontOptions myOptions;
    private final SchemesPanel mySchemesProvider;
    private final String myCategoryName;
    private final PropertiesComponent myProperties;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public OptionsPanelImpl(ColorAndFontOptions options, SchemesPanel schemesProvider, String categoryName) {
        this(options, schemesProvider, categoryName, new ColorAndFontDescriptionPanel());
    }

    public OptionsPanelImpl(ColorAndFontOptions options, SchemesPanel schemesProvider, String categoryName, ColorDescriptionPanel optionsPanel) {
        super(new BorderLayout());
        this.myOptions = options;
        this.mySchemesProvider = schemesProvider;
        this.myCategoryName = categoryName;
        this.myProperties = PropertiesComponent.getInstance();
        this.myOptionsPanel = optionsPanel;
        this.myOptionsPanel.addListener(new ColorDescriptionPanel.Listener(){

            @Override
            public void onSettingsChanged(@NotNull ActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ((ColorAndFontSettingsListener)OptionsPanelImpl.this.myDispatcher.getMulticaster()).settingsChanged();
                OptionsPanelImpl.this.myOptions.stateChanged();
            }

            @Override
            public void onHyperLinkClicked(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String attrName;
                    Settings settings = Settings.KEY.getData(DataManager.getInstance().getDataContext(OptionsPanelImpl.this));
                    String pageName = e.getDescription();
                    Element element2 = e.getSourceElement();
                    try {
                        attrName = element2.getDocument().getText(element2.getStartOffset(), element2.getEndOffset() - element2.getStartOffset());
                    }
                    catch (BadLocationException e1) {
                        return;
                    }
                    SearchableConfigurable page = OptionsPanelImpl.this.myOptions.findSubConfigurable(pageName);
                    if (page != null && settings != null) {
                        Runnable runnable2 = page.enableSearch(attrName);
                        ActionCallback callback2 = settings.select(page);
                        if (runnable2 != null) {
                            callback2.doWhenDone(runnable2);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/application/options/colors/OptionsPanelImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSettingsChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onHyperLinkClicked";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myOptions.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void settingsChanged() {
                if (!OptionsPanelImpl.this.mySchemesProvider.areSchemesLoaded()) {
                    return;
                }
                if (OptionsPanelImpl.this.myOptionsTree.getSelectedValue() != null) {
                    OptionsPanelImpl.this.processListValueChanged();
                }
            }
        });
        this.myOptionsTree = new ColorOptionsTree(this.myCategoryName);
        this.myOptionsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!OptionsPanelImpl.this.mySchemesProvider.areSchemesLoaded()) {
                    return;
                }
                OptionsPanelImpl.this.processListValueChanged();
            }
        });
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myOptionsTree);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.myOptionsPanel.getPanel(), "East");
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener(listener2);
    }

    private void processListValueChanged() {
        String preselectedType;
        EditorSchemeAttributeDescriptor description;
        Object selectedValue = this.myOptionsTree.getSelectedValue();
        EditorSchemeAttributeDescriptor editorSchemeAttributeDescriptor = description = selectedValue instanceof EditorSchemeAttributeDescriptor ? (EditorSchemeAttributeDescriptor)selectedValue : null;
        if (description == null && selectedValue == null && (preselectedType = this.myProperties.getValue(SELECTED_COLOR_OPTION_PROPERTY)) != null) {
            this.myOptionsTree.selectOptionByType(preselectedType);
            description = this.myOptionsTree.getSelectedDescriptor();
        }
        if (description != null) {
            this.myProperties.setValue(SELECTED_COLOR_OPTION_PROPERTY, description.getType());
            this.myOptionsPanel.reset(description);
            this.myDispatcher.getMulticaster().selectedOptionChanged(description);
        } else {
            this.myOptionsPanel.resetDefault();
        }
    }

    private void fillOptionsList() {
        this.myOptionsTree.fillOptions(this.myOptions);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void updateOptionsList() {
        this.fillOptionsList();
        this.processListValueChanged();
    }

    @Override
    public Runnable showOption(String attributeDisplayName) {
        return () -> this.myOptionsTree.selectOptionByName(attributeDisplayName);
    }

    @Override
    public void applyChangesToScheme() {
        EditorSchemeAttributeDescriptor descriptor2 = this.myOptionsTree.getSelectedDescriptor();
        if (descriptor2 != null) {
            this.myOptionsPanel.apply(descriptor2, this.myOptions.getSelectedScheme());
        }
    }

    @Override
    public void selectOption(String attributeType) {
        this.myOptionsTree.selectOptionByType(attributeType);
    }

    @Override
    public Set<String> processListOptions() {
        EditorSchemeAttributeDescriptor[] descriptions;
        HashSet<String> result2 = new HashSet<String>();
        for (EditorSchemeAttributeDescriptor description : descriptions = this.myOptions.getCurrentDescriptions()) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            result2.add(description.toString());
        }
        return result2;
    }

    @Override
    public void setEmptyText(@NotNull String text2, @Nullable ActionListener linkListener2) {
        if (text2 == null) {
            OptionsPanelImpl.$$$reportNull$$$0(0);
        }
        this.myOptionsTree.setEmptyText(text2, linkListener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/application/options/colors/OptionsPanelImpl", "setEmptyText"));
    }

    public static interface ColorDescriptionPanel {
        @NotNull
        public JComponent getPanel();

        public void resetDefault();

        public void reset(@NotNull EditorSchemeAttributeDescriptor var1);

        public void apply(@NotNull EditorSchemeAttributeDescriptor var1, EditorColorsScheme var2);

        public void addListener(@NotNull Listener var1);

        public static interface Listener
        extends EventListener {
            public void onSettingsChanged(@NotNull ActionEvent var1);

            public void onHyperLinkClicked(@NotNull HyperlinkEvent var1);
        }
    }
}

