/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RainbowColorsInSchemeState {
    private final EditorColorsScheme myEditedScheme;
    private final EditorColorsScheme myOriginalScheme;

    public RainbowColorsInSchemeState(@NotNull EditorColorsScheme editedScheme, @NotNull EditorColorsScheme originalScheme) {
        if (editedScheme == null) {
            RainbowColorsInSchemeState.$$$reportNull$$$0(0);
        }
        if (originalScheme == null) {
            RainbowColorsInSchemeState.$$$reportNull$$$0(1);
        }
        this.myEditedScheme = editedScheme;
        this.myOriginalScheme = originalScheme;
    }

    public void apply(@Nullable EditorColorsScheme scheme) {
        if (scheme != null && scheme != this.myEditedScheme) {
            RainbowHighlighter.transferRainbowState(scheme, this.myEditedScheme);
            for (TextAttributesKey key : RainbowHighlighter.RAINBOW_COLOR_KEYS) {
                Color color = this.myEditedScheme.getAttributes(key).getForegroundColor();
                if (color.equals(scheme.getAttributes(key).getForegroundColor())) continue;
                scheme.setAttributes(key, RainbowHighlighter.createRainbowAttribute(color));
            }
            RainbowColorsInSchemeState.updateRainbowMarkup();
        }
    }

    private static void updateRainbowMarkup() {
        Editor[] allEditors;
        for (Editor editor : allEditors = EditorFactory.getInstance().getAllEditors()) {
            PsiFile file2;
            Project project2 = editor.getProject();
            if (project2 == null || (file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument())) == null) continue;
            DaemonCodeAnalyzer.getInstance(project2).restart(file2);
        }
    }

    public boolean isModified(@Nullable Language language2) {
        return language2 == null && this.isRainbowColorsModified() || RainbowHighlighter.isRainbowEnabled(this.myEditedScheme, language2) != RainbowHighlighter.isRainbowEnabled(this.myOriginalScheme, language2);
    }

    private boolean isRainbowColorsModified() {
        for (TextAttributesKey key : RainbowHighlighter.RAINBOW_COLOR_KEYS) {
            if (this.myEditedScheme.getAttributes(key).equals(this.myOriginalScheme.getAttributes(key))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editedScheme";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "originalScheme";
                break;
            }
        }
        objectArray[1] = "com/intellij/application/options/colors/RainbowColorsInSchemeState";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

