/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.fileStatus;

import com.intellij.application.options.colors.fileStatus.FileStatusColorsPanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.openapi.vcs.FileStatusManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileStatusColorsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
Configurable.VariableProjectAppLevel {
    private static final String FILE_STATUS_COLORS_ID = "file.status.colors";
    private final FileStatusColorsPanel myPanel = new FileStatusColorsPanel(FileStatusFactory.getInstance().getAllFileStatuses());

    @Override
    @NotNull
    public String getId() {
        return FILE_STATUS_COLORS_ID;
    }

    @Override
    public String getHelpTopic() {
        return "reference.versionControl.highlight";
    }

    @Override
    @Nls
    public String getDisplayName() {
        return ApplicationBundle.message("title.file.status.colors", new Object[0]);
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        return this.myPanel.getComponent();
    }

    @Override
    public boolean isModified() {
        return this.myPanel.getModel().isModified();
    }

    @Override
    public void apply() throws ConfigurationException {
        this.myPanel.getModel().apply();
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            FileStatusManager.getInstance(project2).fileStatusesChanged();
        }
    }

    @Override
    public void reset() {
        this.myPanel.getModel().reset();
    }

    @Override
    public boolean isProjectLevel() {
        return false;
    }
}

