/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.function.Predicate;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemesCombo<T extends Scheme>
extends ComboBox<MySchemeListItem<T>> {
    public static final String PROJECT_LEVEL = "Project";
    public static final String IDE_LEVEL = "IDE";

    public SchemesCombo() {
        super(new MyComboBoxModel());
        this.setRenderer(new MyListCellRenderer());
    }

    public void resetSchemes(@NotNull Collection<? extends T> schemes) {
        if (schemes == null) {
            SchemesCombo.$$$reportNull$$$0(0);
        }
        MyComboBoxModel model = (MyComboBoxModel)this.getModel();
        model.removeAllElements();
        if (this.supportsProjectSchemes()) {
            model.addElement(new MySeparatorItem(PROJECT_LEVEL));
            this.addItems(schemes, scheme -> this.isProjectScheme(scheme));
            model.addElement(new MySeparatorItem(IDE_LEVEL));
            this.addItems(schemes, scheme -> !this.isProjectScheme(scheme));
        } else {
            this.addItems(schemes, scheme -> true);
        }
    }

    public void selectScheme(@Nullable T scheme) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (((MySchemeListItem)this.getItemAt(i)).getScheme() != scheme) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    @Nullable
    public T getSelectedScheme() {
        Object item = this.getSelectedItem();
        return item != null ? (T)((MySchemeListItem)item).getScheme() : null;
    }

    @Override
    @Nullable
    public MySchemeListItem<T> getSelectedItem() {
        int i = this.getSelectedIndex();
        return i >= 0 ? (MySchemeListItem)this.getItemAt(i) : null;
    }

    protected abstract boolean supportsProjectSchemes();

    protected boolean isProjectScheme(@NotNull T scheme) {
        if (scheme == null) {
            SchemesCombo.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException();
    }

    protected int getIndent(@NotNull T scheme) {
        if (scheme == null) {
            SchemesCombo.$$$reportNull$$$0(2);
        }
        return 0;
    }

    @NotNull
    protected abstract SimpleTextAttributes getSchemeAttributes(T var1);

    private void addItems(@NotNull Collection<? extends T> schemes, Predicate<? super T> filter2) {
        if (schemes == null) {
            SchemesCombo.$$$reportNull$$$0(3);
        }
        for (Scheme scheme : schemes) {
            if (!filter2.test(scheme)) continue;
            ((MyComboBoxModel)this.getModel()).addElement(new MySchemeListItem<Scheme>(scheme));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemes";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/schemes/SchemesCombo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetSchemes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isProjectScheme";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyTitledSeparator
    extends JPanel {
        MyTitledSeparator(@NotNull String titleText) {
            if (titleText == null) {
                MyTitledSeparator.$$$reportNull$$$0(0);
            }
            this.setLayout(new BoxLayout(this, 0));
            JLabel label2 = new JLabel(titleText);
            int verticalSeparatorOffset = label2.getPreferredSize().height / 2;
            this.setBackground(JBColor.WHITE);
            this.add(MyTitledSeparator.createSeparator(verticalSeparatorOffset));
            label2.setHorizontalAlignment(0);
            this.add(label2);
            label2.setBackground(JBColor.WHITE);
            label2.setForeground(JBColor.GRAY);
            label2.setFont(UIUtil.getTitledBorderFont());
            this.add(MyTitledSeparator.createSeparator(verticalSeparatorOffset));
        }

        private static JComponent createSeparator(int verticalOffset) {
            JPanel separatorPanel = new JPanel();
            separatorPanel.setBackground(JBColor.WHITE);
            separatorPanel.setLayout(new BoxLayout(separatorPanel, 1));
            separatorPanel.add(Box.createVerticalStrut(verticalOffset));
            JSeparator separator = new JSeparator();
            separatorPanel.add(separator);
            return separatorPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleText", "com/intellij/application/options/schemes/SchemesCombo$MyTitledSeparator", "<init>"));
        }
    }

    private class MySeparatorItem
    extends MySchemeListItem<T> {
        private final String myTitle;

        MySeparatorItem(String title) {
            if (title == null) {
                MySeparatorItem.$$$reportNull$$$0(0);
            }
            super(null);
            this.myTitle = title;
        }

        @Override
        public boolean isSeparator() {
            return true;
        }

        @Override
        @NotNull
        public String getPresentableText() {
            String string = this.myTitle;
            if (string == null) {
                MySeparatorItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/schemes/SchemesCombo$MySeparatorItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/schemes/SchemesCombo$MySeparatorItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyComboBoxModel<T extends Scheme>
    extends DefaultComboBoxModel<MySchemeListItem<T>> {
        private MyComboBoxModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof MySchemeListItem && ((MySchemeListItem)anObject).isSeparator()) {
                return;
            }
            super.setSelectedItem(anObject);
        }
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer<MySchemeListItem<T>> {
        private MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends MySchemeListItem<T>> list2, MySchemeListItem<T> value2, int index, boolean selected2, boolean hasFocus) {
            Component c;
            if (value2 != null && value2.isSeparator()) {
                c = new MyTitledSeparator("Stored in " + value2.getPresentableText());
            } else {
                c = super.getListCellRendererComponent(list2, value2, index, selected2, hasFocus);
                if (!selected2) {
                    c.setBackground(JBColor.WHITE);
                }
            }
            return c;
        }

        @Override
        protected void customizeCellRenderer(@NotNull JList<? extends MySchemeListItem<T>> list2, MySchemeListItem<T> value2, int index, boolean selected2, boolean hasFocus) {
            Object scheme;
            if (list2 == null) {
                MyListCellRenderer.$$$reportNull$$$0(0);
            }
            if ((scheme = value2.getScheme()) != null) {
                this.append(value2.getPresentableText(), SchemesCombo.this.getSchemeAttributes(scheme));
                if (SchemesCombo.this.supportsProjectSchemes() && index == -1) {
                    this.append("  " + (SchemesCombo.this.isProjectScheme(scheme) ? SchemesCombo.PROJECT_LEVEL : SchemesCombo.IDE_LEVEL), SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
            int indent = index < 0 || scheme == null ? 0 : SchemesCombo.this.getIndent(scheme);
            this.setIpad(JBUI.insetsLeft(indent > 0 ? indent * 10 : 0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/schemes/SchemesCombo$MyListCellRenderer", "customizeCellRenderer"));
        }
    }

    static class MySchemeListItem<T extends Scheme> {
        @Nullable
        private final T myScheme;

        MySchemeListItem(@Nullable T scheme) {
            this.myScheme = scheme;
        }

        @Nullable
        public String getSchemeName() {
            return this.myScheme != null ? this.myScheme.getName() : null;
        }

        @Nullable
        public T getScheme() {
            return this.myScheme;
        }

        @NotNull
        public String getPresentableText() {
            return this.myScheme != null ? this.myScheme.getDisplayName() : "";
        }

        public boolean isSeparator() {
            return false;
        }
    }
}

