/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.MultipleBuildsView;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractViewManager
implements ViewManager,
BuildProgressListener,
Disposable {
    private static final Key<Boolean> PINNED_EXTRACTED_CONTENT = new Key("PINNED_EXTRACTED_CONTENT");
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicClearableLazyValue<MultipleBuildsView> myBuildsViewValue;
    private final Set<MultipleBuildsView> myPinnedViews;
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);
    private final Map<Object, Object> idsMap = ContainerUtil.newConcurrentMap();

    public AbstractViewManager(Project project2) {
        this.myProject = project2;
        this.myBuildContentManager = project2.getService(BuildContentManager.class);
        this.myBuildsViewValue = new AtomicClearableLazyValue<MultipleBuildsView>(){

            @Override
            @NotNull
            protected MultipleBuildsView compute() {
                MultipleBuildsView buildsView = new MultipleBuildsView(AbstractViewManager.this.myProject, AbstractViewManager.this.myBuildContentManager, AbstractViewManager.this);
                Disposer.register(AbstractViewManager.this, buildsView);
                MultipleBuildsView multipleBuildsView = buildsView;
                if (multipleBuildsView == null) {
                    1.$$$reportNull$$$0(0);
                }
                return multipleBuildsView;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/build/AbstractViewManager$1", "compute"));
            }
        };
        this.myPinnedViews = ContainerUtil.newConcurrentSet();
    }

    @Override
    public boolean isConsoleEnabledByDefault() {
        return false;
    }

    @Override
    public boolean isBuildContentView() {
        return true;
    }

    @NotNull
    @Nls
    protected abstract String getViewName();

    protected Map<BuildDescriptor, BuildView> getBuildsMap() {
        return this.myBuildsViewValue.getValue().getBuildsMap();
    }

    @Override
    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        MultipleBuildsView buildsView;
        if (buildId == null) {
            AbstractViewManager.$$$reportNull$$$0(0);
        }
        if (event == null) {
            AbstractViewManager.$$$reportNull$$$0(1);
        }
        if (this.isDisposed.get()) {
            return;
        }
        if (buildId == UNKNOWN_BUILD_ID) {
            Object buildIdCandidate;
            Object object = buildIdCandidate = event instanceof StartBuildEvent ? event.getId() : this.idsMap.get(ObjectUtils.notNull(event.getParentId(), event.getId()));
            if (buildIdCandidate == null) {
                return;
            }
            buildId = buildIdCandidate;
            if (event instanceof StartEvent) {
                this.idsMap.put(event.getId(), buildId);
            }
        }
        if (event instanceof StartBuildEvent) {
            this.configurePinnedContent();
            buildsView = this.myBuildsViewValue.getValue();
        } else {
            buildsView = this.getMultipleBuildsView(buildId);
        }
        if (buildsView != null) {
            buildsView.onEvent(buildId, event);
        }
    }

    @Nullable
    private MultipleBuildsView getMultipleBuildsView(@NotNull Object buildId) {
        MultipleBuildsView buildsView;
        if (buildId == null) {
            AbstractViewManager.$$$reportNull$$$0(2);
        }
        if (!(buildsView = this.myBuildsViewValue.getValue()).shouldConsume(buildId)) {
            buildsView = this.myPinnedViews.stream().filter(pinnedView -> pinnedView.shouldConsume(buildId)).findFirst().orElse(null);
        }
        return buildsView;
    }

    @ApiStatus.Internal
    @Nullable
    public BuildView getBuildView(@NotNull Object buildId) {
        MultipleBuildsView buildsView;
        if (buildId == null) {
            AbstractViewManager.$$$reportNull$$$0(3);
        }
        if ((buildsView = this.getMultipleBuildsView(buildId)) == null) {
            return null;
        }
        return buildsView.getBuildView(buildId);
    }

    void configureToolbar(@NotNull DefaultActionGroup toolbarActions, @NotNull MultipleBuildsView buildsView, @NotNull BuildView view) {
        if (toolbarActions == null) {
            AbstractViewManager.$$$reportNull$$$0(4);
        }
        if (buildsView == null) {
            AbstractViewManager.$$$reportNull$$$0(5);
        }
        if (view == null) {
            AbstractViewManager.$$$reportNull$$$0(6);
        }
        toolbarActions.removeAll();
        toolbarActions.addAll(view.createConsoleActions());
        toolbarActions.add(new PinBuildViewAction(buildsView));
        toolbarActions.add(BuildTreeFilters.createFilteringActionsGroup(view));
    }

    @Nullable
    protected Icon getContentIcon() {
        return null;
    }

    protected void onBuildStart(BuildDescriptor buildDescriptor) {
    }

    protected void onBuildFinish(BuildDescriptor buildDescriptor) {
        this.clearIdsOf(Collections.singleton(buildDescriptor));
        BuildInfo buildInfo = (BuildInfo)buildDescriptor;
        if (buildInfo.result instanceof FailureResult) {
            boolean activate2 = buildInfo.isActivateToolWindowWhenFailed();
            this.myBuildContentManager.setSelectedContent(buildInfo.content, false, false, activate2, null);
            List<? extends Failure> failures = ((FailureResult)buildInfo.result).getFailures();
            if (failures.isEmpty()) {
                return;
            }
            Failure failure = failures.get(0);
            Notification notification = failure.getNotification();
            if (notification != null) {
                String title = notification.getTitle();
                String content2 = notification.getContent();
                SystemNotifications.getInstance().notify(UIBundle.message("tool.window.name.build", new Object[0]), title, content2);
            }
        }
    }

    @Override
    public void dispose() {
        this.isDisposed.set(true);
        this.myPinnedViews.clear();
        this.myBuildsViewValue.drop();
        this.idsMap.clear();
    }

    void onBuildsViewRemove(@NotNull MultipleBuildsView buildsView) {
        if (buildsView == null) {
            AbstractViewManager.$$$reportNull$$$0(7);
        }
        if (this.isDisposed.get()) {
            return;
        }
        if (this.myBuildsViewValue.getValue() == buildsView) {
            this.myBuildsViewValue.drop();
        } else {
            this.myPinnedViews.remove(buildsView);
        }
        this.clearIdsOf(buildsView.getBuildsMap().keySet());
    }

    private void clearIdsOf(@NotNull Collection<? extends BuildDescriptor> builds) {
        if (builds == null) {
            AbstractViewManager.$$$reportNull$$$0(8);
        }
        if (this.idsMap.isEmpty()) {
            return;
        }
        Set ids = builds.stream().map(BuildDescriptor::getId).collect(Collectors.toSet());
        this.idsMap.values().removeIf(val -> ids.contains(val));
    }

    private void configurePinnedContent() {
        MultipleBuildsView buildsView = this.myBuildsViewValue.getValue();
        Content content2 = buildsView.getContent();
        if (content2 != null && content2.isPinned()) {
            String tabName = this.getPinnedTabName(buildsView);
            UIUtil.invokeLaterIfNeeded(() -> {
                content2.setPinnable(false);
                if (content2.getIcon() == null) {
                    content2.setIcon(EmptyIcon.ICON_8);
                }
                content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, Boolean.TRUE);
                ((BuildContentManagerImpl)this.myBuildContentManager).updateTabDisplayName(content2, tabName);
            });
            this.myPinnedViews.add(buildsView);
            this.myBuildsViewValue.drop();
            content2.putUserData(PINNED_EXTRACTED_CONTENT, Boolean.TRUE);
        }
    }

    private String getPinnedTabName(MultipleBuildsView buildsView) {
        Map<BuildDescriptor, BuildView> buildsMap = buildsView.getBuildsMap();
        BuildDescriptor buildInfo = buildsMap.keySet().stream().reduce((b1, b2) -> b1.getStartTime() <= b2.getStartTime() ? b1 : b2).orElse(null);
        if (buildInfo != null) {
            String title = buildInfo.getTitle();
            String viewName = this.getViewName().split(" ")[0];
            String tabName = viewName + ": " + StringUtil.trimStart(title, viewName);
            if (buildsMap.size() > 1) {
                tabName = tabName + String.format(" and %d more", buildsMap.size() - 1);
            }
            return tabName;
        }
        return this.getViewName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarActions";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildsView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builds";
                break;
            }
        }
        objectArray2[1] = "com/intellij/build/AbstractViewManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getMultipleBuildsView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBuildView";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "configureToolbar";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "onBuildsViewRemove";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "clearIdsOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PinBuildViewAction
    extends DumbAwareAction
    implements Toggleable {
        private final Content myContent;

        PinBuildViewAction(MultipleBuildsView buildsView) {
            this.myContent = buildsView.getContent();
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            boolean selected2;
            if (e == null) {
                PinBuildViewAction.$$$reportNull$$$0(0);
            }
            boolean bl = selected2 = !this.myContent.isPinned();
            if (selected2) {
                this.myContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, Boolean.TRUE);
            }
            this.myContent.setPinned(selected2);
            Toggleable.setSelected(e.getPresentation(), selected2);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                PinBuildViewAction.$$$reportNull$$$0(1);
            }
            if (!this.myContent.isValid()) {
                return;
            }
            Boolean isPinnedAndExtracted = (Boolean)this.myContent.getUserData(PINNED_EXTRACTED_CONTENT);
            if (isPinnedAndExtracted == Boolean.TRUE) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            ContentManager contentManager2 = this.myContent.getManager();
            boolean isActiveTab = contentManager2 != null && contentManager2.getSelectedContent() == this.myContent;
            boolean selected2 = this.myContent.isPinned();
            e.getPresentation().setIcon(AllIcons.General.Pin_tab);
            Toggleable.setSelected(e.getPresentation(), selected2);
            String text2 = !isActiveTab ? (selected2 ? IdeBundle.message("action.unpin.active.tab", new Object[0]) : IdeBundle.message("action.pin.active.tab", new Object[0])) : (selected2 ? IdeBundle.message("action.unpin.tab", new Object[0]) : IdeBundle.message("action.pin.tab", new Object[0]));
            e.getPresentation().setText(text2);
            e.getPresentation().setEnabledAndVisible(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/build/AbstractViewManager$PinBuildViewAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    static class BuildInfo
    extends DefaultBuildDescriptor {
        String message;
        String statusMessage;
        long endTime;
        EventResult result;
        Content content;

        BuildInfo(@NotNull Object id2, @NotNull String title, @NotNull String workingDir, long startTime) {
            if (id2 == null) {
                BuildInfo.$$$reportNull$$$0(0);
            }
            if (title == null) {
                BuildInfo.$$$reportNull$$$0(1);
            }
            if (workingDir == null) {
                BuildInfo.$$$reportNull$$$0(2);
            }
            super(id2, title, workingDir, startTime);
            this.endTime = -1L;
        }

        public Icon getIcon() {
            return ExecutionNode.getEventResultIcon(this.result);
        }

        public boolean isRunning() {
            return this.endTime == -1L;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDir";
                    break;
                }
            }
            objectArray[1] = "com/intellij/build/AbstractViewManager$BuildInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

