/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildView;
import com.intellij.build.events.Failure;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildConsoleUtils {
    private static final Logger LOG = Logger.getInstance(BuildConsoleUtils.class);
    private static final Pattern TAG_PATTERN = Pattern.compile("<[^>]*>");
    private static final Pattern A_PATTERN = Pattern.compile("<a ([^>]* )?href=[\"']([^>]*)[\"'][^>]*>");
    private static final String A_CLOSING = "</a>";
    private static final Set<String> NEW_LINES = ContainerUtil.set("<br>", "</br>", "<br/>", "<p>", "</p>", "<p/>", "<pre>", "</pre>");

    public static void printDetails(@NotNull ConsoleView consoleView, @Nullable Failure failure, @Nullable String details) {
        String text2;
        if (consoleView == null) {
            BuildConsoleUtils.$$$reportNull$$$0(0);
        }
        String string = text2 = failure == null ? details : ObjectUtils.chooseNotNull(failure.getDescription(), failure.getMessage());
        if (text2 == null && failure != null && failure.getError() != null) {
            text2 = failure.getError().getMessage();
        }
        if (text2 == null) {
            return;
        }
        Notification notification = failure == null ? null : failure.getNotification();
        BuildConsoleUtils.print(consoleView, notification, text2);
    }

    public static void print(@NotNull BuildTextConsoleView consoleView, @NotNull String group, @NotNull BuildIssue buildIssue) {
        if (consoleView == null) {
            BuildConsoleUtils.$$$reportNull$$$0(1);
        }
        if (group == null) {
            BuildConsoleUtils.$$$reportNull$$$0(2);
        }
        if (buildIssue == null) {
            BuildConsoleUtils.$$$reportNull$$$0(3);
        }
        Project project2 = consoleView.getProject();
        final LinkedHashMap<String, NotificationListener> listenerMap = new LinkedHashMap<String, NotificationListener>();
        for (BuildIssueQuickFix quickFix : buildIssue.getQuickFixes()) {
            listenerMap.put(quickFix.getId(), (notification, event) -> {
                BuildView buildView = BuildConsoleUtils.findBuildView(consoleView);
                quickFix.runQuickFix(project2, (DataProvider)((Object)(buildView == null ? consoleView : buildView)));
            });
        }
        NotificationListener.Adapter listener2 = new NotificationListener.Adapter(){

            @Override
            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                NotificationListener notificationListener = (NotificationListener)listenerMap.get(event.getDescription());
                if (notificationListener != null) {
                    notificationListener.hyperlinkUpdate(notification, event);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/build/BuildConsoleUtils$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Notification notification2 = new Notification(group, buildIssue.getTitle(), buildIssue.getDescription(), NotificationType.WARNING, listener2);
        BuildConsoleUtils.print((ConsoleView)consoleView, notification2, buildIssue.getDescription());
    }

    private static void print(final @NotNull ConsoleView consoleView, final @Nullable Notification notification, @NotNull String text2) {
        if (consoleView == null) {
            BuildConsoleUtils.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            BuildConsoleUtils.$$$reportNull$$$0(5);
        }
        String content2 = StringUtil.convertLineSeparators(text2);
        while (true) {
            Matcher tagMatcher;
            if (!(tagMatcher = TAG_PATTERN.matcher(content2)).find()) break;
            String tagStart = tagMatcher.group();
            consoleView.print(content2.substring(0, tagMatcher.start()), ConsoleViewContentType.ERROR_OUTPUT);
            Matcher aMatcher = A_PATTERN.matcher(tagStart);
            if (aMatcher.matches()) {
                final String href = aMatcher.group(2);
                int linkEnd = content2.indexOf(A_CLOSING, tagMatcher.end());
                if (linkEnd > 0) {
                    String linkText = content2.substring(tagMatcher.end(), linkEnd).replaceAll(TAG_PATTERN.pattern(), "");
                    consoleView.printHyperlink(linkText, new HyperlinkInfo(){

                        @Override
                        public void navigate(Project project2) {
                            if (notification != null && notification.getListener() != null) {
                                notification.getListener().hyperlinkUpdate(notification, IJSwingUtilities.createHyperlinkEvent(href, consoleView.getComponent()));
                            }
                        }
                    });
                    content2 = content2.substring(linkEnd + A_CLOSING.length());
                    continue;
                }
            }
            if (NEW_LINES.contains(tagStart)) {
                consoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            } else {
                consoleView.print(content2.substring(tagMatcher.start(), tagMatcher.end()), ConsoleViewContentType.ERROR_OUTPUT);
            }
            content2 = content2.substring(tagMatcher.end());
        }
        consoleView.print(content2, ConsoleViewContentType.ERROR_OUTPUT);
        consoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    @ApiStatus.Internal
    @NotNull
    public static String getMessageTitle(@NotNull String message) {
        int sepIndex;
        if (message == null) {
            BuildConsoleUtils.$$$reportNull$$$0(6);
        }
        if ((sepIndex = (message = StringUtil.stripHtml(message, true)).indexOf(". ")) < 0) {
            sepIndex = message.indexOf("\n");
        }
        if (sepIndex > 0) {
            message = message.substring(0, sepIndex);
        }
        String string = StringUtil.trimEnd(message, '.');
        if (string == null) {
            BuildConsoleUtils.$$$reportNull$$$0(7);
        }
        return string;
    }

    @ApiStatus.Experimental
    @NotNull
    public static DataProvider getDataProvider(@NotNull Object buildId, @NotNull AbstractViewManager buildListener) {
        BuildView buildView;
        if (buildId == null) {
            BuildConsoleUtils.$$$reportNull$$$0(8);
        }
        if (buildListener == null) {
            BuildConsoleUtils.$$$reportNull$$$0(9);
        }
        DataProvider dataProvider = (buildView = buildListener.getBuildView(buildId)) != null ? buildView : dataId -> null;
        if (dataProvider == null) {
            BuildConsoleUtils.$$$reportNull$$$0(10);
        }
        return dataProvider;
    }

    @ApiStatus.Experimental
    @NotNull
    public static DataProvider getDataProvider(@NotNull Object buildId, @NotNull BuildProgressListener buildListener) {
        DataProvider provider;
        if (buildId == null) {
            BuildConsoleUtils.$$$reportNull$$$0(11);
        }
        if (buildListener == null) {
            BuildConsoleUtils.$$$reportNull$$$0(12);
        }
        if (buildListener instanceof BuildView) {
            provider = (BuildView)buildListener;
        } else if (buildListener instanceof AbstractViewManager) {
            provider = BuildConsoleUtils.getDataProvider(buildId, (AbstractViewManager)buildListener);
        } else {
            LOG.error("BuildView or AbstractViewManager expected to obtain proper DataProvider for build console quick fixes");
            provider = dataId -> null;
        }
        BuildView buildView = provider;
        if (buildView == null) {
            BuildConsoleUtils.$$$reportNull$$$0(13);
        }
        return buildView;
    }

    @Nullable
    private static BuildView findBuildView(@NotNull Component component2) {
        if (component2 == null) {
            BuildConsoleUtils.$$$reportNull$$$0(14);
        }
        Component parent = component2;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof BuildView)) continue;
            return (BuildView)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildIssue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildConsoleUtils";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildListener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildConsoleUtils";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageTitle";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "printDetails";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMessageTitle";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDataProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findBuildView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

