/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.ComponentOrientation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildContentManagerImpl
implements BuildContentManager {
    public static final String Build = "Build";
    public static final String Sync = "Sync";
    public static final String Run = "Run";
    public static final String Debug = "Debug";
    private static final String[] ourPresetOrder = new String[]{"Sync", "Build", "Run", "Debug"};
    private static final Key<Map<Object, CloseListener>> CONTENT_CLOSE_LISTENERS = Key.create("CONTENT_CLOSE_LISTENERS");
    private final Project myProject;
    private final Map<Content, Pair<Icon, AtomicInteger>> liveContentsMap;

    public BuildContentManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(0);
        }
        this.liveContentsMap = ContainerUtil.newConcurrentMap();
        this.myProject = project2;
    }

    @Override
    @NotNull
    public ToolWindow getOrCreateToolWindow() {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance(this.myProject);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(Build);
        if (toolWindow != null) {
            ToolWindow toolWindow2 = toolWindow;
            if (toolWindow2 == null) {
                BuildContentManagerImpl.$$$reportNull$$$0(1);
            }
            return toolWindow2;
        }
        toolWindow = toolWindowManager.registerToolWindow(RegisterToolWindowTask.closable(Build, AllIcons.Toolwindows.ToolWindowBuild));
        final ContentManager contentManager2 = toolWindow.getContentManager();
        contentManager2.addDataProvider(new DataProvider(){
            private int myInsideGetData = 0;

            @Override
            public Object getData(@NotNull String dataId) {
                if (dataId == null) {
                    1.$$$reportNull$$$0(0);
                }
                ++this.myInsideGetData;
                try {
                    Object object = this.myInsideGetData == 1 ? DataManager.getInstance().getDataContext(contentManager2.getComponent()).getData(dataId) : null;
                    return object;
                }
                finally {
                    --this.myInsideGetData;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/build/BuildContentManagerImpl$1", "getData"));
            }
        });
        ContentManagerWatcher.watchContentManager(toolWindow, contentManager2);
        ToolWindow toolWindow3 = toolWindow;
        if (toolWindow3 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(2);
        }
        return toolWindow3;
    }

    private void invokeLaterIfNeeded(@NotNull DumbAwareRunnable runnable2) {
        if (runnable2 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDefault()) {
            return;
        }
        if (!StartupManagerEx.getInstanceEx(this.myProject).startupActivityPassed()) {
            StartupManagerEx.getInstanceEx(this.myProject).registerPostStartupDumbAwareActivity(() -> GuiUtils.invokeLaterIfNeeded(runnable2, ModalityState.defaultModalityState(), this.myProject.getDisposed()));
        } else {
            GuiUtils.invokeLaterIfNeeded(runnable2, ModalityState.defaultModalityState(), this.myProject.getDisposed());
        }
    }

    @Override
    public void addContent(Content content2) {
        this.invokeLaterIfNeeded(() -> {
            ContentManager contentManager2 = this.getOrCreateToolWindow().getContentManager();
            String name = content2.getTabName();
            String category = StringUtil.trimEnd(StringUtil.split(name, " ").get(0), ':');
            int idx = -1;
            for (int i = 0; i < ourPresetOrder.length; ++i) {
                String s = ourPresetOrder[i];
                if (!s.equals(category)) continue;
                idx = i;
                break;
            }
            Content[] existingContents = contentManager2.getContents();
            if (idx != -1) {
                Content[] existingCategoriesNames = MultiMap.createSmart();
                Content[] contentArray = existingContents;
                int n = contentArray.length;
                for (int i = 0; i < n; ++i) {
                    Content existingContent = contentArray[i];
                    String tabName = existingContent.getTabName();
                    existingCategoriesNames.putValue(StringUtil.trimEnd(StringUtil.split(tabName, " ").get(0), ':'), tabName);
                }
                int place = 0;
                for (int i = 0; i <= idx; ++i) {
                    String key = ourPresetOrder[i];
                    Collection tabNames = existingCategoriesNames.get(key);
                    place += tabNames.size();
                }
                contentManager2.addContent(content2, place);
            } else {
                contentManager2.addContent(content2);
            }
            for (Content existingContent : existingContents) {
                existingContent.setDisplayName(existingContent.getTabName());
            }
            String tabName = content2.getTabName();
            this.updateTabDisplayName(content2, tabName);
        });
    }

    public void updateTabDisplayName(Content content2, String tabName) {
        this.invokeLaterIfNeeded(() -> {
            if (!tabName.equals(content2.getDisplayName())) {
                content2.setTabName(tabName);
                content2.setDisplayName(tabName);
            }
        });
    }

    @Override
    public void removeContent(Content content2) {
        this.invokeLaterIfNeeded(() -> {
            ContentManager contentManager2;
            ToolWindow toolWindow = ToolWindowManager.getInstance(this.myProject).getToolWindow(Build);
            ContentManager contentManager3 = contentManager2 = toolWindow == null ? null : toolWindow.getContentManager();
            if (contentManager2 != null && !contentManager2.isDisposed()) {
                contentManager2.removeContent(content2, true);
            }
        });
    }

    @Override
    public void setSelectedContent(@NotNull Content content2, boolean requestFocus, boolean forcedFocus, boolean activate2, @Nullable Runnable activationCallback) {
        if (content2 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(4);
        }
        this.invokeLaterIfNeeded(() -> {
            ToolWindow toolWindow = this.getOrCreateToolWindow();
            if (!toolWindow.isAvailable()) {
                return;
            }
            if (activate2) {
                toolWindow.show(activationCallback);
            }
            toolWindow.getContentManager().setSelectedContent(content2, requestFocus, forcedFocus, false);
        });
    }

    @Override
    public Content addTabbedContent(@NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, @Nullable Icon icon2, @Nullable Disposable childDisposable) {
        TabbedContent tabbedContent;
        if (contentComponent == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(5);
        }
        if (groupPrefix == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(6);
        }
        if (tabName == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(7);
        }
        ContentManager contentManager2 = this.getOrCreateToolWindow().getContentManager();
        ContentUtilEx.addTabbedContent(contentManager2, contentComponent, groupPrefix, tabName, false, childDisposable);
        Content content2 = contentManager2.findContent(ContentUtilEx.getFullName(groupPrefix, tabName));
        if (icon2 != null && (tabbedContent = ContentUtilEx.findTabbedContent(contentManager2, groupPrefix)) != null) {
            tabbedContent.putUserData(ToolWindow.SHOW_CONTENT_ICON, Boolean.TRUE);
            tabbedContent.setIcon(icon2);
        }
        return content2;
    }

    public void startBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content2, @Nullable BuildProcessHandler processHandler2) {
        if (buildDescriptor == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(8);
        }
        if (content2 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(9);
        }
        if (processHandler2 != null) {
            Map<Object, CloseListener> closeListenerMap = content2.getUserData(CONTENT_CLOSE_LISTENERS);
            if (closeListenerMap == null) {
                closeListenerMap = new HashMap<Object, CloseListener>();
                content2.putUserData(CONTENT_CLOSE_LISTENERS, closeListenerMap);
            }
            closeListenerMap.put(buildDescriptor.getId(), new CloseListener(content2, processHandler2));
        }
        this.invokeLaterIfNeeded(() -> {
            Pair pair = this.liveContentsMap.computeIfAbsent(content2, c -> Pair.pair(c.getIcon(), new AtomicInteger(0)));
            ((AtomicInteger)pair.second).incrementAndGet();
            content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, Boolean.TRUE);
            if (pair.first == null) {
                content2.putUserData(Content.TAB_LABEL_ORIENTATION_KEY, ComponentOrientation.RIGHT_TO_LEFT);
            }
            content2.setIcon(ExecutionUtil.getLiveIndicator((Icon)pair.first, 0, 13));
            JComponent component2 = content2.getComponent();
            component2.invalidate();
            this.getOrCreateToolWindow().setIcon(ExecutionUtil.getLiveIndicator(AllIcons.Toolwindows.ToolWindowBuild));
        });
    }

    public void finishBuildNotified(@NotNull BuildDescriptor buildDescriptor, @NotNull Content content2) {
        CloseListener closeListener;
        Map<Object, CloseListener> closeListenerMap;
        if (buildDescriptor == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(10);
        }
        if (content2 == null) {
            BuildContentManagerImpl.$$$reportNull$$$0(11);
        }
        if ((closeListenerMap = content2.getUserData(CONTENT_CLOSE_LISTENERS)) != null && (closeListener = closeListenerMap.remove(buildDescriptor.getId())) != null) {
            closeListener.dispose();
            if (closeListenerMap.isEmpty()) {
                content2.putUserData(CONTENT_CLOSE_LISTENERS, null);
            }
        }
        this.invokeLaterIfNeeded(() -> {
            Pair<Icon, AtomicInteger> pair = this.liveContentsMap.get(content2);
            if (pair != null && ((AtomicInteger)pair.second).decrementAndGet() == 0) {
                content2.setIcon((Icon)pair.first);
                if (pair.first == null) {
                    content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, Boolean.FALSE);
                }
                this.liveContentsMap.remove(content2);
                if (this.liveContentsMap.isEmpty()) {
                    this.getOrCreateToolWindow().setIcon(AllIcons.Toolwindows.ToolWindowBuild);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildContentManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPrefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildContentManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedContent";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTabbedContent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "startBuildNotified";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "finishBuildNotified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CloseListener
    extends BaseContentCloseListener {
        @Nullable
        private BuildProcessHandler myProcessHandler;

        private CloseListener(@NotNull Content content2, BuildProcessHandler processHandler2) {
            if (content2 == null) {
                CloseListener.$$$reportNull$$$0(0);
            }
            if (processHandler2 == null) {
                CloseListener.$$$reportNull$$$0(1);
            }
            super(content2, BuildContentManagerImpl.this.myProject);
            this.myProcessHandler = processHandler2;
        }

        @Override
        protected void disposeContent(@NotNull Content content2) {
            if (content2 == null) {
                CloseListener.$$$reportNull$$$0(2);
            }
            if (this.myProcessHandler instanceof Disposable) {
                Disposer.dispose((Disposable)((Object)this.myProcessHandler));
            }
            this.myProcessHandler = null;
        }

        @Override
        protected boolean closeQuery(@NotNull Content content2, boolean modal) {
            if (content2 == null) {
                CloseListener.$$$reportNull$$$0(3);
            }
            if (this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated() || this.myProcessHandler.isProcessTerminating()) {
                return true;
            }
            this.myProcessHandler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, Boolean.TRUE);
            String sessionName = this.myProcessHandler.getExecutionName();
            BaseContentCloseListener.WaitForProcessTask task2 = new BaseContentCloseListener.WaitForProcessTask(this.myProcessHandler, sessionName, modal, BuildContentManagerImpl.this.myProject){

                @Override
                public void onCancel() {
                    CloseListener.this.myProcessHandler.forceProcessDetach();
                }
            };
            return this.askUserAndWait(this.myProcessHandler, sessionName, task2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/build/BuildContentManagerImpl$CloseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disposeContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "closeQuery";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

