/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildConsoleView;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.build.CompositeView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.FilePosition;
import com.intellij.build.Filterable;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.DerivedResult;
import com.intellij.build.events.DuplicateMessageAware;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.FinishEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.build.events.ProgressBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class BuildTreeConsoleView
implements ConsoleView,
DataProvider,
BuildConsoleView,
Filterable<ExecutionNode>,
OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance(BuildTreeConsoleView.class);
    @NonNls
    private static final String TREE = "tree";
    @NonNls
    private static final String SPLITTER_PROPERTY = "BuildView.Splitter.Proportion";
    private final JPanel myPanel;
    private final Map<Object, ExecutionNode> nodesMap;
    private final Project myProject;
    private final ConsoleViewHandler myConsoleViewHandler;
    private final String myWorkingDir;
    private final AtomicBoolean myFinishedBuildEventReceived;
    private final AtomicBoolean myDisposed;
    private final AtomicBoolean myShownFirstError;
    private final boolean myFocusFirstError;
    private final StructureTreeModel<AbstractTreeStructure> myTreeModel;
    private final Tree myTree;
    private final ExecutionNode myRootNode;
    private final ExecutionNode myBuildProgressRootNode;
    private final Set<Predicate<ExecutionNode>> myNodeFilters;
    private final ProblemOccurrenceNavigatorSupport myOccurrenceNavigatorSupport;
    private final Set<BuildEvent> myDeferredEvents;

    public BuildTreeConsoleView(Project project2, BuildDescriptor buildDescriptor, @Nullable ExecutionConsole executionConsole, @NotNull BuildViewSettingsProvider buildViewSettingsProvider) {
        if (buildViewSettingsProvider == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(0);
        }
        this.myPanel = new JPanel();
        this.nodesMap = ContainerUtil.newConcurrentMap();
        this.myFinishedBuildEventReceived = new AtomicBoolean();
        this.myDisposed = new AtomicBoolean();
        this.myShownFirstError = new AtomicBoolean();
        this.myDeferredEvents = ContainerUtil.newConcurrentSet();
        this.myNodeFilters = ContainerUtil.newConcurrentSet();
        this.myProject = project2;
        this.myWorkingDir = FileUtil.toSystemIndependentName(buildDescriptor.getWorkingDir());
        this.myFocusFirstError = !(buildDescriptor instanceof DefaultBuildDescriptor) || ((DefaultBuildDescriptor)buildDescriptor).isActivateToolWindowWhenFailed();
        this.myRootNode = new ExecutionNode(this.myProject, null, true, this::isCorrectThread);
        this.myBuildProgressRootNode = new ExecutionNode(this.myProject, this.myRootNode, true, this::isCorrectThread);
        this.myRootNode.setFilter(this.getFilter());
        this.myRootNode.add(this.myBuildProgressRootNode);
        MyTreeStructure treeStructure = new MyTreeStructure();
        this.myTreeModel = new StructureTreeModel<MyTreeStructure>(treeStructure, null, Invoker.forBackgroundThreadWithoutReadAction(this), this);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel(this.myTreeModel, this);
        asyncTreeModel.addTreeModelListener(new ExecutionNodeAutoExpandingListener());
        this.myTree = BuildTreeConsoleView.initTree(asyncTreeModel);
        JPanel myContentPanel = new JPanel();
        myContentPanel.setLayout(new CardLayout());
        myContentPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree, 0), TREE);
        this.myPanel.setLayout(new BorderLayout());
        OnePixelSplitter myThreeComponentsSplitter = new OnePixelSplitter(SPLITTER_PROPERTY, 0.33f);
        myThreeComponentsSplitter.setFirstComponent(myContentPanel);
        this.myConsoleViewHandler = new ConsoleViewHandler(this.myProject, this.myTree, this.myBuildProgressRootNode, this, executionConsole, buildViewSettingsProvider);
        myThreeComponentsSplitter.setSecondComponent(this.myConsoleViewHandler.getComponent());
        this.myPanel.add((Component)myThreeComponentsSplitter, "Center");
        BuildTreeFilters.install(this);
        this.myOccurrenceNavigatorSupport = new ProblemOccurrenceNavigatorSupport(this.myTree);
    }

    private boolean isCorrectThread() {
        if (this.myTreeModel != null) {
            return this.myTreeModel.getInvoker().isValidThread();
        }
        return true;
    }

    private void installContextMenu(@NotNull StartBuildEvent startBuildEvent) {
        if (startBuildEvent == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(1);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            AnAction[] restartActions;
            DefaultActionGroup group = new DefaultActionGroup();
            DefaultActionGroup rerunActionGroup = new DefaultActionGroup();
            for (AnAction anAction : restartActions = startBuildEvent.getRestartActions()) {
                rerunActionGroup.add(anAction);
            }
            if (restartActions.length > 0) {
                group.addAll(rerunActionGroup);
                group.addSeparator();
            }
            EditSourceAction edit = new EditSourceAction();
            ActionUtil.copyFrom(edit, "EditSource");
            group.add(edit);
            group.addSeparator();
            group.addAll(BuildTreeFilters.createFilteringActionsGroup(this));
            group.addSeparator();
            CommonActionsManager actionsManager = CommonActionsManager.getInstance();
            AnAction prevAction = actionsManager.createPrevOccurenceAction(this);
            group.add(prevAction);
            AnAction nextAction = actionsManager.createNextOccurenceAction(this);
            group.add(nextAction);
            PopupHandler.installPopupHandler((JComponent)this.myTree, group, "BuildView");
        });
    }

    @Override
    public void clear() {
        this.myTreeModel.getInvoker().runOrInvokeLater(() -> {
            this.getRootElement().removeChildren();
            this.nodesMap.clear();
            this.myConsoleViewHandler.clear();
        });
        this.scheduleUpdate(this.getRootElement(), true);
    }

    @Override
    public boolean isFilteringEnabled() {
        return true;
    }

    @Override
    @NotNull
    public Predicate<ExecutionNode> getFilter() {
        Predicate<ExecutionNode> predicate = executionNode -> executionNode == this.getBuildProgressRootNode() || executionNode.isRunning() || executionNode.isFailed() || this.myNodeFilters.stream().anyMatch(predicate -> predicate.test(executionNode));
        if (predicate == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(2);
        }
        return predicate;
    }

    @Override
    public void addFilter(@NotNull Predicate<ExecutionNode> executionTreeFilter) {
        if (executionTreeFilter == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(3);
        }
        this.myNodeFilters.add(executionTreeFilter);
        this.updateFilter();
    }

    @Override
    public void removeFilter(@NotNull Predicate<ExecutionNode> filter2) {
        if (filter2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(4);
        }
        this.myNodeFilters.remove(filter2);
        this.updateFilter();
    }

    @Override
    public boolean contains(@NotNull Predicate<ExecutionNode> filter2) {
        if (filter2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(5);
        }
        return this.myNodeFilters.contains(filter2);
    }

    private void updateFilter() {
        ExecutionNode rootElement = this.getRootElement();
        this.myTreeModel.getInvoker().runOrInvokeLater(() -> {
            rootElement.setFilter(this.getFilter());
            this.scheduleUpdate(rootElement, true);
        });
    }

    private ExecutionNode getRootElement() {
        return this.myRootNode;
    }

    private ExecutionNode getBuildProgressRootNode() {
        return this.myBuildProgressRootNode;
    }

    @Override
    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(6);
        }
        if (contentType == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(7);
        }
    }

    @Nullable
    private ExecutionNode getOrMaybeCreateParentNode(@NotNull BuildEvent event) {
        ExecutionNode parentNode;
        if (event == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(8);
        }
        ExecutionNode executionNode = parentNode = event.getParentId() == null ? null : this.nodesMap.get(event.getParentId());
        if (event instanceof MessageEvent && (parentNode = this.createMessageParentNodes((MessageEvent)event, parentNode)) != null) {
            this.scheduleUpdate(parentNode, true);
        }
        return parentNode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onEventInternal(@NotNull Object buildId, @NotNull BuildEvent event) {
        Runnable selectErrorNodeTask;
        ExecutionNode buildProgressRootNode;
        ExecutionNode currentNode;
        SmartHashSet<ExecutionNode> structureChanged;
        block33: {
            Object eventId;
            block29: {
                ExecutionNode parentNode;
                block30: {
                    Navigatable messageEventNavigatable;
                    MessageEvent messageEvent;
                    block31: {
                        Iterator<? extends Failure> iterator2;
                        block32: {
                            block27: {
                                block28: {
                                    if (buildId == null) {
                                        BuildTreeConsoleView.$$$reportNull$$$0(9);
                                    }
                                    if (event == null) {
                                        BuildTreeConsoleView.$$$reportNull$$$0(10);
                                    }
                                    structureChanged = new SmartHashSet<ExecutionNode>();
                                    parentNode = this.getOrMaybeCreateParentNode(event);
                                    eventId = event.getId();
                                    currentNode = this.nodesMap.get(eventId);
                                    buildProgressRootNode = this.getBuildProgressRootNode();
                                    selectErrorNodeTask = null;
                                    if (!(event instanceof StartEvent) && !(event instanceof MessageEvent)) break block27;
                                    if (currentNode != null) {
                                        LOG.warn("start event id collision found:" + eventId + ", was also in node: " + currentNode.getTitle());
                                        return;
                                    }
                                    if (event instanceof DuplicateMessageAware) {
                                        if (!this.myFinishedBuildEventReceived.get()) {
                                            this.myDeferredEvents.add(event);
                                            return;
                                        }
                                        if (parentNode != null && parentNode.findFirstChild(node -> event.getMessage().equals(node.getName())) != null) {
                                            return;
                                        }
                                    }
                                    if (!(event instanceof StartBuildEvent)) break block28;
                                    currentNode = buildProgressRootNode;
                                    this.installContextMenu((StartBuildEvent)event);
                                    String buildTitle = ((StartBuildEvent)event).getBuildTitle();
                                    currentNode.setTitle(buildTitle);
                                    break block29;
                                }
                                currentNode = new ExecutionNode(this.myProject, parentNode, parentNode == buildProgressRootNode, this::isCorrectThread);
                                if (!(event instanceof MessageEvent)) break block30;
                                messageEvent = (MessageEvent)event;
                                currentNode.setStartTime(messageEvent.getEventTime());
                                ContainerUtil.addIfNotNull(structureChanged, currentNode.setEndTime(messageEvent.getEventTime()));
                                messageEventNavigatable = messageEvent.getNavigatable(this.myProject);
                                currentNode.setNavigatable(messageEventNavigatable);
                                MessageEventResult messageEventResult = messageEvent.getResult();
                                ContainerUtil.addIfNotNull(structureChanged, currentNode.setResult(messageEventResult));
                                if (!(messageEventResult instanceof FailureResult)) break block31;
                                iterator2 = ((FailureResult)((Object)messageEventResult)).getFailures().iterator();
                                break block32;
                            }
                            currentNode = this.nodesMap.get(eventId);
                            if (currentNode != null) break block33;
                            if (event instanceof ProgressBuildEvent) {
                                currentNode = new ExecutionNode(this.myProject, parentNode, parentNode == buildProgressRootNode, this::isCorrectThread);
                                this.nodesMap.put(eventId, currentNode);
                                if (parentNode != null) {
                                    structureChanged.add(parentNode);
                                    parentNode.add(currentNode);
                                }
                                break block33;
                            } else if (event instanceof OutputBuildEvent && parentNode != null) {
                                this.myConsoleViewHandler.addOutput(parentNode, buildId, event);
                            }
                            break block33;
                        }
                        while (iterator2.hasNext()) {
                            Failure failure = iterator2.next();
                            selectErrorNodeTask = selectErrorNodeTask != null ? selectErrorNodeTask : this.showErrorIfFirst(currentNode, failure.getNavigatable());
                        }
                    }
                    if (messageEvent.getKind() == MessageEvent.Kind.ERROR) {
                        Runnable runnable2 = selectErrorNodeTask = selectErrorNodeTask != null ? selectErrorNodeTask : this.showErrorIfFirst(currentNode, messageEventNavigatable);
                    }
                    if (parentNode != null) {
                        if (parentNode != buildProgressRootNode) {
                            this.myConsoleViewHandler.addOutput(parentNode, buildId, event);
                            this.myConsoleViewHandler.addOutput(parentNode, "\n", true);
                        }
                        this.reportMessageKind(messageEvent, parentNode);
                    }
                    this.myConsoleViewHandler.addOutput(currentNode, buildId, event);
                }
                if (parentNode != null) {
                    structureChanged.add(parentNode);
                    parentNode.add(currentNode);
                }
            }
            this.nodesMap.put(eventId, currentNode);
        }
        if (currentNode == null) {
            return;
        }
        currentNode.setName(event.getMessage());
        currentNode.setHint(event.getHint());
        if (currentNode.getStartTime() == 0L) {
            currentNode.setStartTime(event.getEventTime());
        }
        if (event instanceof FinishEvent) {
            EventResult result2 = ((FinishEvent)event).getResult();
            if (result2 instanceof DerivedResult) {
                result2 = BuildTreeConsoleView.calculateDerivedResult((DerivedResult)result2, currentNode);
            }
            ContainerUtil.addIfNotNull(structureChanged, currentNode.setResult(result2));
            ContainerUtil.addIfNotNull(structureChanged, currentNode.setEndTime(event.getEventTime()));
            SkippedResultImpl skippedResult = new SkippedResultImpl();
            BuildTreeConsoleView.finishChildren(structureChanged, currentNode, skippedResult);
            if (result2 instanceof FailureResult) {
                for (Failure failure : ((FailureResult)result2).getFailures()) {
                    Runnable runnable3 = this.addChildFailureNode(currentNode, failure, event.getMessage(), structureChanged);
                    if (selectErrorNodeTask != null) continue;
                    selectErrorNodeTask = runnable3;
                }
            }
        }
        if (event instanceof FinishBuildEvent) {
            this.myFinishedBuildEventReceived.set(true);
            Object aHint = event.getHint();
            String time = DateFormatUtil.formatDateTime(event.getEventTime());
            aHint = aHint == null ? "at " + time : (String)aHint + " at " + time;
            currentNode.setHint((String)aHint);
            this.myDeferredEvents.forEach(buildEvent -> this.onEventInternal(buildId, (BuildEvent)buildEvent));
            if (this.myConsoleViewHandler.myExecutionNode == null) {
                this.invokeLater(() -> this.myConsoleViewHandler.setNode(buildProgressRootNode));
            }
        }
        if (structureChanged.isEmpty()) {
            this.scheduleUpdate(currentNode, false);
        } else {
            for (ExecutionNode node2 : structureChanged) {
                this.scheduleUpdate(node2, true);
            }
        }
        if (selectErrorNodeTask != null) {
            Runnable finalSelectErrorTask = selectErrorNodeTask;
            this.myTreeModel.invalidate(this.getRootElement(), true).onProcessed(p -> finalSelectErrorTask.run());
        }
    }

    @ApiStatus.Internal
    @Nullable
    public String getSelectedNodeConsoleText() {
        ExecutionConsole console = this.myConsoleViewHandler.getCurrentConsole();
        if (console instanceof ConsoleViewImpl) {
            ((ConsoleViewImpl)console).flushDeferredText();
            return ((ConsoleViewImpl)console).getText();
        }
        if (this.myConsoleViewHandler.myView.isViewVisible("empty")) {
            return "";
        }
        return null;
    }

    private static EventResult calculateDerivedResult(DerivedResult result2, ExecutionNode node) {
        if (node.getResult() != null) {
            return node.getResult();
        }
        if (node.isFailed()) {
            return result2.createFailureResult();
        }
        return result2.createDefaultResult();
    }

    private void reportMessageKind(@NotNull MessageEvent messageEvent, @NotNull ExecutionNode parentNode) {
        MessageEvent.Kind eventKind;
        if (messageEvent == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(11);
        }
        if (parentNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(12);
        }
        if ((eventKind = messageEvent.getKind()) == MessageEvent.Kind.ERROR || eventKind == MessageEvent.Kind.WARNING || eventKind == MessageEvent.Kind.INFO) {
            ExecutionNode executionNode = parentNode;
            do {
                ExecutionNode updatedRoot;
                if ((updatedRoot = executionNode.reportChildMessageKind(eventKind)) != null) {
                    this.scheduleUpdate(updatedRoot, true);
                    continue;
                }
                this.scheduleUpdate(executionNode, false);
            } while ((executionNode = executionNode.getParent()) != null);
            this.scheduleUpdate(this.getRootElement(), false);
        }
    }

    @Nullable
    private Runnable showErrorIfFirst(@NotNull ExecutionNode node, @Nullable Navigatable navigatable) {
        if (node == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(13);
        }
        if (this.myShownFirstError.compareAndSet(false, true)) {
            return () -> {
                TreeUtil.promiseSelect((JTree)this.myTree, BuildTreeConsoleView.visitor(node));
                if (this.myFocusFirstError && navigatable != null && navigatable != NonNavigatable.INSTANCE) {
                    ApplicationManager.getApplication().invokeLater(() -> navigatable.navigate(true), ModalityState.defaultModalityState(), this.myProject.getDisposed());
                }
            };
        }
        return null;
    }

    @Override
    public boolean hasNextOccurence() {
        return this.myOccurrenceNavigatorSupport.hasNextOccurence();
    }

    @Override
    public boolean hasPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.hasPreviousOccurence();
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurrenceNavigatorSupport.goNextOccurence();
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.goPreviousOccurence();
    }

    @Override
    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.myOccurrenceNavigatorSupport.getNextOccurenceActionName();
        if (string == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.myOccurrenceNavigatorSupport.getPreviousOccurenceActionName();
        if (string == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static TreeVisitor visitor(@NotNull ExecutionNode executionNode) {
        if (executionNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(16);
        }
        TreeVisitor treeVisitor = path2 -> {
            Object object = ((DefaultMutableTreeNode)path2.getLastPathComponent()).getUserObject();
            if (executionNode == object) {
                return TreeVisitor.Action.INTERRUPT;
            }
            return TreeVisitor.Action.CONTINUE;
        };
        if (treeVisitor == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(17);
        }
        return treeVisitor;
    }

    @Nullable
    private Runnable addChildFailureNode(@NotNull ExecutionNode parentNode, @NotNull Failure failure, @NotNull String defaultFailureMessage, @NotNull Set<ExecutionNode> strcutreChanged) {
        List<Failure> failures;
        EventResult result2;
        String failureNodeName;
        ExecutionNode failureNode;
        String text2;
        if (parentNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(18);
        }
        if (failure == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(19);
        }
        if (defaultFailureMessage == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(20);
        }
        if (strcutreChanged == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(21);
        }
        if ((text2 = ObjectUtils.chooseNotNull(failure.getDescription(), failure.getMessage())) == null && failure.getError() != null) {
            text2 = failure.getError().getMessage();
        }
        if (text2 == null) {
            text2 = defaultFailureMessage;
        }
        if ((failureNode = parentNode.findFirstChild(arg_0 -> BuildTreeConsoleView.lambda$addChildFailureNode$12(failureNodeName = BuildConsoleUtils.getMessageTitle(text2), arg_0))) == null) {
            failureNode = new ExecutionNode(this.myProject, parentNode, true, this::isCorrectThread);
            failureNode.setName(failureNodeName);
            parentNode.add(failureNode);
        }
        if (failure.getNavigatable() == null) {
            failureNode.setNavigatable(failure.getNavigatable());
        }
        if ((result2 = failureNode.getResult()) instanceof FailureResult) {
            failures = new ArrayList<Failure>(((FailureResult)result2).getFailures());
            failures.add(failure);
        } else {
            failures = Collections.singletonList(failure);
        }
        ExecutionNode updatedRoot = failureNode.setResult(new FailureResultImpl(failures));
        if (updatedRoot == null) {
            updatedRoot = parentNode;
        }
        strcutreChanged.add(updatedRoot);
        this.myConsoleViewHandler.addOutput(failureNode, failure);
        return this.showErrorIfFirst(failureNode, failure.getNavigatable());
    }

    private static void finishChildren(@NotNull SmartHashSet<ExecutionNode> structureChanged, @NotNull ExecutionNode node, @NotNull EventResult result2) {
        List<ExecutionNode> childList;
        if (structureChanged == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(22);
        }
        if (node == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(23);
        }
        if (result2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(24);
        }
        if ((childList = node.getChildList()).isEmpty()) {
            return;
        }
        for (ExecutionNode child2 : new ArrayList<ExecutionNode>(childList)) {
            if (!child2.isRunning()) continue;
            BuildTreeConsoleView.finishChildren(structureChanged, child2, result2);
            ContainerUtil.addIfNotNull(structureChanged, child2.setResult(result2));
        }
    }

    @Override
    public void scrollTo(int offset) {
    }

    @Override
    public void attachToProcess(ProcessHandler processHandler2) {
    }

    @Override
    public boolean isOutputPaused() {
        return false;
    }

    @Override
    public void setOutputPaused(boolean value2) {
    }

    @Override
    public boolean hasDeferredOutput() {
        return false;
    }

    @Override
    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(25);
        }
    }

    @Override
    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(26);
        }
    }

    @Override
    public void addMessageFilter(@NotNull Filter filter2) {
        if (filter2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(27);
        }
    }

    @Override
    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(28);
        }
    }

    @Override
    public int getContentSize() {
        return 0;
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public AnAction @NotNull [] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(29);
        }
        return AnAction.EMPTY_ARRAY;
    }

    @Override
    public void allowHeavyFilters() {
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(30);
        }
        return jPanel;
    }

    @Override
    public JComponent getPreferredFocusableComponent() {
        return this.myTree;
    }

    @Override
    public void dispose() {
        this.myDisposed.set(true);
    }

    public boolean isDisposed() {
        return this.myDisposed.get();
    }

    @Override
    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (buildId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(31);
        }
        if (event == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(32);
        }
        this.myTreeModel.getInvoker().invoke(() -> this.onEventInternal(buildId, event));
    }

    void scheduleUpdate(ExecutionNode executionNode, boolean parentStructureChanged) {
        ExecutionNode node = executionNode.getParent() == null || !parentStructureChanged ? executionNode : executionNode.getParent();
        this.myTreeModel.invalidate(node, parentStructureChanged);
    }

    private ExecutionNode createMessageParentNodes(MessageEvent messageEvent, ExecutionNode parentNode) {
        Object messageEventParentId = messageEvent.getParentId();
        if (messageEventParentId == null) {
            return null;
        }
        if (messageEvent instanceof FileMessageEvent) {
            FilePosition filePosition = ((FileMessageEvent)messageEvent).getFilePosition();
            String filePath2 = FileUtil.toSystemIndependentName(filePosition.getFile().getPath());
            String parentsPath = "";
            String relativePath = FileUtil.getRelativePath(this.myWorkingDir, filePath2, '/');
            if (relativePath != null) {
                parentsPath = this.myWorkingDir;
            }
            relativePath = StringUtil.isEmpty(parentsPath) ? filePath2 : FileUtil.getRelativePath(parentsPath, filePath2, '/');
            parentNode = this.getOrCreateMessagesNode(messageEvent, filePath2, parentNode, relativePath, () -> {
                VirtualFile file2 = VfsUtil.findFileByIoFile(filePosition.getFile(), false);
                if (file2 != null) {
                    return file2.getFileType().getIcon();
                }
                return null;
            }, messageEvent.getNavigatable(this.myProject), this.nodesMap, this.myProject);
        }
        return parentNode;
    }

    public void hideRootNode() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myTree != null) {
                this.myTree.setRootVisible(false);
                this.myTree.setShowsRootHandles(true);
            }
        });
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(33);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.build.tool.window";
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.extractNavigatables();
        }
        return null;
    }

    private Object extractNavigatables() {
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (ExecutionNode each : this.getSelectedNodes()) {
            List<Navigatable> navigatable = each.getNavigatables();
            navigatables.addAll(navigatable);
        }
        return navigatables.isEmpty() ? null : navigatables.toArray(new Navigatable[0]);
    }

    private ExecutionNode[] getSelectedNodes() {
        ExecutionNode[] result2 = new ExecutionNode[]{};
        if (this.myTree != null) {
            List<ExecutionNode> nodes = TreeUtil.collectSelectedObjects(this.myTree, path2 -> TreeUtil.getLastUserObject(ExecutionNode.class, path2));
            return nodes.toArray(result2);
        }
        return result2;
    }

    @ApiStatus.Internal
    public JTree getTree() {
        return this.myTree;
    }

    private static Tree initTree(@NotNull AsyncTreeModel model) {
        if (model == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(34);
        }
        Tree tree = new Tree(model);
        tree.setLargeModel(true);
        ComponentUtil.putClientProperty(tree, AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, true);
        tree.setRootVisible(false);
        EditSourceOnDoubleClickHandler.install(tree);
        EditSourceOnEnterKeyHandler.install(tree, null);
        new TreeSpeedSearch(tree).setComparator(new SpeedSearchComparator(false));
        TreeUtil.installActions(tree);
        tree.setCellRenderer(new MyNodeRenderer());
        tree.putClientProperty(RenderingHelper.SHRINK_LONG_RENDERER, true);
        return tree;
    }

    @NotNull
    private ExecutionNode getOrCreateMessagesNode(MessageEvent messageEvent, String nodeId, ExecutionNode parentNode, String nodeName, @Nullable Supplier<? extends Icon> iconProvider, @Nullable Navigatable navigatable, Map<Object, ExecutionNode> nodesMap, Project project2) {
        ExecutionNode node = nodesMap.get(nodeId);
        if (node == null) {
            node = new ExecutionNode(project2, parentNode, true, this::isCorrectThread);
            node.setName(nodeName);
            node.setStartTime(messageEvent.getEventTime());
            node.setEndTime(messageEvent.getEventTime());
            if (iconProvider != null) {
                node.setIconProvider(iconProvider);
            }
            if (navigatable != null) {
                node.setNavigatable(navigatable);
            }
            parentNode.add(node);
            nodesMap.put(nodeId, node);
        }
        ExecutionNode executionNode = node;
        if (executionNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(35);
        }
        return executionNode;
    }

    @ApiStatus.Internal
    public Promise<?> invokeLater(@NotNull Runnable task2) {
        if (task2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(36);
        }
        return this.myTreeModel.getInvoker().invokeLater(task2);
    }

    private static /* synthetic */ boolean lambda$addChildFailureNode$12(String failureNodeName, ExecutionNode executionNode) {
        return failureNodeName.equals(executionNode.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 17: 
            case 29: 
            case 30: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 17: 
            case 29: 
            case 30: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildViewSettingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startBuildEvent";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 17: 
            case 29: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildTreeConsoleView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionTreeFilter";
                break;
            }
            case 4: 
            case 5: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 8: 
            case 10: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageEvent";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionNode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failure";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFailureMessage";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strcutreChanged";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureChanged";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildTreeConsoleView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "visitor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMessagesNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installContextMenu";
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 17: 
            case 29: 
            case 30: 
            case 35: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeFilter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrMaybeCreateParentNode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onEventInternal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reportMessageKind";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showErrorIfFirst";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitor";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addChildFailureNode";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "finishChildren";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "onEvent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "initTree";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 14: 
            case 15: 
            case 17: 
            case 29: 
            case 30: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExecutionNodeAutoExpandingListener
    implements TreeModelListener {
        private ExecutionNodeAutoExpandingListener() {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.maybeExpand(e.getTreePath());
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }

        private boolean maybeExpand(TreePath path2) {
            if (BuildTreeConsoleView.this.myTree == null || path2 == null) {
                return false;
            }
            Object last = path2.getLastPathComponent();
            if (last instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode mutableTreeNode = (DefaultMutableTreeNode)last;
                boolean expanded = false;
                Enumeration<TreeNode> children2 = mutableTreeNode.children();
                if (children2.hasMoreElements()) {
                    while (children2.hasMoreElements()) {
                        TreeNode next = children2.nextElement();
                        if (next == null) continue;
                        expanded = this.maybeExpand(path2.pathByAddingChild(next)) || expanded;
                    }
                    if (expanded) {
                        return true;
                    }
                    Object lastUserObject = mutableTreeNode.getUserObject();
                    if (lastUserObject instanceof ExecutionNode && ((ExecutionNode)lastUserObject).isAutoExpandNode() && !BuildTreeConsoleView.this.myTree.isExpanded(path2)) {
                        BuildTreeConsoleView.this.myTree.expandPath(path2);
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private class MyTreeStructure
    extends AbstractTreeStructure {
        private MyTreeStructure() {
        }

        @Override
        @NotNull
        public Object getRootElement() {
            ExecutionNode executionNode = BuildTreeConsoleView.this.myRootNode;
            if (executionNode == null) {
                MyTreeStructure.$$$reportNull$$$0(0);
            }
            return executionNode;
        }

        @Override
        @NotNull
        public Object[] getChildElements(@NotNull Object element2) {
            if (element2 == null) {
                MyTreeStructure.$$$reportNull$$$0(1);
            }
            Object[] objectArray = ((ExecutionNode)element2).getChildList().toArray();
            if (objectArray == null) {
                MyTreeStructure.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        @Override
        @Nullable
        public Object getParentElement(@NotNull Object element2) {
            if (element2 == null) {
                MyTreeStructure.$$$reportNull$$$0(3);
            }
            return ((ExecutionNode)element2).getParent();
        }

        @Override
        @NotNull
        public NodeDescriptor createDescriptor(@NotNull Object element2, @Nullable NodeDescriptor parentDescriptor) {
            if (element2 == null) {
                MyTreeStructure.$$$reportNull$$$0(4);
            }
            NodeDescriptor nodeDescriptor = (NodeDescriptor)element2;
            if (nodeDescriptor == null) {
                MyTreeStructure.$$$reportNull$$$0(5);
            }
            return nodeDescriptor;
        }

        @Override
        public void commit() {
        }

        @Override
        public boolean hasSomethingToCommit() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/build/BuildTreeConsoleView$MyTreeStructure";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootElement";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$MyTreeStructure";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildElements";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildElements";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getParentElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyNodeRenderer
    extends NodeRenderer {
        private String myDurationText;
        private Color myDurationColor;
        private int myDurationWidth;
        private int myDurationOffset;

        private MyNodeRenderer() {
        }

        @Override
        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyNodeRenderer.$$$reportNull$$$0(0);
            }
            super.customizeCellRenderer(tree, value2, selected2, expanded, leaf, row, hasFocus);
            this.myDurationText = null;
            this.myDurationColor = null;
            this.myDurationWidth = 0;
            this.myDurationOffset = 0;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
            Object userObj = node.getUserObject();
            if (userObj instanceof ExecutionNode) {
                this.myDurationText = ((ExecutionNode)userObj).getDuration();
                if (this.myDurationText != null) {
                    FontMetrics metrics = this.getFontMetrics(RelativeFont.SMALL.derive(this.getFont()));
                    this.myDurationWidth = metrics.stringWidth(this.myDurationText);
                    this.myDurationOffset = metrics.getHeight() / 2;
                    this.myDurationColor = selected2 ? UIUtil.getTreeSelectionForeground(hasFocus) : SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            UISettings.setupAntialiasing(g);
            Shape clip = null;
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, width, height);
            }
            if (this.myDurationWidth > 0 && (width -= this.myDurationWidth + this.myDurationOffset) > 0 && height > 0) {
                g.setColor(this.myDurationColor);
                g.setFont(RelativeFont.SMALL.derive(this.getFont()));
                g.drawString(this.myDurationText, width + this.myDurationOffset / 2, MyNodeRenderer.getTextBaseLine(g.getFontMetrics(), height));
                clip = g.getClip();
                g.clipRect(0, 0, width, height);
            }
            super.paintComponent(g);
            if (clip != null) {
                g.setClip(clip);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", BuildTreeConsoleView.TREE, "com/intellij/build/BuildTreeConsoleView$MyNodeRenderer", "customizeCellRenderer"));
        }
    }

    private static class ScrollEditorToTheEndAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final ConsoleViewHandler myConsoleViewHandler;

        ScrollEditorToTheEndAction(@NotNull ConsoleViewHandler handler2) {
            if (handler2 == null) {
                ScrollEditorToTheEndAction.$$$reportNull$$$0(0);
            }
            super(ActionsBundle.message("action.EditorConsoleScrollToTheEnd.text", new Object[0]), null, AllIcons.RunConfigurations.Scroll_down);
            this.myConsoleViewHandler = handler2;
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent e) {
            Editor editor;
            if (e == null) {
                ScrollEditorToTheEndAction.$$$reportNull$$$0(1);
            }
            if ((editor = this.myConsoleViewHandler.getEditor()) == null) {
                return false;
            }
            Document document = editor.getDocument();
            return document.getLineCount() == 0 || document.getLineNumber(editor.getCaretModel().getOffset()) == document.getLineCount() - 1;
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Editor editor;
            if (e == null) {
                ScrollEditorToTheEndAction.$$$reportNull$$$0(2);
            }
            if ((editor = this.myConsoleViewHandler.getEditor()) == null) {
                return;
            }
            if (state) {
                EditorUtil.scrollToTheEnd(editor);
            } else {
                int lastLine = Math.max(0, editor.getDocument().getLineCount() - 1);
                LogicalPosition currentPosition = editor.getCaretModel().getLogicalPosition();
                LogicalPosition position = new LogicalPosition(Math.max(0, Math.min(currentPosition.line, lastLine - 1)), currentPosition.column);
                editor.getCaretModel().moveToLogicalPosition(position);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$ScrollEditorToTheEndAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProblemOccurrenceNavigatorSupport
    extends OccurenceNavigatorSupport {
        ProblemOccurrenceNavigatorSupport(Tree tree) {
            super(tree);
        }

        @Override
        protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
            Object userObject;
            if (node == null) {
                ProblemOccurrenceNavigatorSupport.$$$reportNull$$$0(0);
            }
            if (!((userObject = node.getUserObject()) instanceof ExecutionNode)) {
                return null;
            }
            ExecutionNode executionNode = (ExecutionNode)userObject;
            if (node.getChildCount() != 0 || !executionNode.hasWarnings() && !executionNode.isFailed()) {
                return null;
            }
            List<Navigatable> navigatables = executionNode.getNavigatables();
            if (!navigatables.isEmpty()) {
                return navigatables.get(0);
            }
            return null;
        }

        @Override
        @NotNull
        public String getNextOccurenceActionName() {
            String string = IdeBundle.message("action.next.problem", new Object[0]);
            if (string == null) {
                ProblemOccurrenceNavigatorSupport.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPreviousOccurenceActionName() {
            String string = IdeBundle.message("action.previous.problem", new Object[0]);
            if (string == null) {
                ProblemOccurrenceNavigatorSupport.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/build/BuildTreeConsoleView$ProblemOccurrenceNavigatorSupport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$ProblemOccurrenceNavigatorSupport";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOccurenceActionName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousOccurenceActionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptorForNode";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ConsoleViewHandler
    implements Disposable {
        private static final String EMPTY_CONSOLE_NAME = "empty";
        private final Project myProject;
        private final JPanel myPanel;
        private final CompositeView<ExecutionConsole> myView;
        private final AtomicReference<String> myNodeConsoleViewName;
        private final Map<String, List<Consumer<BuildTextConsoleView>>> deferredNodeOutput;
        @NotNull
        private final BuildViewSettingsProvider myViewSettingsProvider;
        @Nullable
        private ExecutionNode myExecutionNode;

        ConsoleViewHandler(@NotNull Project project2, @NotNull Tree tree, @NotNull ExecutionNode buildProgressRootNode, @NotNull Disposable parentDisposable, @Nullable ExecutionConsole executionConsole, @NotNull BuildViewSettingsProvider buildViewSettingsProvider) {
            if (project2 == null) {
                ConsoleViewHandler.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                ConsoleViewHandler.$$$reportNull$$$0(1);
            }
            if (buildProgressRootNode == null) {
                ConsoleViewHandler.$$$reportNull$$$0(2);
            }
            if (parentDisposable == null) {
                ConsoleViewHandler.$$$reportNull$$$0(3);
            }
            if (buildViewSettingsProvider == null) {
                ConsoleViewHandler.$$$reportNull$$$0(4);
            }
            this.myNodeConsoleViewName = new AtomicReference();
            this.deferredNodeOutput = ContainerUtil.newConcurrentMap();
            this.myProject = project2;
            this.myPanel = new JPanel(new BorderLayout());
            this.myViewSettingsProvider = buildViewSettingsProvider;
            Disposer.register(parentDisposable, this);
            this.myView = new CompositeView<ExecutionConsole>(null){

                @Override
                public void addView(@NotNull ExecutionConsole view, @NotNull String viewName) {
                    if (view == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (viewName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.addView(view, viewName);
                    UIUtil.removeScrollBorder(view.getComponent());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "view";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "viewName";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler$1";
                    objectArray[2] = "addView";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            Disposer.register(this, this.myView);
            if (executionConsole != null && buildViewSettingsProvider.isSideBySideView()) {
                String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(buildProgressRootNode);
                this.myView.addViewAndShowIfNeeded(executionConsole, nodeConsoleViewName, true);
                this.myNodeConsoleViewName.set(nodeConsoleViewName);
            }
            ConsoleViewImpl emptyConsole = new ConsoleViewImpl(project2, GlobalSearchScope.EMPTY_SCOPE, true, false);
            this.myView.addView(emptyConsole, EMPTY_CONSOLE_NAME);
            if (!buildViewSettingsProvider.isSideBySideView()) {
                this.myPanel.setVisible(false);
            }
            JComponent consoleComponent = emptyConsole.getComponent();
            consoleComponent.setFocusable(true);
            this.myPanel.add((Component)this.myView.getComponent(), "Center");
            DefaultActionGroup consoleActionsGroup = new DefaultActionGroup();
            consoleActionsGroup.add(new ToggleUseSoftWrapsToolbarAction(SoftWrapAppliancePlaces.CONSOLE){

                @Override
                @Nullable
                protected Editor getEditor(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return this.getEditor();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler$2", "getEditor"));
                }
            });
            consoleActionsGroup.add(new ScrollEditorToTheEndAction(this));
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("BuildConsole", consoleActionsGroup, false);
            this.myPanel.add((Component)toolbar.getComponent(), "East");
            tree.addTreeSelectionListener(e -> {
                TreePath path2 = e.getPath();
                if (path2 == null || !e.isAddedPath()) {
                    return;
                }
                TreePath selectionPath = tree.getSelectionPath();
                this.setNode(selectionPath != null ? (DefaultMutableTreeNode)selectionPath.getLastPathComponent() : null);
            });
        }

        @Nullable
        private ExecutionConsole getCurrentConsole() {
            String nodeConsoleViewName = this.myNodeConsoleViewName.get();
            if (nodeConsoleViewName == null) {
                return null;
            }
            return this.myView.getView(nodeConsoleViewName);
        }

        @Nullable
        private Editor getEditor() {
            ExecutionConsole console = this.getCurrentConsole();
            if (console instanceof ConsoleViewImpl) {
                return ((ConsoleViewImpl)console).getEditor();
            }
            return null;
        }

        private boolean setNode(@NotNull ExecutionNode node) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(5);
            }
            String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(node);
            this.myNodeConsoleViewName.set(nodeConsoleViewName);
            ExecutionConsole view = this.myView.getView(nodeConsoleViewName);
            if (view != null) {
                List<Consumer<BuildTextConsoleView>> deferredOutput = this.deferredNodeOutput.get(nodeConsoleViewName);
                if (view instanceof BuildTextConsoleView && deferredOutput != null && !deferredOutput.isEmpty()) {
                    this.deferredNodeOutput.remove(nodeConsoleViewName);
                    deferredOutput.forEach(consumer -> consumer.accept((BuildTextConsoleView)view));
                }
                this.myView.showView(nodeConsoleViewName, false);
                this.myPanel.setVisible(true);
                return true;
            }
            List<Consumer<BuildTextConsoleView>> deferredOutput = this.deferredNodeOutput.get(nodeConsoleViewName);
            if (deferredOutput != null && !deferredOutput.isEmpty()) {
                BuildTextConsoleView textConsoleView = new BuildTextConsoleView(this.myProject, true);
                this.deferredNodeOutput.remove(nodeConsoleViewName);
                deferredOutput.forEach(consumer -> consumer.accept(textConsoleView));
                this.myView.addView(textConsoleView, nodeConsoleViewName);
                this.myView.showView(nodeConsoleViewName, false);
            } else if (this.myViewSettingsProvider.isSideBySideView()) {
                this.myView.showView(EMPTY_CONSOLE_NAME, false);
                return true;
            }
            if (!this.myViewSettingsProvider.isSideBySideView()) {
                BuildTextConsoleView taskOutputView = new BuildTextConsoleView(this.myProject, true);
                EventResult eventResult = node.getResult();
                boolean hasChanged = taskOutputView.appendEventResult(eventResult);
                if (!hasChanged) {
                    return false;
                }
                taskOutputView.scrollTo(0);
                this.myView.addView(taskOutputView, nodeConsoleViewName);
                this.myView.showView(nodeConsoleViewName, false);
                this.myPanel.setVisible(true);
            }
            return true;
        }

        private void addOutput(@NotNull ExecutionNode node, @NotNull String text2, boolean stdOut) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(6);
            }
            if (text2 == null) {
                ConsoleViewHandler.$$$reportNull$$$0(7);
            }
            this.addOutput(node, (BuildTextConsoleView view) -> view.append(text2, stdOut));
        }

        private void addOutput(@NotNull ExecutionNode node, @NotNull Object buildId, BuildEvent event) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(8);
            }
            if (buildId == null) {
                ConsoleViewHandler.$$$reportNull$$$0(9);
            }
            this.addOutput(node, (BuildTextConsoleView view) -> view.onEvent(buildId, event));
        }

        private void addOutput(@NotNull ExecutionNode node, Failure failure) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(10);
            }
            this.addOutput(node, (BuildTextConsoleView view) -> view.append(failure));
        }

        private void addOutput(@NotNull ExecutionNode node, Consumer<BuildTextConsoleView> consumer) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(11);
            }
            if (!this.myViewSettingsProvider.isSideBySideView()) {
                return;
            }
            String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(node);
            ExecutionConsole viewView = this.myView.getView(nodeConsoleViewName);
            if (viewView instanceof BuildTextConsoleView) {
                consumer.accept((BuildTextConsoleView)viewView);
            }
            if (viewView == null) {
                this.deferredNodeOutput.computeIfAbsent(nodeConsoleViewName, s -> new ArrayList()).add(consumer);
            }
        }

        @Override
        public void dispose() {
            this.deferredNodeOutput.clear();
        }

        @NotNull
        private static String getNodeConsoleViewName(@NotNull ExecutionNode node) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(12);
            }
            String string = String.valueOf(System.identityHashCode(node));
            if (string == null) {
                ConsoleViewHandler.$$$reportNull$$$0(13);
            }
            return string;
        }

        private void setNode(@Nullable DefaultMutableTreeNode node) {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (node == null || node.getUserObject() == this.myExecutionNode) {
                return;
            }
            if (node.getUserObject() instanceof ExecutionNode) {
                this.myExecutionNode = (ExecutionNode)node.getUserObject();
                if (this.setNode((ExecutionNode)node.getUserObject())) {
                    return;
                }
            }
            this.myExecutionNode = null;
            if (this.myView.getView("consoleView") != null) {
                this.myView.showView("consoleView", false);
                this.myPanel.setVisible(true);
            } else {
                this.myPanel.setVisible(false);
            }
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public void clear() {
            this.myPanel.setVisible(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = BuildTreeConsoleView.TREE;
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildProgressRootNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildViewSettingsProvider";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildId";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeConsoleViewName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setNode";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addOutput";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getNodeConsoleViewName";
                    break;
                }
                case 13: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

