/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.build.CompositeView;
import com.intellij.build.ExecutionNode;
import com.intellij.build.Filterable;
import com.intellij.build.ViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.actions.PinActiveTabAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildView
extends CompositeView<ExecutionConsole>
implements BuildProgressListener,
ConsoleView,
DataProvider,
Filterable<ExecutionNode>,
OccurenceNavigator {
    public static final String CONSOLE_VIEW_NAME = "consoleView";
    @ApiStatus.Experimental
    public static final DataKey<AnAction[]> RESTART_ACTIONS = DataKey.create("restart actions");
    private final AtomicReference<StartBuildEvent> myStartBuildEventRef = new AtomicReference();
    private final BuildDescriptor myBuildDescriptor;
    private final Project myProject;
    private final AtomicBoolean isBuildStartEventProcessed = new AtomicBoolean();
    private final List<BuildEvent> myAfterStartEvents = ContainerUtil.createConcurrentList();
    private final ViewManager myViewManager;
    @Nullable
    private volatile ExecutionConsole myExecutionConsole;
    private volatile BuildViewSettingsProvider myViewSettingsProvider;

    public BuildView(Project project2, BuildDescriptor buildDescriptor, String selectionStateKey, ViewManager viewManager) {
        this(project2, null, buildDescriptor, selectionStateKey, viewManager);
    }

    public BuildView(Project project2, @Nullable ExecutionConsole executionConsole, BuildDescriptor buildDescriptor, String selectionStateKey, ViewManager viewManager) {
        super(selectionStateKey);
        this.myProject = project2;
        this.myBuildDescriptor = buildDescriptor;
        this.myViewManager = viewManager;
        this.myExecutionConsole = executionConsole;
        Disposer.register(project2, this);
    }

    @Override
    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (buildId == null) {
            BuildView.$$$reportNull$$$0(0);
        }
        if (event == null) {
            BuildView.$$$reportNull$$$0(1);
        }
        if (event instanceof StartBuildEvent) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                this.onStartBuild(buildId, (StartBuildEvent)event);
                for (BuildEvent buildEvent : this.myAfterStartEvents) {
                    this.processEvent(buildId, buildEvent);
                }
                this.myAfterStartEvents.clear();
                this.isBuildStartEventProcessed.set(true);
            });
            return;
        }
        if (!this.isBuildStartEventProcessed.get()) {
            this.myAfterStartEvents.add(event);
        } else {
            this.processEvent(buildId, event);
        }
    }

    private void processEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (buildId == null) {
            BuildView.$$$reportNull$$$0(2);
        }
        if (event == null) {
            BuildView.$$$reportNull$$$0(3);
        }
        if (event instanceof OutputBuildEvent && (event.getParentId() == null || event.getParentId() == this.myBuildDescriptor.getId())) {
            ExecutionConsole consoleView = this.getConsoleView();
            if (consoleView instanceof BuildProgressListener) {
                ((BuildProgressListener)((Object)consoleView)).onEvent(buildId, event);
            }
        } else {
            BuildTreeConsoleView eventView = this.getEventView();
            if (eventView != null) {
                EdtExecutorService.getInstance().execute(() -> eventView.onEvent(buildId, event));
            }
        }
    }

    private void onStartBuild(@NotNull Object buildId, @NotNull StartBuildEvent startBuildEvent) {
        if (buildId == null) {
            BuildView.$$$reportNull$$$0(4);
        }
        if (startBuildEvent == null) {
            BuildView.$$$reportNull$$$0(5);
        }
        this.myStartBuildEventRef.set(startBuildEvent);
        if (startBuildEvent instanceof StartBuildEventImpl) {
            this.myViewSettingsProvider = ((StartBuildEventImpl)startBuildEvent).getBuildViewSettingsProvider();
        }
        if (this.myViewSettingsProvider == null) {
            this.myViewSettingsProvider = () -> false;
        }
        if (this.myExecutionConsole == null) {
            Supplier<RunContentDescriptor> descriptorSupplier = startBuildEvent.getContentDescriptorSupplier();
            RunContentDescriptor runContentDescriptor = descriptorSupplier != null ? descriptorSupplier.get() : null;
            ExecutionConsole executionConsole = this.myExecutionConsole = runContentDescriptor != null && runContentDescriptor.getExecutionConsole() != null && runContentDescriptor.getExecutionConsole() != this ? runContentDescriptor.getExecutionConsole() : new BuildTextConsoleView(this.myProject);
            if (runContentDescriptor != null && Disposer.findRegisteredObject(runContentDescriptor, this) == null) {
                Disposer.register(this, runContentDescriptor);
            }
        }
        if (this.myExecutionConsole != null) {
            this.myExecutionConsole.getComponent();
            if (this.myViewSettingsProvider.isExecutionViewHidden() || !this.myViewSettingsProvider.isSideBySideView()) {
                this.addViewAndShowIfNeeded(this.myExecutionConsole, CONSOLE_VIEW_NAME, this.myViewManager.isConsoleEnabledByDefault());
            }
        }
        BuildTreeConsoleView eventView = null;
        if (!this.myViewSettingsProvider.isExecutionViewHidden() && (eventView = this.getEventView()) == null) {
            String eventViewName = BuildTreeConsoleView.class.getName();
            eventView = new BuildTreeConsoleView(this.myProject, this.myBuildDescriptor, this.myExecutionConsole, this.myViewSettingsProvider);
            if (this.myViewSettingsProvider.isSideBySideView()) {
                this.addView(eventView, eventViewName);
                this.showView(eventViewName);
            } else {
                this.addViewAndShowIfNeeded(eventView, eventViewName, !this.myViewManager.isConsoleEnabledByDefault());
            }
        }
        BuildProcessHandler processHandler2 = startBuildEvent.getProcessHandler();
        if (this.myExecutionConsole instanceof ConsoleView) {
            for (Filter filter2 : startBuildEvent.getExecutionFilters()) {
                ((ConsoleView)this.myExecutionConsole).addMessageFilter(filter2);
            }
            if (processHandler2 != null) {
                ((ConsoleView)this.myExecutionConsole).attachToProcess(processHandler2);
                Consumer<ConsoleView> attachedConsoleConsumer = startBuildEvent.getAttachedConsoleConsumer();
                if (attachedConsoleConsumer != null) {
                    attachedConsoleConsumer.consume((ConsoleView)this.myExecutionConsole);
                }
                if (!processHandler2.isStartNotified()) {
                    processHandler2.startNotify();
                }
            }
        }
        if (processHandler2 != null && !processHandler2.isStartNotified()) {
            processHandler2.startNotify();
        }
        if (eventView != null) {
            eventView.onEvent(buildId, startBuildEvent);
        }
    }

    @Nullable
    @ApiStatus.Internal
    ExecutionConsole getConsoleView() {
        return this.myExecutionConsole;
    }

    @Nullable
    @ApiStatus.Internal
    BuildTreeConsoleView getEventView() {
        return this.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
    }

    @Override
    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            BuildView.$$$reportNull$$$0(6);
        }
        if (contentType == null) {
            BuildView.$$$reportNull$$$0(7);
        }
        this.delegateToConsoleView(view -> view.print(text2, contentType));
    }

    private void delegateToConsoleView(Consumer<? super ConsoleView> viewConsumer) {
        ExecutionConsole console = this.getConsoleView();
        if (console instanceof ConsoleView) {
            viewConsumer.consume((ConsoleView)console);
        }
    }

    @Nullable
    private <R> R getConsoleViewValue(Function<? super ConsoleView, ? extends R> viewConsumer) {
        ExecutionConsole console = this.getConsoleView();
        if (console instanceof ConsoleView) {
            return viewConsumer.apply((ConsoleView)console);
        }
        return null;
    }

    @Override
    public void clear() {
        this.delegateToConsoleView(ConsoleView::clear);
    }

    @Override
    public void scrollTo(int offset) {
        this.delegateToConsoleView(view -> view.scrollTo(offset));
    }

    @Override
    public void attachToProcess(ProcessHandler processHandler2) {
        this.delegateToConsoleView(view -> view.attachToProcess(processHandler2));
    }

    @Override
    public void setOutputPaused(boolean value2) {
        this.delegateToConsoleView(view -> view.setOutputPaused(value2));
    }

    @Override
    public boolean isOutputPaused() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::isOutputPaused);
        return result2 != null && result2 != false;
    }

    @Override
    public boolean hasDeferredOutput() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::hasDeferredOutput);
        return result2 != null && result2 != false;
    }

    @Override
    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            BuildView.$$$reportNull$$$0(8);
        }
        this.delegateToConsoleView(view -> view.performWhenNoDeferredOutput(runnable2));
    }

    @Override
    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            BuildView.$$$reportNull$$$0(9);
        }
        this.delegateToConsoleView(view -> view.setHelpId(helpId));
    }

    @Override
    public void addMessageFilter(@NotNull Filter filter2) {
        if (filter2 == null) {
            BuildView.$$$reportNull$$$0(10);
        }
        this.delegateToConsoleView(view -> view.addMessageFilter(filter2));
    }

    @Override
    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            BuildView.$$$reportNull$$$0(11);
        }
        this.delegateToConsoleView(view -> view.printHyperlink(hyperlinkText, info));
    }

    @Override
    public int getContentSize() {
        Integer result2 = this.getConsoleViewValue(ConsoleView::getContentSize);
        return result2 == null ? 0 : result2;
    }

    @Override
    public boolean canPause() {
        Boolean result2 = this.getConsoleViewValue(ConsoleView::canPause);
        return result2 != null && result2 != false;
    }

    @Override
    public AnAction @NotNull [] createConsoleActions() {
        DefaultActionGroup rerunActionGroup = new DefaultActionGroup();
        AnAction stopAction = null;
        StartBuildEvent startBuildEvent = this.myStartBuildEventRef.get();
        if (startBuildEvent != null && startBuildEvent.getProcessHandler() != null) {
            stopAction = new StopProcessAction(IdeBundle.messagePointer("action.DumbAware.BuildView.text.stop", new Object[0]), IdeBundle.messagePointer("action.DumbAware.CopyrightProfilesPanel.description.stop", new Object[0]), (ProcessHandler)startBuildEvent.getProcessHandler());
            ActionUtil.copyFrom(stopAction, "Stop");
            stopAction.registerCustomShortcutSet(stopAction.getShortcutSet(), this);
        }
        DefaultActionGroup consoleActionGroup = new DefaultActionGroup(){

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.update(e);
                String eventViewName = BuildTreeConsoleView.class.getName();
                e.getPresentation().setVisible(BuildView.this.myViewSettingsProvider != null && !BuildView.this.myViewSettingsProvider.isSideBySideView() && !BuildView.this.isViewVisible(eventViewName));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/build/BuildView$1", "update"));
            }
        };
        ExecutionConsole consoleView = this.getConsoleView();
        if (consoleView instanceof ConsoleView) {
            AnAction[] consoleActions;
            consoleView.getComponent();
            for (AnAction anAction : consoleActions = ((ConsoleView)consoleView).createConsoleActions()) {
                if (anAction instanceof StopAction) {
                    if (stopAction != null) continue;
                    stopAction = anAction;
                    continue;
                }
                if (anAction instanceof FakeRerunAction || anAction instanceof PinActiveTabAction || anAction instanceof CloseAction) continue;
                consoleActionGroup.add(anAction);
            }
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        if (startBuildEvent != null) {
            for (AnAction anAction : startBuildEvent.getRestartActions()) {
                rerunActionGroup.add(anAction);
            }
        }
        if (stopAction != null) {
            rerunActionGroup.add(stopAction);
        }
        actionGroup.add(rerunActionGroup);
        if (this.myViewManager.isBuildContentView() && (this.myViewSettingsProvider == null || !this.myViewSettingsProvider.isSideBySideView())) {
            actionGroup.addAll(this.getSwitchActions());
            actionGroup.addSeparator();
        }
        AnAction[] anActionArray = new AnAction[]{actionGroup, consoleActionGroup};
        if (anActionArray == null) {
            BuildView.$$$reportNull$$$0(12);
        }
        return anActionArray;
    }

    @Override
    public void allowHeavyFilters() {
        this.delegateToConsoleView(ConsoleView::allowHeavyFilters);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            BuildView.$$$reportNull$$$0(13);
        }
        if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
            return this.getConsoleView();
        }
        Object data2 = super.getData(dataId);
        if (data2 != null) {
            return data2;
        }
        StartBuildEvent startBuildEvent = this.myStartBuildEventRef.get();
        if (startBuildEvent != null) {
            if (LangDataKeys.RUN_PROFILE.is(dataId)) {
                ExecutionEnvironment environment2 = startBuildEvent.getExecutionEnvironment();
                return environment2 == null ? null : environment2.getRunProfile();
            }
            if (LangDataKeys.EXECUTION_ENVIRONMENT.is(dataId)) {
                return startBuildEvent.getExecutionEnvironment();
            }
            if (RESTART_ACTIONS.is(dataId)) {
                return startBuildEvent.getRestartActions();
            }
        }
        return null;
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.getEventView() != null;
    }

    @Override
    @NotNull
    public Predicate<ExecutionNode> getFilter() {
        BuildTreeConsoleView eventView = this.getEventView();
        Predicate<ExecutionNode> predicate = eventView == null ? executionNode -> true : eventView.getFilter();
        if (predicate == null) {
            BuildView.$$$reportNull$$$0(14);
        }
        return predicate;
    }

    @Override
    public void addFilter(@NotNull Predicate<ExecutionNode> filter2) {
        BuildTreeConsoleView eventView;
        if (filter2 == null) {
            BuildView.$$$reportNull$$$0(15);
        }
        if ((eventView = this.getEventView()) != null) {
            eventView.addFilter(filter2);
        }
    }

    @Override
    public void removeFilter(@NotNull Predicate<ExecutionNode> filter2) {
        BuildTreeConsoleView eventView;
        if (filter2 == null) {
            BuildView.$$$reportNull$$$0(16);
        }
        if ((eventView = this.getEventView()) != null) {
            eventView.removeFilter(filter2);
        }
    }

    @Override
    public boolean contains(@NotNull Predicate<ExecutionNode> filter2) {
        BuildTreeConsoleView eventView;
        if (filter2 == null) {
            BuildView.$$$reportNull$$$0(17);
        }
        return (eventView = this.getEventView()) != null && eventView.contains(filter2);
    }

    @NotNull
    private OccurenceNavigator getOccurenceNavigator() {
        BuildTreeConsoleView eventView = this.getEventView();
        if (eventView != null) {
            BuildTreeConsoleView buildTreeConsoleView = eventView;
            if (buildTreeConsoleView == null) {
                BuildView.$$$reportNull$$$0(18);
            }
            return buildTreeConsoleView;
        }
        ExecutionConsole executionConsole = this.getConsoleView();
        if (executionConsole instanceof OccurenceNavigator) {
            OccurenceNavigator occurenceNavigator = (OccurenceNavigator)((Object)executionConsole);
            if (occurenceNavigator == null) {
                BuildView.$$$reportNull$$$0(19);
            }
            return occurenceNavigator;
        }
        OccurenceNavigator occurenceNavigator = EMPTY;
        if (occurenceNavigator == null) {
            BuildView.$$$reportNull$$$0(20);
        }
        return occurenceNavigator;
    }

    @Override
    public boolean hasNextOccurence() {
        return this.getOccurenceNavigator().hasNextOccurence();
    }

    @Override
    public boolean hasPreviousOccurence() {
        return this.getOccurenceNavigator().hasPreviousOccurence();
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.getOccurenceNavigator().goNextOccurence();
    }

    @Override
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.getOccurenceNavigator().goPreviousOccurence();
    }

    @Override
    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.getOccurenceNavigator().getNextOccurenceActionName();
        if (string == null) {
            BuildView.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.getOccurenceNavigator().getPreviousOccurenceActionName();
        if (string == null) {
            BuildView.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startBuildEvent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildView";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildView";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurenceNavigator";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onEvent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processEvent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onStartBuild";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeFilter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

