/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.FilePosition;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.Nullable;

public class FileNavigatable
implements Navigatable {
    private final Project myProject;
    private final NullableLazyValue<Navigatable> myValue;
    private final FilePosition myFilePosition;

    public FileNavigatable(Project project2, FilePosition filePosition) {
        this.myProject = project2;
        this.myFilePosition = filePosition;
        this.myValue = new NullableLazyValue<Navigatable>(){

            @Override
            @Nullable
            protected Navigatable compute() {
                return FileNavigatable.this.getDescriptor();
            }
        };
    }

    @Override
    public void navigate(boolean requestFocus) {
        Navigatable descriptor2 = this.myValue.getValue();
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        Navigatable descriptor2 = this.myValue.getValue();
        if (descriptor2 != null) {
            return descriptor2.canNavigate();
        }
        return false;
    }

    @Override
    public boolean canNavigateToSource() {
        Navigatable descriptor2 = this.myValue.getValue();
        if (descriptor2 != null) {
            return descriptor2.canNavigateToSource();
        }
        return false;
    }

    @Nullable
    private Navigatable getDescriptor() {
        OpenFileDescriptor descriptor2 = null;
        VirtualFile file2 = VfsUtil.findFileByIoFile(this.myFilePosition.getFile(), false);
        if (file2 != null) {
            descriptor2 = new OpenFileDescriptor(this.myProject, file2, this.myFilePosition.getStartLine(), this.myFilePosition.getStartColumn());
        }
        return descriptor2;
    }
}

