/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.buildfiles;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.io.IOUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForcedBuildFileAttribute {
    private static final Logger LOG = Logger.getInstance(ForcedBuildFileAttribute.class);
    private static final FileAttribute FRAMEWORK_FILE_ATTRIBUTE = new FileAttribute("forcedBuildFileFrameworkAttribute", 2, false);
    private static final Key<String> FRAMEWORK_FILE_MARKER = Key.create("forcedBuildFileFrameworkAttribute");

    private ForcedBuildFileAttribute() {
    }

    public static boolean belongsToFramework(VirtualFile file2, @NotNull String frameworkId) {
        if (frameworkId == null) {
            ForcedBuildFileAttribute.$$$reportNull$$$0(0);
        }
        return frameworkId.equals(ForcedBuildFileAttribute.getFrameworkIdOfBuildFile(file2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getFrameworkIdOfBuildFile(VirtualFile file2) {
        if (!(file2 instanceof NewVirtualFile)) return file2.getUserData(FRAMEWORK_FILE_MARKER);
        try (DataInputStream is = FRAMEWORK_FILE_ATTRIBUTE.readAttribute(file2);){
            if (is == null) return "";
            if (is.available() == 0) {
                String string = null;
                return string;
            }
            String string = IOUtil.readString(is);
            return string;
        }
        catch (IOException e) {
            LOG.error(file2.getPath(), e);
        }
        return "";
    }

    public static void forceFileToFramework(VirtualFile file2, String frameworkId, boolean value2) {
        String existingFrameworkId = ForcedBuildFileAttribute.getFrameworkIdOfBuildFile(file2);
        if (!StringUtil.isEmpty(existingFrameworkId) && !frameworkId.equals(existingFrameworkId)) {
            return;
        }
        if (value2) {
            ForcedBuildFileAttribute.forceBuildFile(file2, frameworkId);
        } else {
            ForcedBuildFileAttribute.forceBuildFile(file2, null);
        }
    }

    private static void forceBuildFile(VirtualFile file2, @Nullable String value2) {
        if (file2 instanceof NewVirtualFile) {
            try (DataOutputStream os = FRAMEWORK_FILE_ATTRIBUTE.writeAttribute(file2);){
                IOUtil.writeString(StringUtil.notNullize(value2), os);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        } else {
            file2.putUserData(FRAMEWORK_FILE_MARKER, value2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkId", "com/intellij/buildfiles/ForcedBuildFileAttribute", "belongsToFramework"));
    }
}

