/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLDialog;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeEditor.printing.HTMLTextPainter;
import com.intellij.codeEditor.printing.PrintOption;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExportToHTMLManager {
    private static final Logger LOG = Logger.getInstance(ExportToHTMLManager.class);
    private FileNotFoundException myLastException;

    ExportToHTMLManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void executeExport(@NotNull DataContext dataContext) throws FileNotFoundException {
        block22: {
            block21: {
                if (dataContext == null) {
                    ExportToHTMLManager.$$$reportNull$$$0(0);
                }
                psiFile = CommonDataKeys.PSI_FILE.getData(dataContext);
                psiDirectory = null;
                if (psiFile != null) {
                    psiDirectory = psiFile.getContainingDirectory();
                } else {
                    psiElement = CommonDataKeys.PSI_ELEMENT.getData(dataContext);
                    if (psiElement instanceof PsiDirectory) {
                        psiDirectory = (PsiDirectory)psiElement;
                    }
                }
                editor = CommonDataKeys.EDITOR.getData(dataContext);
                v0 = psiDirectory != null ? psiDirectory.getProject() : (project = editor != null ? editor.getProject() : CommonDataKeys.PROJECT.getData(dataContext));
                if (project == null) {
                    return;
                }
                shortFileName = null;
                directoryName = null;
                if (psiFile != null || psiDirectory != null) {
                    if (psiFile != null) {
                        shortFileName = psiFile.getVirtualFile().getName();
                        if (psiDirectory == null) {
                            psiDirectory = psiFile.getContainingDirectory();
                        }
                    }
                    if (psiDirectory != null) {
                        directoryName = psiDirectory.getVirtualFile().getPresentableUrl();
                    }
                }
                isSelectedTextEnabled = editor != null && editor.getSelectionModel().hasSelection() != false;
                exportToHTMLDialog = new ExportToHTMLDialog(shortFileName, directoryName, isSelectedTextEnabled, project);
                exportToHTMLSettings = ExportToHTMLSettings.getInstance(project);
                if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
                    baseDir = Objects.requireNonNull(project).getBasePath();
                    exportToHTMLSettings.OUTPUT_DIRECTORY = baseDir != null ? baseDir + File.separator + "exportToHTML" : "";
                }
                exportToHTMLDialog.reset();
                if (!exportToHTMLDialog.showAndGet()) {
                    return;
                }
                try {
                    exportToHTMLDialog.apply();
                }
                catch (ConfigurationException e) {
                    Messages.showErrorDialog(project, e.getMessage(), CommonBundle.getErrorTitle());
                }
                PsiDocumentManager.getInstance(project).commitAllDocuments();
                outputDirectoryName = exportToHTMLSettings.OUTPUT_DIRECTORY;
                try {
                    if (exportToHTMLSettings.getPrintScope() == 4) ** GOTO lbl64
                    if (psiFile != null && psiFile.getText() != null) break block21;
                }
                catch (Throwable var15_19) {
                    VfsUtil.markDirtyAndRefresh(true, true, false, new File[]{new File(outputDirectoryName)});
                    throw var15_19;
                }
                VfsUtil.markDirtyAndRefresh(true, true, false, new File[]{new File(outputDirectoryName)});
                return;
            }
            dirName = ExportToHTMLManager.constructOutputDirectory(psiFile, outputDirectoryName);
            textPainter = new HTMLTextPainter(psiFile, project, exportToHTMLSettings.PRINT_LINE_NUMBERS);
            if (exportToHTMLSettings.getPrintScope() == 2 && editor != null && editor.getSelectionModel().hasSelection()) {
                firstLine = editor.getDocument().getLineNumber(editor.getSelectionModel().getSelectionStart());
                textPainter.setSegment(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), firstLine);
            }
            try {
                htmlFile = ExportToHTMLManager.doPaint(dirName, textPainter, null);
                if (exportToHTMLSettings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse(htmlFile);
                }
                break block22;
            }
            catch (IOException e) {
                ExportToHTMLManager.LOG.error(e);
            }
            break block22;
lbl64:
            // 1 sources

            this.myLastException = null;
            exportRunnable = new ExportRunnable(exportToHTMLSettings, psiDirectory, outputDirectoryName, project);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(exportRunnable, EditorBundle.message("export.to.html.title", new Object[0]), true, project);
            if (this.myLastException != null) {
                throw this.myLastException;
            }
        }
        VfsUtil.markDirtyAndRefresh(true, true, false, new File[]{new File(outputDirectoryName)});
    }

    @NotNull
    protected static String doPaint(@NotNull String dirName, @NotNull HTMLTextPainter textPainter, @Nullable TreeMap<Integer, PsiReference> refMap) throws IOException {
        if (dirName == null) {
            ExportToHTMLManager.$$$reportNull$$$0(1);
        }
        if (textPainter == null) {
            ExportToHTMLManager.$$$reportNull$$$0(2);
        }
        String htmlFile = dirName + File.separator + ExportToHTMLManager.getHTMLFileName(textPainter.getPsiFile());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(htmlFile), StandardCharsets.UTF_8);){
            textPainter.paint(refMap, writer, true);
        }
        String string = htmlFile;
        if (string == null) {
            ExportToHTMLManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    private boolean exportPsiFile(PsiFile psiFile, String outputDirectoryName, Project project2, HashMap<PsiFile, PsiFile> filesMap) {
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(project2);
        if (psiFile instanceof PsiBinaryFile) {
            return true;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!psiFile.isValid()) {
                return;
            }
            TreeMap<Integer, PsiReference> refMap = null;
            for (PrintOption printOption : PrintOption.EP_NAME.getExtensionList()) {
                TreeMap<Integer, PsiReference> map2 = printOption.collectReferences(psiFile, filesMap);
                if (map2 == null) continue;
                refMap = new TreeMap<Integer, PsiReference>((SortedMap<Integer, PsiReference>)map2);
            }
            String dirName = ExportToHTMLManager.constructOutputDirectory(psiFile, outputDirectoryName);
            try {
                ExportToHTMLManager.doPaint(dirName, new HTMLTextPainter(psiFile, project2, exportToHTMLSettings.PRINT_LINE_NUMBERS), refMap);
            }
            catch (FileNotFoundException e) {
                this.myLastException = e;
            }
            catch (IOException e) {
                LOG.error(e);
            }
        });
        return this.myLastException == null;
    }

    private static String constructOutputDirectory(PsiFile psiFile, String outputDirectoryName) {
        return ExportToHTMLManager.constructOutputDirectory(psiFile.getContainingDirectory(), outputDirectoryName);
    }

    private static String constructOutputDirectory(@NotNull PsiDirectory directory, String outputDirectoryName) {
        if (directory == null) {
            ExportToHTMLManager.$$$reportNull$$$0(4);
        }
        String qualifiedName = PsiDirectoryFactory.getInstance(directory.getProject()).getQualifiedName(directory, false);
        String dirName = outputDirectoryName;
        if (qualifiedName.length() > 0) {
            dirName = dirName + File.separator + qualifiedName.replace('.', File.separatorChar);
        }
        File dir = new File(dirName);
        dir.mkdirs();
        return dirName;
    }

    private static void addToPsiFileList(PsiDirectory psiDirectory, List<? super PsiFile> filesList, boolean isRecursive, String outputDirectoryName) throws FileNotFoundException {
        if (!psiDirectory.isValid()) {
            return;
        }
        PsiFile[] files2 = psiDirectory.getFiles();
        Collections.addAll(filesList, files2);
        ExportToHTMLManager.generateIndexHtml(psiDirectory, isRecursive, outputDirectoryName);
        if (isRecursive) {
            PsiDirectory[] directories;
            for (PsiDirectory directory : directories = psiDirectory.getSubdirectories()) {
                ExportToHTMLManager.addToPsiFileList(directory, filesList, true, outputDirectoryName);
            }
        }
    }

    private static void generateIndexHtml(PsiDirectory psiDirectory, boolean recursive, String outputDirectoryName) throws FileNotFoundException {
        String indexHtmlName = ExportToHTMLManager.constructOutputDirectory(psiDirectory, outputDirectoryName) + File.separator + "index.html";
        String title = PsiDirectoryFactory.getInstance(psiDirectory.getProject()).getQualifiedName(psiDirectory, true);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(indexHtmlName), StandardCharsets.UTF_8);){
            writer.write("<html><head><title>" + title + "</title></head><body>");
            if (recursive) {
                PsiDirectory[] directories = psiDirectory.getSubdirectories();
                for (PsiFileSystemItem psiFileSystemItem : directories) {
                    writer.write("<a href=\"" + psiFileSystemItem.getName() + "/index.html\"><b>" + psiFileSystemItem.getName() + "</b></a><br />");
                }
            }
            PsiFile[] files2 = psiDirectory.getFiles();
            for (PsiFileSystemItem psiFileSystemItem : files2) {
                if (psiFileSystemItem instanceof PsiBinaryFile) continue;
                writer.write("<a href=\"" + ExportToHTMLManager.getHTMLFileName((PsiFile)psiFileSystemItem) + "\">" + psiFileSystemItem.getVirtualFile().getName() + "</a><br />");
            }
            writer.write("</body></html>");
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    static String getHTMLFileName(PsiFile psiFile) {
        return psiFile.getVirtualFile().getName() + ".html";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textPainter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeEditor/printing/ExportToHTMLManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeEditor/printing/ExportToHTMLManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doPaint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeExport";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doPaint";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "constructOutputDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExportRunnable
    implements Runnable {
        private final ExportToHTMLSettings myExportToHTMLSettings;
        private final PsiDirectory myPsiDirectory;
        private final String myOutputDirectoryName;
        private final Project myProject;

        ExportRunnable(ExportToHTMLSettings exportToHTMLSettings, PsiDirectory psiDirectory, String outputDirectoryName, Project project2) {
            this.myExportToHTMLSettings = exportToHTMLSettings;
            this.myPsiDirectory = psiDirectory;
            this.myOutputDirectoryName = outputDirectoryName;
            this.myProject = project2;
        }

        @Override
        public void run() {
            ProgressIndicator progressIndicator2 = ProgressManager.getInstance().getProgressIndicator();
            ArrayList filesList = new ArrayList();
            boolean isRecursive = this.myExportToHTMLSettings.isIncludeSubdirectories();
            ApplicationManager.getApplication().runReadAction(() -> {
                try {
                    ExportToHTMLManager.addToPsiFileList(this.myPsiDirectory, filesList, isRecursive, this.myOutputDirectoryName);
                }
                catch (FileNotFoundException e) {
                    ExportToHTMLManager.this.myLastException = e;
                }
            });
            if (ExportToHTMLManager.this.myLastException != null) {
                return;
            }
            HashMap<PsiFile, PsiFile> filesMap = new HashMap<PsiFile, PsiFile>();
            for (PsiFile psiFile : filesList) {
                filesMap.put(psiFile, psiFile);
            }
            for (int i = 0; i < filesList.size(); ++i) {
                PsiFile psiFile;
                psiFile = (PsiFile)filesList.get(i);
                if (progressIndicator2.isCanceled()) {
                    return;
                }
                progressIndicator2.setText(EditorBundle.message("export.to.html.generating.file.progress", ExportToHTMLManager.getHTMLFileName(psiFile)));
                progressIndicator2.setFraction((double)i / (double)filesList.size());
                if (ExportToHTMLManager.this.exportPsiFile(psiFile, this.myOutputDirectoryName, this.myProject, filesMap)) continue;
                return;
            }
            if (this.myExportToHTMLSettings.OPEN_IN_BROWSER) {
                String dirToShow = this.myExportToHTMLSettings.OUTPUT_DIRECTORY;
                if (!dirToShow.endsWith(File.separator)) {
                    dirToShow = dirToShow + File.separatorChar;
                }
                dirToShow = dirToShow + PsiDirectoryFactory.getInstance(this.myProject).getQualifiedName(this.myPsiDirectory, false).replace('.', File.separatorChar);
                BrowserUtil.browse(dirToShow);
            }
        }
    }
}

