/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.PsiUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtil {
    private ClassUtil() {
    }

    @Nullable
    public static PsiMethod getAnyAbstractMethod(@NotNull PsiClass aClass) {
        PsiMethod[] methods;
        PsiMethod methodToImplement;
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(0);
        }
        if ((methodToImplement = ClassUtil.getAnyMethodToImplement(aClass)) != null) {
            return methodToImplement;
        }
        for (PsiMethod method2 : methods = aClass.getMethods()) {
            if (!method2.hasModifierProperty("abstract")) continue;
            return method2;
        }
        return null;
    }

    @Nullable
    public static PsiMethod getAnyMethodToImplement(@NotNull PsiClass aClass) {
        PsiClass superClass;
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(1);
        }
        PsiClass psiClass = superClass = aClass instanceof PsiAnonymousClass ? PsiUtil.resolveClassInClassTypeOnly(((PsiAnonymousClass)aClass).getBaseClassType()) : aClass.getSuperClass();
        if (superClass != null && !superClass.hasModifierProperty("abstract") && !superClass.isEnum() && aClass.getImplementsListTypes().length == 0) {
            return null;
        }
        THashSet alreadyImplemented = new THashSet();
        for (HierarchicalMethodSignature signatureHierarchical : aClass.getVisibleSignatures()) {
            for (PsiMethod superS : signatureHierarchical.getMethod().findSuperMethods()) {
                ClassUtil.add(superS, alreadyImplemented);
            }
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(aClass.getProject()).getResolveHelper();
        for (HierarchicalMethodSignature signatureHierarchical : aClass.getVisibleSignatures()) {
            PsiMethod method2 = signatureHierarchical.getMethod();
            PsiClass containingClass = method2.getContainingClass();
            if (containingClass == null || "java.lang.Record".equals(containingClass.getQualifiedName())) continue;
            if (!(aClass.equals(containingClass) || !method2.hasModifierProperty("abstract") || method2.hasModifierProperty("static") || method2.hasModifierProperty("private") || alreadyImplemented.contains(method2))) {
                return method2;
            }
            ArrayList<HierarchicalMethodSignature> superSignatures = new ArrayList<HierarchicalMethodSignature>(signatureHierarchical.getInaccessibleSuperSignatures());
            superSignatures.addAll(signatureHierarchical.getSuperSignatures());
            for (HierarchicalMethodSignature superSignatureHierarchical : superSignatures) {
                PsiMethod superMethod = superSignatureHierarchical.getMethod();
                if (!superMethod.hasModifierProperty("abstract") || resolveHelper.isAccessible(superMethod, method2, null)) continue;
                return superMethod;
            }
        }
        return null;
    }

    private static boolean add(PsiMethod method2, Set<? super PsiMethod> alreadyImplemented) {
        boolean already = alreadyImplemented.add(method2);
        if (!already) {
            return already;
        }
        for (PsiMethod superSig : method2.findSuperMethods()) {
            already &= ClassUtil.add(superSig, alreadyImplemented);
        }
        return already;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "aClass";
        objectArray2[1] = "com/intellij/codeInsight/ClassUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnyAbstractMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnyMethodToImplement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

