/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightUtilCore
extends FileModificationService {
    public static <T extends PsiElement> T findElementInRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Class<T> klass, @NotNull Language language2) {
        if (file2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(0);
        }
        if (klass == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(1);
        }
        if (language2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(2);
        }
        return CodeInsightUtilCore.findElementInRange(file2, startOffset, endOffset, klass, language2, null);
    }

    private static <T extends PsiElement> T findElementInRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Class<T> klass, @NotNull Language language2, @Nullable PsiElement initialElement) {
        PsiElement element2;
        if (file2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(3);
        }
        if (klass == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(4);
        }
        if (language2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(5);
        }
        PsiElement element1 = file2.getViewProvider().findElementAt(startOffset, language2);
        PsiElement element22 = file2.getViewProvider().findElementAt(endOffset - 1, language2);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file2.getViewProvider().findElementAt(startOffset, language2);
        }
        if (element22 instanceof PsiWhiteSpace) {
            endOffset = element22.getTextRange().getStartOffset();
            element22 = file2.getViewProvider().findElementAt(endOffset - 1, language2);
        }
        if (element22 == null || element1 == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(element1, element22);
        PsiElement psiElement = element2 = ReflectionUtil.isAssignable(klass, commonParent.getClass()) ? commonParent : PsiTreeUtil.getParentOfType(commonParent, klass);
        if (element2 == initialElement) {
            return (T)element2;
        }
        if (element2 == null || element2.getTextRange().getStartOffset() != startOffset || element2.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return (T)element2;
    }

    public static <T extends PsiElement> T forcePsiPostprocessAndRestoreElement(@NotNull T element2) {
        if (element2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(6);
        }
        return CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(element2, false);
    }

    public static <T extends PsiElement> T forcePsiPostprocessAndRestoreElement(@NotNull T element2, boolean useFileLanguage) {
        if (element2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(7);
        }
        PsiFile psiFile = element2.getContainingFile();
        Document document = psiFile.getViewProvider().getDocument();
        Language language2 = useFileLanguage ? psiFile.getLanguage() : PsiUtilCore.getDialect(element2);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(psiFile.getProject());
        RangeMarker rangeMarker = document.createRangeMarker(element2.getTextRange());
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        documentManager.commitDocument(document);
        Object elementInRange = CodeInsightUtilCore.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), element2.getClass(), language2, element2);
        rangeMarker.dispose();
        return (T)elementInRange;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(8);
        }
        if (outChars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(9);
        }
        return CodeInsightUtilCore.parseStringCharacters(chars, outChars, sourceOffsets, true, true, '\"', '\'');
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, int @Nullable [] sourceOffsets, boolean slashMustBeEscaped, boolean exitOnEscapingWrongSymbol, char ... endChars) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(10);
        }
        if (outChars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(11);
        }
        if (endChars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(12);
        }
        assert (sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (sourceOffsets != null) {
                for (int i = 0; i < sourceOffsets.length; ++i) {
                    sourceOffsets[i] = i;
                }
            }
            return true;
        }
        int index = 0;
        int outOffset = outChars.length();
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = index - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index;
            }
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            c = chars.charAt(index++);
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    break;
                }
                case 't': {
                    outChars.append('\t');
                    break;
                }
                case 'n': {
                    outChars.append('\n');
                    break;
                }
                case 'f': {
                    outChars.append('\f');
                    break;
                }
                case 'r': {
                    outChars.append('\r');
                    break;
                }
                case 's': {
                    outChars.append(' ');
                    break;
                }
                case '\n': {
                    break;
                }
                case '\\': {
                    outChars.append('\\');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char startC = c;
                    int v = c - 48;
                    if (index < chars.length()) {
                        if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                            v <<= 3;
                            v += c - 48;
                            if (startC <= '3' && index < chars.length()) {
                                if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                    v <<= 3;
                                    v += c - 48;
                                } else {
                                    --index;
                                }
                            }
                        } else {
                            --index;
                        }
                    }
                    outChars.append((char)v);
                    break;
                }
                case 'u': {
                    while (index != chars.length() && chars.charAt(index) == 'u') {
                        ++index;
                    }
                    if (index + 4 <= chars.length()) {
                        try {
                            int code = Integer.parseInt(chars.substring(index, index + 4), 16);
                            if (code == 10 || code == 13) {
                                return false;
                            }
                            c = chars.charAt(index);
                            if (c == '+' || c == '-') {
                                return false;
                            }
                            outChars.append((char)code);
                            index += 4;
                            break;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    return false;
                }
                default: {
                    if (CharArrayUtil.indexOf(endChars, c, 0, endChars.length) != -1) {
                        outChars.append(c);
                        break;
                    }
                    if (!exitOnEscapingWrongSymbol) {
                        if (!slashMustBeEscaped) {
                            outChars.append('\\');
                            if (sourceOffsets != null) {
                                sourceOffsets[outChars.length() - outOffset] = index - 1;
                            }
                        }
                        outChars.append(c);
                        break;
                    }
                    return false;
                }
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[outChars.length() - outOffset] = index;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endChars";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/CodeInsightUtilCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementInRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "forcePsiPostprocessAndRestoreElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStringCharacters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

