/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdIterator;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaAnnotationUtil {
    private static final TObjectHashingStrategy<PsiClass> HASHING_STRATEGY = new TObjectHashingStrategy<PsiClass>(){

        @Override
        public int computeHashCode(PsiClass object) {
            String qualifiedName = object.getQualifiedName();
            return qualifiedName == null ? 0 : qualifiedName.hashCode();
        }

        @Override
        public boolean equals(PsiClass o1, PsiClass o2) {
            return Comparing.equal(o1.getQualifiedName(), o2.getQualifiedName());
        }
    };

    public static Collection<PsiClass> getAnnotationTypesWithChildren(@NotNull Module module2, String annotationName, boolean includeTests) {
        if (module2 == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(0);
        }
        Project project2 = module2.getProject();
        Map map2 = (Map)CachedValuesManager.getManager(project2).getCachedValue(module2, () -> {
            ConcurrentMap<Pair, Collection> factoryMap = ConcurrentFactoryMap.createMap(key -> {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module2, (Boolean)key.getSecond());
                PsiClass annotationClass = JavaPsiFacade.getInstance(project2).findClass((String)key.getFirst(), moduleScope);
                if (annotationClass == null || !annotationClass.isAnnotationType()) {
                    return Collections.emptyList();
                }
                GlobalSearchScope effectiveSearchScope = MetaAnnotationUtil.getAllAnnotationFilesScope(project2).intersectWith(moduleScope);
                return MetaAnnotationUtil.getAnnotationTypesWithChildren(annotationClass, effectiveSearchScope);
            });
            return CachedValueProvider.Result.create(factoryMap, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
        return (Collection)map2.get(Pair.pair(annotationName, includeTests));
    }

    public static Set<PsiClass> getChildren(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope scope) {
        if (psiClass == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(2);
        }
        if (AnnotationTargetUtil.findAnnotationTarget(psiClass, PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE) == null) {
            return Collections.emptySet();
        }
        String name = psiClass.getQualifiedName();
        if (name == null) {
            return Collections.emptySet();
        }
        THashSet<PsiClass> result2 = new THashSet<PsiClass>(HASHING_STRATEGY);
        AnnotatedElementsSearch.searchPsiClasses(psiClass, scope).forEach(processorResult -> {
            ProgressManager.checkCanceled();
            if (processorResult.isAnnotationType()) {
                result2.add((PsiClass)processorResult);
            }
            return true;
        });
        return result2;
    }

    public static Collection<PsiClass> getAnnotatedTypes(@NotNull Module module2, @NotNull Key<CachedValue<Collection<PsiClass>>> key, @NotNull String annotationName) {
        if (module2 == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(3);
        }
        if (key == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(4);
        }
        if (annotationName == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(5);
        }
        return (Collection)CachedValuesManager.getManager(module2.getProject()).getCachedValue(module2, key, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module2, false);
            PsiClass psiClass = JavaPsiFacade.getInstance(module2.getProject()).findClass(annotationName, scope);
            Collection<Object> classes = psiClass == null || !psiClass.isAnnotationType() ? Collections.emptyList() : MetaAnnotationUtil.getChildren(psiClass, scope);
            return new CachedValueProvider.Result(classes, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }, false);
    }

    @NotNull
    private static Collection<PsiClass> getAnnotationTypesWithChildren(PsiClass annotationClass, GlobalSearchScope scope) {
        THashSet<PsiClass> classes = new THashSet<PsiClass>(HASHING_STRATEGY);
        MetaAnnotationUtil.collectClassWithChildren(annotationClass, classes, scope);
        THashSet<PsiClass> tHashSet = classes;
        if (tHashSet == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(6);
        }
        return tHashSet;
    }

    private static GlobalSearchScope getAllAnnotationFilesScope(Project project2) {
        return (GlobalSearchScope)CachedValuesManager.getManager(project2).getCachedValue(project2, () -> {
            FileIdScope javaScope = new FileIdScope(project2, MetaAnnotationUtil.getJavaAnnotationInheritorIds(project2));
            GlobalSearchScope otherScope = MetaAnnotationUtil.searchForAnnotationInheritorsInOtherLanguages(project2);
            return CachedValueProvider.Result.createSingleDependency(javaScope.uniteWith(otherScope), PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    @NotNull
    private static GlobalSearchScope searchForAnnotationInheritorsInOtherLanguages(Project project2) {
        GlobalSearchScope allScope = GlobalSearchScope.allScope(project2);
        HashSet allAnnotationFiles = new HashSet();
        for (PsiClass javaLangAnnotation : JavaPsiFacade.getInstance(project2).findClasses("java.lang.annotation.Annotation", allScope)) {
            DirectClassInheritorsSearch.SearchParameters parameters = new DirectClassInheritorsSearch.SearchParameters(javaLangAnnotation, allScope, false, true){

                @Override
                public boolean shouldSearchInLanguage(@NotNull Language language2) {
                    if (language2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return language2 != JavaLanguage.INSTANCE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/MetaAnnotationUtil$2", "shouldSearchInLanguage"));
                }
            };
            DirectClassInheritorsSearch.search(parameters).forEach(annotationClass -> {
                ProgressManager.checkCanceled();
                ContainerUtil.addIfNotNull(allAnnotationFiles, PsiUtilCore.getVirtualFile(annotationClass));
                return true;
            });
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesWithLibrariesScope(project2, allAnnotationFiles);
        if (globalSearchScope == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @NotNull
    private static TIntHashSet getJavaAnnotationInheritorIds(Project project2) {
        IdIterator iterator2 = StubIndex.getInstance().getContainingIds(JavaStubIndexKeys.SUPER_CLASSES, "Annotation", project2, GlobalSearchScope.allScope(project2));
        TIntHashSet idSet = new TIntHashSet();
        while (iterator2.hasNext()) {
            idSet.add(iterator2.next());
        }
        TIntHashSet tIntHashSet = idSet;
        if (tIntHashSet == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(8);
        }
        return tIntHashSet;
    }

    private static void collectClassWithChildren(PsiClass psiClass, Set<? super PsiClass> classes, GlobalSearchScope scope) {
        classes.add(psiClass);
        for (PsiClass aClass : MetaAnnotationUtil.getChildren(psiClass, scope)) {
            if (classes.contains(aClass)) continue;
            MetaAnnotationUtil.collectClassWithChildren(aClass, classes, scope);
        }
    }

    public static boolean isMetaAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(9);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(10);
        }
        if (AnnotationUtil.isAnnotated(listOwner, annotations, 0)) {
            return true;
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner);
        for (String annotationFQN : annotations) {
            for (PsiClass resolvedAnnotation : resolvedAnnotations) {
                if (MetaAnnotationUtil.metaAnnotationCached(resolvedAnnotation, annotationFQN) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMetaAnnotatedInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(11);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(12);
        }
        return MetaAnnotationUtil.isMetaAnnotatedInHierarchy(listOwner, annotations, new HashSet());
    }

    private static boolean isMetaAnnotatedInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, Set<? super PsiMember> visited) {
        block6: {
            block5: {
                if (listOwner == null) {
                    MetaAnnotationUtil.$$$reportNull$$$0(13);
                }
                if (annotations == null) {
                    MetaAnnotationUtil.$$$reportNull$$$0(14);
                }
                if (MetaAnnotationUtil.isMetaAnnotated(listOwner, annotations)) {
                    return true;
                }
                if (!(listOwner instanceof PsiClass)) break block5;
                for (PsiClass superClass : ((PsiClass)listOwner).getSupers()) {
                    if (!visited.add(superClass) || !MetaAnnotationUtil.isMetaAnnotatedInHierarchy(superClass, annotations, visited)) continue;
                    return true;
                }
                break block6;
            }
            if (!(listOwner instanceof PsiMethod)) break block6;
            for (PsiMethod method2 : ((PsiMethod)listOwner).findSuperMethods()) {
                if (!visited.add(method2) || !MetaAnnotationUtil.isMetaAnnotatedInHierarchy(method2, annotations, visited)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiAnnotation metaAnnotationCached(PsiClass subjectAnnotation, String annotationToFind) {
        return (PsiAnnotation)((ConcurrentMap)CachedValuesManager.getCachedValue(subjectAnnotation, () -> {
            ConcurrentMap<String, PsiAnnotation> metaAnnotationsMap = ConcurrentFactoryMap.createMap(anno -> MetaAnnotationUtil.findMetaAnnotation(subjectAnnotation, anno, new HashSet()));
            return new CachedValueProvider.Result<ConcurrentMap<String, PsiAnnotation>>(metaAnnotationsMap, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        })).get(annotationToFind);
    }

    @Nullable
    private static PsiAnnotation findMetaAnnotation(PsiClass aClass, String annotation, Set<? super PsiClass> visited) {
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, true, annotation);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(aClass);
        for (PsiClass resolvedAnnotation : resolvedAnnotations) {
            PsiAnnotation annotated;
            if (!visited.add(resolvedAnnotation) || (annotated = MetaAnnotationUtil.findMetaAnnotation(resolvedAnnotation, annotation, visited)) == null) continue;
            return annotated;
        }
        return null;
    }

    @NotNull
    public static Stream<PsiAnnotation> findMetaAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (listOwner == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(15);
        }
        if (annotations == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(16);
        }
        Stream<PsiAnnotation> directAnnotations = Stream.of(AnnotationUtil.findAnnotations(listOwner, annotations));
        Stream lazyResolvedAnnotations = Stream.generate(() -> MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner)).limit(1L).flatMap(it -> it.stream());
        Stream<PsiAnnotation> metaAnnotations = lazyResolvedAnnotations.flatMap(psiClass -> annotations.stream().map(annotationFQN -> MetaAnnotationUtil.metaAnnotationCached(psiClass, annotationFQN))).filter(Objects::nonNull);
        Stream<PsiAnnotation> stream = Stream.concat(directAnnotations, metaAnnotations);
        if (stream == null) {
            MetaAnnotationUtil.$$$reportNull$$$0(17);
        }
        return stream;
    }

    private static List<PsiClass> getResolvedClassesInAnnotationsList(PsiModifierListOwner owner) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            return ContainerUtil.mapNotNull(modifierList.getApplicableAnnotations(), psiAnnotation -> {
                PsiJavaCodeReferenceElement nameReferenceElement = psiAnnotation.getNameReferenceElement();
                PsiElement resolve2 = nameReferenceElement != null ? nameReferenceElement.resolve() : null;
                return resolve2 instanceof PsiClass && ((PsiClass)resolve2).isAnnotationType() ? (PsiClass)resolve2 : null;
            });
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/MetaAnnotationUtil";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/MetaAnnotationUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationTypesWithChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "searchForAnnotationInheritorsInOtherLanguages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaAnnotationInheritorIds";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findMetaAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationTypesWithChildren";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedTypes";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotated";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAnnotatedInHierarchy";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findMetaAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileIdScope
    extends GlobalSearchScope {
        private final TIntHashSet myIdSet;

        FileIdScope(Project project2, TIntHashSet idSet) {
            super(project2);
            this.myIdSet = idSet;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FileIdScope.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FileIdScope.$$$reportNull$$$0(1);
            }
            return file2 instanceof VirtualFileWithId && this.myIdSet.contains(((VirtualFileWithId)((Object)file2)).getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/MetaAnnotationUtil$FileIdScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

