/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.navigation.NavigationTarget;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"collectAllTargets", "", "Lcom/intellij/navigation/NavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "findAllTargets", "findAllTargetsNoVS", "offset", "", "intellij.platform.lang.impl"})
@ApiStatus.Experimental
public final class TargetElementUtilKt {
    @NotNull
    public static final Collection<NavigationTarget> findAllTargets(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        if (TargetElementUtil.inVirtualSpace(editor, offset)) {
            return CollectionsKt.emptyList();
        }
        return TargetElementUtilKt.findAllTargetsNoVS(project2, editor, offset, file2);
    }

    private static final Collection<NavigationTarget> findAllTargetsNoVS(Project project2, Editor editor, int offset, PsiFile file2) {
        Collection<NavigationTarget> targets2 = TargetElementUtilKt.collectAllTargets(project2, editor, file2);
        if (!targets2.isEmpty()) {
            return targets2;
        }
        if (editor instanceof EditorWindow) {
            Editor editor2 = ((EditorWindow)editor).getDelegate();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.delegate");
            return TargetElementUtilKt.findAllTargetsNoVS(project2, editor2, ((EditorWindow)editor).getDocument().injectedToHost(offset), file2);
        }
        return CollectionsKt.emptyList();
    }

    private static final Collection<NavigationTarget> collectAllTargets(Project project2, Editor editor, PsiFile file2) {
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }
}

