/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.Language;
import com.intellij.model.Symbol;
import com.intellij.model.SymbolResolveResult;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TargetEvaluatorAwareReference
implements PsiSymbolReference {
    private static final int ourDefaultFlags = 3;
    private final PsiReference myReference;

    public TargetEvaluatorAwareReference(@NotNull PsiReference reference2) {
        if (reference2 == null) {
            TargetEvaluatorAwareReference.$$$reportNull$$$0(0);
        }
        this.myReference = reference2;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myReference.getElement();
        if (psiElement == null) {
            TargetEvaluatorAwareReference.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myReference.getRangeInElement();
        if (textRange == null) {
            TargetEvaluatorAwareReference.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @Override
    @NotNull
    public TextRange getAbsoluteRange() {
        TextRange textRange = this.myReference.getAbsoluteRange();
        if (textRange == null) {
            TargetEvaluatorAwareReference.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Override
    public boolean resolvesTo(@NotNull Symbol target2) {
        if (target2 == null) {
            TargetEvaluatorAwareReference.$$$reportNull$$$0(4);
        }
        return this.myReference.resolvesTo(target2);
    }

    @Override
    @NotNull
    public Collection<? extends SymbolResolveResult> resolveReference() {
        PsiElement targetElement = this.getTargetElement();
        if (targetElement != null) {
            Symbol symbol = PsiSymbolService.getInstance().asSymbol(targetElement);
            List<SymbolResolveResult> list2 = Collections.singletonList(SymbolResolveResult.fromSymbol(symbol));
            if (list2 == null) {
                TargetEvaluatorAwareReference.$$$reportNull$$$0(5);
            }
            return list2;
        }
        Collection<? extends SymbolResolveResult> collection = this.myReference.resolveReference();
        if (collection == null) {
            TargetEvaluatorAwareReference.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Nullable
    private PsiElement getTargetElement() {
        PsiElement adjustedElement;
        PsiElement referencedElement = TargetElementUtilBase.getReferencedElement(this.myReference, 3);
        PsiFile file2 = this.getElement().getContainingFile();
        Project project2 = file2.getProject();
        int offsetInFile = this.getAbsoluteRange().getStartOffset();
        PsiElement leafElement = file2.findElementAt(offsetInFile);
        Document document = PsiDocumentManager.getInstance(project2).getDocument(file2);
        if (document == null) {
            adjustedElement = referencedElement;
        } else {
            Language language2 = leafElement == null ? file2.getLanguage() : leafElement.getLanguage();
            TargetElementEvaluatorEx2 evaluatorEx2 = TargetElementUtilBase.getElementEvaluatorsEx2(language2);
            if (evaluatorEx2 == null) {
                adjustedElement = referencedElement;
            } else {
                Editor editor = TargetEvaluatorAwareReference.mockEditor(project2, document);
                adjustedElement = evaluatorEx2.adjustReferenceOrReferencedElement(file2, editor, offsetInFile, 3, referencedElement);
            }
        }
        return TargetElementUtilBase.isAcceptableReferencedElement(leafElement, adjustedElement) ? adjustedElement : null;
    }

    @NotNull
    private static Editor mockEditor(final @NotNull Project project2, @NotNull Document document) {
        if (project2 == null) {
            TargetEvaluatorAwareReference.$$$reportNull$$$0(7);
        }
        if (document == null) {
            TargetEvaluatorAwareReference.$$$reportNull$$$0(8);
        }
        return new ImaginaryEditor(document){

            @Override
            public Project getProject() {
                return project2;
            }

            public String toString() {
                return "API compatibility editor";
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/TargetEvaluatorAwareReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/TargetEvaluatorAwareReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsoluteRange";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolvesTo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mockEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

