/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.testIntegration.TestFramework;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestFrameworks {
    public static TestFrameworks getInstance() {
        return ServiceManager.getService(TestFrameworks.class);
    }

    public abstract boolean isTestClass(PsiClass var1);

    public abstract boolean isPotentialTestClass(PsiClass var1);

    @Nullable
    public abstract PsiMethod findOrCreateSetUpMethod(PsiClass var1);

    @Nullable
    public abstract PsiMethod findSetUpMethod(PsiClass var1);

    @Nullable
    public abstract PsiMethod findTearDownMethod(PsiClass var1);

    protected abstract boolean hasConfigMethods(PsiClass var1);

    public abstract boolean isTestMethod(PsiMethod var1);

    public boolean isTestMethod(PsiMethod method2, boolean checkAbstract) {
        return this.isTestMethod(method2);
    }

    public boolean isTestOrConfig(PsiClass psiClass) {
        return this.isTestClass(psiClass) || this.hasConfigMethods(psiClass);
    }

    @Nullable
    public static TestFramework detectFramework(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            TestFrameworks.$$$reportNull$$$0(0);
        }
        return (TestFramework)CachedValuesManager.getCachedValue(psiClass, () -> CachedValueProvider.Result.create(TestFrameworks.computeFramework(psiClass), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT));
    }

    @NotNull
    public static Set<TestFramework> detectApplicableFrameworks(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            TestFrameworks.$$$reportNull$$$0(1);
        }
        Set set = (Set)CachedValuesManager.getCachedValue(psiClass, () -> CachedValueProvider.Result.create(TestFrameworks.computeFrameworks(psiClass), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT));
        if (set == null) {
            TestFrameworks.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static Set<TestFramework> computeFrameworks(PsiClass psiClass) {
        LinkedHashSet<TestFramework> frameworks = new LinkedHashSet<TestFramework>();
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (!framework.isTestClass(psiClass)) continue;
            frameworks.add(framework);
        }
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (frameworks.contains(framework) || framework.findSetUpMethod(psiClass) == null && framework.findTearDownMethod(psiClass) == null) continue;
            frameworks.add(framework);
        }
        return frameworks;
    }

    @Nullable
    private static TestFramework computeFramework(PsiClass psiClass) {
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (!framework.isTestClass(psiClass)) continue;
            return framework;
        }
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (framework.findSetUpMethod(psiClass) == null && framework.findTearDownMethod(psiClass) == null) continue;
            return framework;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/TestFrameworks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/TestFrameworks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "detectApplicableFrameworks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectFramework";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "detectApplicableFrameworks";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

