/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.FileInEditorProcessor;
import com.intellij.codeInsight.actions.LayoutCodeDialog;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShowReformatFileDialog
extends AnAction
implements DumbAware {
    @NonNls
    private static final String HELP_ID = "editing.codeReformatting";

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ShowReformatFileDialog.$$$reportNull$$$0(0);
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        if (project2 == null || editor == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        if (file2 == null || file2.getVirtualFile() == null) {
            presentation.setEnabled(false);
            return;
        }
        if (LanguageFormatting.INSTANCE.forContext(file2) != null) {
            presentation.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            ShowReformatFileDialog.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        if (project2 == null || editor == null) {
            presentation.setEnabled(false);
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        if (file2 == null || file2.getVirtualFile() == null) {
            presentation.setEnabled(false);
            return;
        }
        boolean hasSelection = editor.getSelectionModel().hasSelection();
        LayoutCodeDialog dialog2 = new LayoutCodeDialog(project2, file2, hasSelection, HELP_ID);
        dialog2.show();
        if (dialog2.isOK()) {
            new FileInEditorProcessor(file2, editor, dialog2.getRunOptions()).processCode();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "com/intellij/codeInsight/actions/ShowReformatFileDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

