/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionAssertions;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionInitializationContextImpl;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetTranslator;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class CompletionInitializationUtil {
    private static final Logger LOG = Logger.getInstance(CompletionInitializationUtil.class);
    private static final Key<SoftReference<Pair<PsiFile, Document>>> FILE_COPY_KEY = Key.create("CompletionFileCopy");

    public static CompletionInitializationContextImpl createCompletionInitializationContext(@NotNull Project project2, @NotNull Editor editor, @NotNull Caret caret, int invocationCount, CompletionType completionType) {
        if (project2 == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(1);
        }
        if (caret == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(2);
        }
        return WriteAction.compute(() -> {
            PsiDocumentManager.getInstance(project2).commitAllDocuments();
            CompletionAssertions.checkEditorValid(editor);
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor, project2);
            assert (psiFile != null) : "no PSI file: " + FileDocumentManager.getInstance().getFile(editor.getDocument());
            psiFile.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, Boolean.TRUE);
            CompletionAssertions.assertCommitSuccessful(editor, psiFile);
            return CompletionInitializationUtil.runContributorsBeforeCompletion(editor, psiFile, invocationCount, caret, completionType);
        });
    }

    private static CompletionInitializationContextImpl runContributorsBeforeCompletion(Editor editor, PsiFile psiFile, int invocationCount, @NotNull Caret caret, CompletionType completionType) {
        if (caret == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(3);
        }
        final Ref<Object> current2 = Ref.create(null);
        CompletionInitializationContextImpl context = new CompletionInitializationContextImpl(editor, caret, psiFile, completionType, invocationCount){
            CompletionContributor dummyIdentifierChanger;

            @Override
            public void setDummyIdentifier(@NotNull String dummyIdentifier) {
                if (dummyIdentifier == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.setDummyIdentifier(dummyIdentifier);
                if (this.dummyIdentifierChanger != null) {
                    LOG.error("Changing the dummy identifier twice, already changed by " + this.dummyIdentifierChanger);
                }
                this.dummyIdentifierChanger = (CompletionContributor)current2.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dummyIdentifier", "com/intellij/codeInsight/completion/CompletionInitializationUtil$1", "setDummyIdentifier"));
            }
        };
        Project project2 = psiFile.getProject();
        for (CompletionContributor contributor : CompletionContributor.forLanguageHonorDumbness(context.getPositionLanguage(), project2)) {
            current2.set(contributor);
            contributor.beforeCompletion(context);
            CompletionAssertions.checkEditorValid(editor);
            assert (!PsiDocumentManager.getInstance(project2).isUncommited(editor.getDocument())) : "Contributor " + contributor + " left the document uncommitted";
        }
        return context;
    }

    @NotNull
    public static CompletionParameters createCompletionParameters(CompletionInitializationContext initContext, CompletionProcessEx indicator, OffsetsInFile finalOffsets) {
        int offset = finalOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        PsiFile fileCopy = finalOffsets.getFile();
        PsiFile originalFile = fileCopy.getOriginalFile();
        PsiElement insertedElement = CompletionInitializationUtil.findCompletionPositionLeaf(finalOffsets, offset, originalFile);
        insertedElement.putUserData(CompletionContext.COMPLETION_CONTEXT_KEY, new CompletionContext(fileCopy, finalOffsets.getOffsets()));
        return new CompletionParameters(insertedElement, originalFile, initContext.getCompletionType(), offset, initContext.getInvocationCount(), initContext.getEditor(), indicator);
    }

    public static Supplier<OffsetsInFile> insertDummyIdentifier(CompletionInitializationContext initContext, CompletionProcessEx indicator) {
        OffsetsInFile topLevelOffsets = indicator.getHostOffsets();
        CompletionAssertions.checkEditorValid(initContext.getEditor());
        if (initContext.getDummyIdentifier().isEmpty()) {
            return () -> topLevelOffsets;
        }
        Editor editor = initContext.getEditor();
        Editor hostEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        OffsetMap hostMap = topLevelOffsets.getOffsets();
        PsiFile hostCopy = CompletionInitializationUtil.obtainFileCopy(topLevelOffsets.getFile());
        Document copyDocument = Objects.requireNonNull(hostCopy.getViewProvider().getDocument());
        String dummyIdentifier = initContext.getDummyIdentifier();
        int startOffset = hostMap.getOffset(CompletionInitializationContext.START_OFFSET);
        int endOffset = hostMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
        Supplier<OffsetsInFile> apply2 = topLevelOffsets.replaceInCopy(hostCopy, startOffset, endOffset, dummyIdentifier);
        return () -> WriteAction.compute(() -> CompletionInitializationUtil.lambda$null$4(indicator, hostEditor, initContext, copyDocument, startOffset, endOffset, dummyIdentifier, (Supplier)apply2));
    }

    public static OffsetsInFile toInjectedIfAny(PsiFile originalFile, OffsetsInFile hostCopyOffsets) {
        CompletionAssertions.assertHostInfo(hostCopyOffsets.getFile(), hostCopyOffsets.getOffsets());
        int hostStartOffset = hostCopyOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET);
        OffsetsInFile translatedOffsets = hostCopyOffsets.toInjectedIfAny(hostStartOffset);
        if (translatedOffsets != hostCopyOffsets) {
            PsiFile injected = translatedOffsets.getFile();
            if (originalFile != injected && injected instanceof PsiFileImpl && InjectedLanguageManager.getInstance(originalFile.getProject()).isInjectedFragment(originalFile)) {
                CompletionInitializationUtil.setOriginalFile((PsiFileImpl)injected, originalFile);
            }
            VirtualFile virtualFile2 = injected.getVirtualFile();
            DocumentWindow documentWindow = null;
            if (virtualFile2 instanceof VirtualFileWindow) {
                documentWindow = ((VirtualFileWindow)((Object)virtualFile2)).getDocumentWindow();
            }
            CompletionAssertions.assertInjectedOffsets(hostStartOffset, injected, documentWindow);
            if (injected.getTextRange().contains(translatedOffsets.getOffsets().getOffset(CompletionInitializationContext.START_OFFSET))) {
                return translatedOffsets;
            }
        }
        return hostCopyOffsets;
    }

    private static void setOriginalFile(PsiFileImpl copy2, PsiFile origin) {
        PsiFile currentOrigin = copy2.getOriginalFile();
        if (currentOrigin == copy2) {
            copy2.setOriginalFile(origin);
        } else {
            PsiUtilCore.ensureValid(currentOrigin);
            LOG.assertTrue(currentOrigin == origin);
        }
    }

    @NotNull
    private static PsiElement findCompletionPositionLeaf(OffsetsInFile offsets2, int offset, PsiFile originalFile) {
        PsiElement insertedElement = offsets2.getFile().findElementAt(offset);
        if (insertedElement == null && offsets2.getFile().getTextLength() == offset) {
            insertedElement = PsiTreeUtil.getDeepestLast(offsets2.getFile());
        }
        CompletionAssertions.assertCompletionPositionPsiConsistent(offsets2, offset, originalFile, insertedElement);
        PsiElement psiElement = insertedElement;
        if (psiElement == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    private static PsiFile obtainFileCopy(PsiFile file2) {
        Pair cached;
        boolean mayCacheCopy;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        boolean bl = mayCacheCopy = file2.isPhysical() && virtualFile2 != null && virtualFile2.isInLocalFileSystem();
        if (mayCacheCopy && (cached = (Pair)SoftReference.dereference(file2.getUserData(FILE_COPY_KEY))) != null && CompletionInitializationUtil.isCopyUpToDate((Document)cached.second, (PsiFile)cached.first, file2)) {
            PsiFile copy2 = (PsiFile)cached.first;
            CompletionAssertions.assertCorrectOriginalFile("Cached", file2, copy2);
            return copy2;
        }
        PsiFile copy3 = (PsiFile)file2.copy();
        if (copy3.isPhysical() || copy3.getViewProvider().isEventSystemEnabled()) {
            LOG.error("File copy should be non-physical and non-event-system-enabled! Language=" + file2.getLanguage() + "; file=" + file2 + " of " + file2.getClass());
        }
        CompletionAssertions.assertCorrectOriginalFile("New", file2, copy3);
        if (mayCacheCopy) {
            Document document = copy3.getViewProvider().getDocument();
            assert (document != null);
            CompletionInitializationUtil.syncAcceptSlashR(file2.getViewProvider().getDocument(), document);
            file2.putUserData(FILE_COPY_KEY, new SoftReference<Pair<PsiFile, Document>>(Pair.create(copy3, document)));
        }
        return copy3;
    }

    private static boolean isCopyUpToDate(Document document, @NotNull PsiFile copyFile, @NotNull PsiFile originalFile) {
        if (copyFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(5);
        }
        if (originalFile == null) {
            CompletionInitializationUtil.$$$reportNull$$$0(6);
        }
        if (!(copyFile.getClass().equals(originalFile.getClass()) && copyFile.isValid() && copyFile.getName().equals(originalFile.getName()))) {
            return false;
        }
        PsiFile current2 = PsiDocumentManager.getInstance(copyFile.getProject()).getPsiFile(document);
        return current2 != null && current2.getViewProvider().getPsi(copyFile.getLanguage()) == copyFile;
    }

    private static void syncAcceptSlashR(Document originalDocument, Document documentCopy) {
        if (!(originalDocument instanceof DocumentImpl) || !(documentCopy instanceof DocumentImpl)) {
            return;
        }
        ((DocumentImpl)documentCopy).setAcceptSlashR(((DocumentImpl)originalDocument).acceptsSlashR());
    }

    private static /* synthetic */ OffsetsInFile lambda$null$4(CompletionProcessEx indicator, Editor hostEditor, CompletionInitializationContext initContext, Document copyDocument, int startOffset, int endOffset, String dummyIdentifier, Supplier apply2) throws RuntimeException {
        indicator.registerChildDisposable(() -> new OffsetTranslator(hostEditor.getDocument(), initContext.getFile(), copyDocument, startOffset, endOffset, dummyIdentifier));
        OffsetsInFile copyOffsets = (OffsetsInFile)apply2.get();
        indicator.registerChildDisposable(() -> copyOffsets.getOffsets());
        return copyOffsets;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionInitializationUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionInitializationUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findCompletionPositionLeaf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionInitializationContext";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runContributorsBeforeCompletion";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCopyUpToDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

