/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.AsyncCompletion;
import com.intellij.codeInsight.completion.BaseCompletionLookupArranger;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionLookupArrangerImpl;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionPreselectionBehaviourProvider;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionThreadingBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.DefaultCompletionContributor;
import com.intellij.codeInsight.completion.EmptyCompletionNotifier;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.StatisticsUpdate;
import com.intellij.codeInsight.completion.SyncCompletion;
import com.intellij.codeInsight.completion.WeighingDelegate;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CompletionProgressIndicator
extends ProgressIndicatorBase
implements CompletionProcessEx,
Disposable {
    private static final Logger LOG = Logger.getInstance(CompletionProgressIndicator.class);
    private final Editor myEditor;
    @NotNull
    private final Caret myCaret;
    @Nullable
    private CompletionParameters myParameters;
    private final CodeCompletionHandlerBase myHandler;
    private final CompletionLookupArrangerImpl myArranger;
    private final CompletionType myCompletionType;
    private final int myInvocationCount;
    private OffsetsInFile myHostOffsets;
    private final LookupImpl myLookup;
    private final Alarm mySuppressTimeoutAlarm;
    private final MergingUpdateQueue myQueue;
    private final Update myUpdate;
    private final Semaphore myFreezeSemaphore;
    private final Semaphore myFinishSemaphore;
    @NotNull
    private final OffsetMap myOffsetMap;
    private final Set<Pair<Integer, ElementPattern<String>>> myRestartingPrefixConditions;
    private final LookupListener myLookupListener;
    private volatile boolean myIsUpdateSuppressed;
    private static int ourInsertSingleItemTimeSpan = 300;
    private static int ourShowPopupGroupingTime = 300;
    private static int ourShowPopupAfterFirstItemGroupingTime = 100;
    private volatile int myCount;
    private volatile boolean myHasPsiElements;
    private boolean myLookupUpdated;
    private final PropertyChangeListener myLookupManagerListener;
    private final Queue<Runnable> myAdvertiserChanges;
    private final List<CompletionResult> myDelayedMiddleMatches;
    private final int myStartCaret;
    private final CompletionThreadingBase myThreading;
    private final Object myLock;
    private final EmptyCompletionNotifier myEmptyCompletionNotifier;

    CompletionProgressIndicator(Editor editor, @NotNull Caret caret, int invocationCount, CodeCompletionHandlerBase handler2, @NotNull OffsetMap offsetMap, @NotNull OffsetsInFile hostOffsets, boolean hasModifiers, @NotNull LookupImpl lookup2) {
        if (caret == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(0);
        }
        if (offsetMap == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(1);
        }
        if (hostOffsets == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(2);
        }
        if (lookup2 == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(3);
        }
        this.mySuppressTimeoutAlarm = new Alarm(this);
        this.myUpdate = new Update((Object)"update"){

            @Override
            public void run() {
                CompletionProgressIndicator.this.updateLookup(CompletionProgressIndicator.this.myIsUpdateSuppressed);
                CompletionProgressIndicator.this.myQueue.setMergingTimeSpan(ourShowPopupGroupingTime);
            }
        };
        this.myFreezeSemaphore = new Semaphore(1);
        this.myFinishSemaphore = new Semaphore(1);
        this.myRestartingPrefixConditions = ContainerUtil.newConcurrentSet();
        this.myLookupListener = new LookupListener(){

            @Override
            public void lookupCanceled(@NotNull LookupEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                CompletionProgressIndicator.this.finishCompletionProcess(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/completion/CompletionProgressIndicator$2", "lookupCanceled"));
            }
        };
        this.myIsUpdateSuppressed = false;
        this.myAdvertiserChanges = new ConcurrentLinkedQueue<Runnable>();
        this.myDelayedMiddleMatches = new ArrayList<CompletionResult>();
        this.myLock = ObjectUtils.sentinel("CompletionProgressIndicator");
        this.myEditor = editor;
        this.myCaret = caret;
        this.myHandler = handler2;
        this.myCompletionType = handler2.completionType;
        this.myInvocationCount = invocationCount;
        this.myOffsetMap = offsetMap;
        this.myHostOffsets = hostOffsets;
        this.myLookup = lookup2;
        this.myStartCaret = this.myEditor.getCaretModel().getOffset();
        this.myThreading = ApplicationManager.getApplication().isWriteAccessAllowed() || this.myHandler.isTestingCompletionQualityMode() ? new SyncCompletion() : new AsyncCompletion();
        this.myAdvertiserChanges.offer(() -> this.myLookup.getAdvertiser().clearAdvertisements());
        this.myArranger = new CompletionLookupArrangerImpl(this);
        this.myLookup.setArranger(this.myArranger);
        this.myLookup.addLookupListener(this.myLookupListener);
        this.myLookup.setCalculating(true);
        this.myEmptyCompletionNotifier = LightEdit.owns(editor.getProject()) ? LightEditUtil.createEmptyCompletionNotifier() : new ProjectEmptyCompletionNotifier();
        this.myLookupManagerListener = evt -> {
            if (evt.getNewValue() != null) {
                LOG.error("An attempt to change the lookup during completion, phase = " + CompletionServiceImpl.getCompletionPhase());
            }
        };
        LookupManager.getInstance(this.getProject()).addPropertyChangeListener(this.myLookupManagerListener);
        this.myQueue = new MergingUpdateQueue("completion lookup progress", ourShowPopupAfterFirstItemGroupingTime, true, this.myEditor.getContentComponent());
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (hasModifiers && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.trackModifiers();
        }
    }

    @Override
    public void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
        boolean dispose2 = lookupItem == null;
        this.finishCompletionProcess(dispose2);
        if (dispose2) {
            return;
        }
        this.setMergeCommand();
        this.myHandler.lookupItemSelected(this, lookupItem, completionChar, this.myLookup.getItems());
    }

    @Override
    @NotNull
    public OffsetMap getOffsetMap() {
        OffsetMap offsetMap = this.myOffsetMap;
        if (offsetMap == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(4);
        }
        return offsetMap;
    }

    @Override
    @NotNull
    public OffsetsInFile getHostOffsets() {
        OffsetsInFile offsetsInFile = this.myHostOffsets;
        if (offsetsInFile == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(5);
        }
        return offsetsInFile;
    }

    void duringCompletion(CompletionInitializationContext initContext, CompletionParameters parameters) {
        PsiUtilCore.ensureValid(parameters.getPosition());
        if (this.isAutopopupCompletion() && CompletionProgressIndicator.shouldPreselectFirstSuggestion(parameters)) {
            this.myLookup.setLookupFocusDegree(CodeInsightSettings.getInstance().isSelectAutopopupSuggestionsByChars() ? LookupFocusDegree.FOCUSED : LookupFocusDegree.SEMI_FOCUSED);
        }
        this.addDefaultAdvertisements(parameters);
        ProgressManager.checkCanceled();
        Document document = initContext.getEditor().getDocument();
        if (!initContext.getOffsetMap().wasModified(CompletionInitializationContext.IDENTIFIER_END_OFFSET)) {
            try {
                int selectionEndOffset = initContext.getSelectionEndOffset();
                PsiReference reference2 = TargetElementUtil.findReference(this.myEditor, selectionEndOffset);
                if (reference2 != null) {
                    int replacementOffset = CompletionProgressIndicator.findReplacementOffset(selectionEndOffset, reference2);
                    if (replacementOffset > document.getTextLength()) {
                        LOG.error("Invalid replacementOffset: " + replacementOffset + " returned by reference " + reference2 + " of " + reference2.getClass() + "; doc=" + document + "; doc actual=" + (document == initContext.getFile().getViewProvider().getDocument()) + "; doc committed=" + PsiDocumentManager.getInstance(this.getProject()).isCommitted(document));
                    } else {
                        initContext.setReplacementOffset(replacementOffset);
                    }
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        for (CompletionContributor contributor : CompletionContributor.forLanguageHonorDumbness(initContext.getPositionLanguage(), initContext.getProject())) {
            ProgressManager.checkCanceled();
            contributor.duringCompletion(initContext);
        }
        if (document instanceof DocumentWindow) {
            this.myHostOffsets = new OffsetsInFile(initContext.getFile(), initContext.getOffsetMap()).toTopLevelFile();
        }
    }

    private void addDefaultAdvertisements(CompletionParameters parameters) {
        if (DumbService.isDumb(this.getProject())) {
            this.addAdvertisement(CodeInsightBundle.message("completion.incomplete.during.indexing", new Object[0]), AllIcons.General.Warning);
            return;
        }
        String enterShortcut = KeymapUtil.getFirstKeyboardShortcutText("EditorChooseLookupItem");
        String tabShortcut = KeymapUtil.getFirstKeyboardShortcutText("EditorChooseLookupItemReplace");
        this.addAdvertisement(CodeInsightBundle.message("completion.ad.press.0.to.insert.1.to.replace", enterShortcut, tabShortcut), null);
        this.advertiseTabReplacement(parameters);
        if (this.isAutopopupCompletion()) {
            if (CompletionProgressIndicator.shouldPreselectFirstSuggestion(parameters) && !CodeInsightSettings.getInstance().isSelectAutopopupSuggestionsByChars()) {
                this.advertiseCtrlDot();
            }
            this.advertiseCtrlArrows();
        }
    }

    private void advertiseTabReplacement(CompletionParameters parameters) {
        String shortcut;
        if (CompletionUtil.shouldShowFeature(parameters, "editing.completion.replace") && this.myOffsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET) != this.myOffsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET) && StringUtil.isNotEmpty(shortcut = KeymapUtil.getFirstKeyboardShortcutText("EditorChooseLookupItemReplace"))) {
            this.addAdvertisement(CodeInsightBundle.message("completion.ad.use.0.to.overwrite", shortcut), null);
        }
    }

    private void advertiseCtrlDot() {
        String dotShortcut;
        if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.finishByCtrlDot", this.getProject()) && StringUtil.isNotEmpty(dotShortcut = KeymapUtil.getFirstKeyboardShortcutText("EditorChooseLookupItemDot"))) {
            this.addAdvertisement(CodeInsightBundle.message("completion.ad.press.0.to.choose.with.dot", dotShortcut), null);
        }
    }

    private void advertiseCtrlArrows() {
        if (!this.myEditor.isOneLineMode() && FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.cancelByControlArrows", this.getProject())) {
            String downShortcut = KeymapUtil.getFirstKeyboardShortcutText("EditorLookupDown");
            String upShortcut = KeymapUtil.getFirstKeyboardShortcutText("EditorLookupUp");
            if (StringUtil.isNotEmpty(downShortcut) && StringUtil.isNotEmpty(upShortcut)) {
                this.addAdvertisement(CodeInsightBundle.message("completion.ad.moving.caret.down.and.up.in.the.editor", downShortcut, upShortcut), null);
            }
        }
    }

    @Override
    public void dispose() {
    }

    private static int findReplacementOffset(int selectionEndOffset, PsiReference reference2) {
        List<TextRange> ranges2 = ReferenceRange.getAbsoluteRanges(reference2);
        for (TextRange range2 : ranges2) {
            if (!range2.contains(selectionEndOffset)) continue;
            return range2.getEndOffset();
        }
        return selectionEndOffset;
    }

    void scheduleAdvertising(CompletionParameters parameters) {
        if (this.myLookup.isAvailableToUser()) {
            return;
        }
        for (CompletionContributor contributor : CompletionContributor.forParameters(parameters)) {
            if (!this.myLookup.isCalculating() && !this.myLookup.isVisible()) {
                return;
            }
            String s = contributor.advertise(parameters);
            if (s == null) continue;
            this.addAdvertisement(s, null);
        }
    }

    private boolean isOutdated() {
        return CompletionServiceImpl.getCompletionPhase().indicator != this;
    }

    private void trackModifiers() {
        assert (!this.isAutopopupCompletion());
        JComponent contentComponent = this.myEditor.getContentComponent();
        contentComponent.addKeyListener(new ModifierTracker(contentComponent));
    }

    void setMergeCommand() {
        CommandProcessor.getInstance().setCurrentCommandGroupId(this.getCompletionCommandName());
    }

    @NonNls
    private String getCompletionCommandName() {
        return "Completion" + this.hashCode();
    }

    void showLookup() {
        this.updateLookup(this.myIsUpdateSuppressed);
    }

    @Override
    @Nullable
    public CompletionParameters getParameters() {
        return this.myParameters;
    }

    @Override
    public void setParameters(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(6);
        }
        this.myParameters = parameters;
    }

    @Override
    @NotNull
    public LookupImpl getLookup() {
        LookupImpl lookupImpl = this.myLookup;
        if (lookupImpl == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(7);
        }
        return lookupImpl;
    }

    void withSingleUpdate(Runnable action2) {
        try {
            this.myIsUpdateSuppressed = true;
            action2.run();
        }
        finally {
            this.myIsUpdateSuppressed = false;
            this.myQueue.queue(this.myUpdate);
        }
    }

    private void updateLookup(boolean isUpdateSuppressed) {
        Runnable action2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isOutdated() || !this.shouldShowLookup() || isUpdateSuppressed) {
            return;
        }
        while ((action2 = this.myAdvertiserChanges.poll()) != null) {
            action2.run();
        }
        if (!this.myLookupUpdated) {
            if (this.myLookup.getAdvertisements().isEmpty() && !this.isAutopopupCompletion() && !DumbService.isDumb(this.getProject())) {
                DefaultCompletionContributor.addDefaultAdvertisements(this.myLookup, this.myHasPsiElements);
            }
            this.myLookup.getAdvertiser().showRandomText();
        }
        boolean justShown = false;
        if (!this.myLookup.isShown()) {
            if (this.hideAutopopupIfMeaningless()) {
                return;
            }
            if (!this.myLookup.showLookup()) {
                return;
            }
            justShown = true;
        }
        this.myLookupUpdated = true;
        this.myLookup.refreshUi(true, justShown);
        this.hideAutopopupIfMeaningless();
        if (justShown) {
            this.myLookup.ensureSelectionVisible(true);
        }
    }

    private boolean shouldShowLookup() {
        if (this.isAutopopupCompletion()) {
            if (this.myCount == 0) {
                return false;
            }
            if (this.myLookup.isCalculating() && Registry.is("ide.completion.delay.autopopup.until.completed")) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addItem(CompletionResult item) {
        boolean allowMiddleMatches;
        boolean forceMiddleMatch;
        if (!this.isRunning()) {
            return;
        }
        ProgressManager.checkCanceled();
        if (!this.myHandler.isTestingMode()) {
            LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        }
        LookupElement lookupElement = item.getLookupElement();
        if (!this.myHasPsiElements && lookupElement.getPsiElement() != null) {
            this.myHasPsiElements = true;
        }
        boolean bl = forceMiddleMatch = lookupElement.getUserData(BaseCompletionLookupArranger.FORCE_MIDDLE_MATCH) != null;
        if (forceMiddleMatch) {
            this.myArranger.associateSorter(lookupElement, (CompletionSorterImpl)item.getSorter());
            this.addItemToLookup(item);
            return;
        }
        boolean bl2 = allowMiddleMatches = this.myCount > 10;
        if (allowMiddleMatches) {
            this.addDelayedMiddleMatches();
        }
        this.myArranger.associateSorter(lookupElement, (CompletionSorterImpl)item.getSorter());
        if (item.isStartMatch() || allowMiddleMatches) {
            this.addItemToLookup(item);
        } else {
            List<CompletionResult> list2 = this.myDelayedMiddleMatches;
            synchronized (list2) {
                this.myDelayedMiddleMatches.add(item);
            }
        }
    }

    private void addItemToLookup(CompletionResult item) {
        if (!this.myLookup.addItem(item.getLookupElement(), item.getPrefixMatcher())) {
            return;
        }
        this.myArranger.setLastLookupPrefix(this.myLookup.getAdditionalPrefix());
        ++this.myCount;
        if (this.myCount == 1) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(this.myFreezeSemaphore::up, (long)ourInsertSingleItemTimeSpan, TimeUnit.MILLISECONDS);
        }
        this.myQueue.queue(this.myUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDelayedMiddleMatches() {
        ArrayList<CompletionResult> delayed;
        List<CompletionResult> list2 = this.myDelayedMiddleMatches;
        synchronized (list2) {
            if (this.myDelayedMiddleMatches.isEmpty()) {
                return;
            }
            delayed = new ArrayList<CompletionResult>(this.myDelayedMiddleMatches);
            this.myDelayedMiddleMatches.clear();
        }
        for (CompletionResult item : delayed) {
            ProgressManager.checkCanceled();
            this.addItemToLookup(item);
        }
    }

    public void closeAndFinish(boolean hideLookup) {
        LookupEx lookup2;
        if (!this.myLookup.isLookupDisposed() && (lookup2 = LookupManager.getActiveLookup(this.myEditor)) != this.myLookup) {
            LOG.error("lookup changed: " + lookup2 + "; " + this);
        }
        this.myLookup.removeLookupListener(this.myLookupListener);
        this.finishCompletionProcess(true);
        CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        if (hideLookup) {
            this.myLookup.hideLookup(true);
        }
    }

    private void finishCompletionProcess(boolean disposeOffsetMap) {
        this.cancel();
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.dispose(this.myQueue);
        LookupManager.getInstance(this.getProject()).removePropertyChangeListener(this.myLookupManagerListener);
        CompletionServiceImpl.assertPhase(CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class, CompletionPhase.Synchronous.class, CompletionPhase.CommittingDocuments.class);
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        LOG.assertTrue(currentCompletion == this, currentCompletion + "!=" + this);
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments) {
            LOG.assertTrue(((CompletionPhase.CommittingDocuments)oldPhase).indicator != null, oldPhase);
            ((CompletionPhase.CommittingDocuments)oldPhase).replaced = true;
        }
        CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        if (disposeOffsetMap) {
            this.disposeIndicator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeIndicator() {
        Object object = this.myLock;
        synchronized (object) {
            Disposer.dispose(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChildDisposable(@NotNull Supplier<? extends Disposable> child2) {
        if (child2 == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.checkCanceled();
            Disposer.register(this, child2.get());
        }
    }

    public static void cleanupForNextTest() {
        CompletionService completionService = ServiceManager.getServiceIfCreated(CompletionService.class);
        if (!(completionService instanceof CompletionServiceImpl)) {
            return;
        }
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (currentCompletion != null) {
            currentCompletion.finishCompletionProcess(true);
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        } else {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        }
        StatisticsUpdate.cancelLastCompletionStatisticsUpdate();
    }

    boolean blockingWaitForFinish(int timeoutMs) {
        if (this.myHandler.isTestingMode() && !TestModeFlags.is(CompletionAutoPopupHandler.ourTestingAutopopup)) {
            if (!this.myFinishSemaphore.waitFor(100000L)) {
                throw new AssertionError((Object)"Too long completion");
            }
            return true;
        }
        if (this.myFreezeSemaphore.waitFor(timeoutMs)) {
            return !this.isRunning() && !this.isCanceled();
        }
        return false;
    }

    @Override
    public void stop() {
        super.stop();
        this.myQueue.cancelAllUpdates();
        this.myFreezeSemaphore.up();
        this.myFinishSemaphore.up();
        GuiUtils.invokeLaterIfNeeded(() -> {
            PsiFile file2;
            CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
            if (!(phase instanceof CompletionPhase.BgCalculation) || phase.indicator != this) {
                return;
            }
            LOG.assertTrue(!this.getProject().isDisposed(), "project disposed");
            if (this.myEditor.isDisposed()) {
                this.myLookup.hideLookup(false);
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                return;
            }
            if (this.myEditor instanceof EditorWindow) {
                LOG.assertTrue(((EditorWindow)this.myEditor).getInjectedFile().isValid(), "injected file !valid");
                LOG.assertTrue(((DocumentWindow)this.myEditor.getDocument()).isValid(), "docWindow !valid");
            }
            LOG.assertTrue((file2 = this.myLookup.getPsiFile()) == null || file2.isValid(), "file !valid");
            this.myLookup.setCalculating(false);
            if (this.myCount == 0) {
                this.myLookup.hideLookup(false);
                if (!this.isAutopopupCompletion()) {
                    CompletionProgressIndicator current2 = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
                    LOG.assertTrue(current2 == null, current2 + "!=" + this);
                    this.handleEmptyLookup(!((CompletionPhase.BgCalculation)phase).modifiersChanged);
                }
            } else {
                this.updateLookup(this.myIsUpdateSuppressed);
                if (CompletionServiceImpl.getCompletionPhase() != CompletionPhase.NoCompletion) {
                    CompletionServiceImpl.setCompletionPhase(new CompletionPhase.ItemsCalculated(this));
                }
            }
        }, this.myQueue.getModalityState());
    }

    private boolean hideAutopopupIfMeaningless() {
        if (!this.myLookup.isLookupDisposed() && this.isAutopopupCompletion() && !this.myLookup.isSelectionTouched() && !this.myLookup.isCalculating()) {
            this.myLookup.refreshUi(true, false);
            List<LookupElement> items = this.myLookup.getItems();
            for (LookupElement item : items) {
                if (!this.isAlreadyInTheEditor(item)) {
                    return false;
                }
                if (!item.isValid() || !item.isWorthShowingInAutoPopup()) continue;
                return false;
            }
            this.myLookup.hideLookup(false);
            LOG.assertTrue(CompletionServiceImpl.getCompletionService().getCurrentCompletion() == null);
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            return true;
        }
        return false;
    }

    private boolean isAlreadyInTheEditor(LookupElement item) {
        Editor editor = this.myLookup.getEditor();
        int start2 = editor.getCaretModel().getOffset() - this.myLookup.itemPattern(item).length();
        Document document = editor.getDocument();
        return start2 >= 0 && StringUtil.startsWith(document.getImmutableCharSequence().subSequence(start2, document.getTextLength()), item.getLookupString());
    }

    void restorePrefix(@NotNull Runnable customRestore) {
        if (customRestore == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(9);
        }
        WriteCommandAction.runWriteCommandAction(this.getProject(), () -> {
            this.setMergeCommand();
            customRestore.run();
        });
    }

    int nextInvocationCount(int invocation, boolean reused) {
        return reused ? Math.max(this.myInvocationCount + 1, 2) : invocation;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(10);
        }
        return editor;
    }

    @Override
    @NotNull
    public Caret getCaret() {
        Caret caret = this.myCaret;
        if (caret == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(11);
        }
        return caret;
    }

    boolean isRepeatedInvocation(CompletionType completionType, Editor editor) {
        if (completionType != this.myCompletionType || editor != this.myEditor) {
            return false;
        }
        return !this.isAutopopupCompletion() || this.myLookup.mayBeNoticed();
    }

    @Override
    public boolean isAutopopupCompletion() {
        return this.myInvocationCount == 0;
    }

    int getInvocationCount() {
        return this.myInvocationCount;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = Objects.requireNonNull(this.myEditor.getProject());
        if (project2 == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(12);
        }
        return project2;
    }

    @Override
    public void addWatchedPrefix(int startOffset, ElementPattern<String> restartCondition) {
        this.myRestartingPrefixConditions.add(Pair.create(startOffset, restartCondition));
    }

    @Override
    public void prefixUpdated() {
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        if (caretOffset < this.myStartCaret) {
            this.scheduleRestart();
            this.myRestartingPrefixConditions.clear();
            return;
        }
        CharSequence text2 = this.myEditor.getDocument().getCharsSequence();
        for (Pair<Integer, ElementPattern<String>> pair : this.myRestartingPrefixConditions) {
            String newPrefix;
            int start2 = (Integer)pair.first;
            if (caretOffset < start2 || start2 < 0 || caretOffset > text2.length() || !((ElementPattern)pair.second).accepts(newPrefix = text2.subSequence(start2, caretOffset).toString())) continue;
            this.scheduleRestart();
            this.myRestartingPrefixConditions.clear();
            return;
        }
        this.hideAutopopupIfMeaningless();
    }

    @Override
    public void scheduleRestart() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myHandler.isTestingMode() && !TestModeFlags.is(CompletionAutoPopupHandler.ourTestingAutopopup)) {
            this.closeAndFinish(false);
            PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
            new CodeCompletionHandlerBase(this.myCompletionType, false, false, true).invokeCompletion(this.getProject(), this.myEditor, this.myInvocationCount);
            return;
        }
        this.cancel();
        CompletionProgressIndicator current2 = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (this != current2) {
            LOG.error(current2 + "!=" + this);
        }
        this.hideAutopopupIfMeaningless();
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments) {
            ((CompletionPhase.CommittingDocuments)oldPhase).replaced = true;
        }
        CompletionPhase.CommittingDocuments.scheduleAsyncCompletion(this.myEditor, this.myCompletionType, null, this.getProject(), this);
    }

    @Override
    public String toString() {
        return "CompletionProgressIndicator[count=" + this.myCount + ",phase=" + CompletionServiceImpl.getCompletionPhase() + "]@" + System.identityHashCode(this);
    }

    void handleEmptyLookup(boolean awaitSecondInvocation) {
        if (this.isAutopopupCompletion() && ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        LOG.assertTrue(!this.isAutopopupCompletion());
        CompletionParameters parameters = this.getParameters();
        if (this.myHandler.invokedExplicitly && parameters != null) {
            LightweightHint hint = this.showErrorHint(this.getProject(), this.getEditor(), this.getNoSuggestionsMessage(parameters));
            if (awaitSecondInvocation) {
                CompletionServiceImpl.setCompletionPhase(new CompletionPhase.NoSuggestionsHint(hint, this));
                return;
            }
        }
        CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
    }

    private String getNoSuggestionsMessage(CompletionParameters parameters) {
        return CompletionContributor.forParameters(parameters).stream().map(c -> c.handleEmptyLookup(parameters, this.getEditor())).filter(StringUtil::isNotEmpty).findFirst().orElse(LangBundle.message("completion.no.suggestions", new Object[0]));
    }

    private LightweightHint showErrorHint(Project project2, Editor editor, String text2) {
        LightweightHint[] result2 = new LightweightHint[]{null};
        EditorHintListener listener2 = (project1, hint, flags) -> {
            result2[0] = hint;
        };
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(EditorHintListener.TOPIC, listener2);
        assert (text2 != null);
        this.myEmptyCompletionNotifier.showIncompleteHint(editor, text2, DumbService.isDumb(project2));
        connection.disconnect();
        return result2[0];
    }

    private static boolean shouldPreselectFirstSuggestion(CompletionParameters parameters) {
        if (Registry.is("ide.completion.lookup.element.preselect.depends.on.context")) {
            for (CompletionPreselectionBehaviourProvider provider : CompletionPreselectionBehaviourProvider.EP_NAME.getExtensionList()) {
                if (provider.shouldPreselectFirstSuggestion(parameters)) continue;
                return false;
            }
        }
        return true;
    }

    void runContributors(CompletionInitializationContext initContext) {
        CompletionParameters parameters = Objects.requireNonNull(this.myParameters);
        this.myThreading.startThread(ProgressWrapper.wrap(this), () -> AsyncCompletion.tryReadOrCancel(this, () -> this.scheduleAdvertising(parameters)));
        WeighingDelegate weigher = this.myThreading.delegateWeighing(this);
        try {
            this.calculateItems(initContext, weigher, parameters);
        }
        catch (ProcessCanceledException ignore) {
            this.cancel();
        }
        catch (Throwable t) {
            this.cancel();
            LOG.error(t);
        }
    }

    private void calculateItems(CompletionInitializationContext initContext, WeighingDelegate weigher, CompletionParameters parameters) {
        this.duringCompletion(initContext, parameters);
        ProgressManager.checkCanceled();
        CompletionService.getCompletionService().performCompletion(parameters, weigher);
        ProgressManager.checkCanceled();
        weigher.waitFor();
        ProgressManager.checkCanceled();
    }

    @NotNull
    CompletionThreadingBase getCompletionThreading() {
        CompletionThreadingBase completionThreadingBase = this.myThreading;
        if (completionThreadingBase == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(13);
        }
        return completionThreadingBase;
    }

    @Override
    public void addAdvertisement(@NotNull String text2, @Nullable Icon icon2) {
        if (text2 == null) {
            CompletionProgressIndicator.$$$reportNull$$$0(14);
        }
        this.myAdvertiserChanges.offer(() -> this.myLookup.addAdvertisement(text2, icon2));
        this.myQueue.queue(this.myUpdate);
    }

    public static void setGroupingTimeSpan(int timeSpan) {
        ourInsertSingleItemTimeSpan = timeSpan;
    }

    @Deprecated
    public static void setAutopopupTriggerTime(int timeSpan) {
        ourShowPopupGroupingTime = timeSpan;
        ourShowPopupAfterFirstItemGroupingTime = timeSpan;
    }

    void makeSureLookupIsShown(int timeout) {
        this.mySuppressTimeoutAlarm.addRequest(this::showIfSuppressed, timeout);
    }

    private void showIfSuppressed() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myLookup.isShown()) {
            return;
        }
        this.updateLookup(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostOffsets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionProgressIndicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customRestore";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionProgressIndicator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOffsetMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostOffsets";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaret";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionThreading";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setParameters";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerChildDisposable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restorePrefix";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAdvertisement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProjectEmptyCompletionNotifier
    implements EmptyCompletionNotifier {
        private ProjectEmptyCompletionNotifier() {
        }

        @Override
        public void showIncompleteHint(@NotNull Editor editor, @NotNull String text2, boolean isDumbMode) {
            if (editor == null) {
                ProjectEmptyCompletionNotifier.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                ProjectEmptyCompletionNotifier.$$$reportNull$$$0(1);
            }
            String message = isDumbMode ? text2 + CodeInsightBundle.message("completion.incomplete.during.indexing.suffix", new Object[0]) : text2;
            HintManager.getInstance().showInformationHint(editor, StringUtil.escapeXmlEntities(message), (short)2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/completion/CompletionProgressIndicator$ProjectEmptyCompletionNotifier";
            objectArray[2] = "showIncompleteHint";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ModifierTracker
    extends KeyAdapter {
        private final JComponent myContentComponent;

        ModifierTracker(JComponent contentComponent) {
            this.myContentComponent = contentComponent;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.processModifier(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.processModifier(e);
        }

        private void processModifier(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 17 || code == 157 || code == 18 || code == 16) {
                this.myContentComponent.removeKeyListener(this);
                CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
                if (phase instanceof CompletionPhase.BgCalculation) {
                    ((CompletionPhase.BgCalculation)phase).modifiersChanged = true;
                } else if (phase instanceof CompletionPhase.InsertedSingleItem) {
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                }
            }
        }
    }
}

