/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.util.containers.ContainerUtil;

public class DefaultCharFilter
extends CharFilter {
    @Override
    public CharFilter.Result acceptChar(char c, int prefixLength, Lookup lookup2) {
        if (Character.isJavaIdentifierPart(c)) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        switch (c) {
            case ' ': 
            case '(': 
            case ',': 
            case '.': 
            case ':': 
            case ';': 
            case '=': {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
            case '-': {
                return ContainerUtil.exists(lookup2.getItems(), item -> DefaultCharFilter.matchesAfterAppendingChar(lookup2, item, c)) ? CharFilter.Result.ADD_TO_PREFIX : CharFilter.Result.HIDE_LOOKUP;
            }
        }
        return CharFilter.Result.HIDE_LOOKUP;
    }

    private static boolean matchesAfterAppendingChar(Lookup lookup2, LookupElement item, char c) {
        PrefixMatcher matcher = lookup2.itemMatcher(item);
        return matcher.cloneWithPrefix(matcher.getPrefix() + ((LookupImpl)lookup2).getAdditionalPrefix() + c).prefixMatches(item);
    }
}

