/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class DefaultCompletionContributor
extends CompletionContributor {
    static void addDefaultAdvertisements(LookupImpl lookup2, boolean includePsiFeatures) {
        String shortcut;
        Project project2 = lookup2.getProject();
        if (CompletionUtil.shouldShowFeature(project2, "editing.completion.finishByDotEtc")) {
            lookup2.addAdvertisement(LangBundle.message("completion.dot.etc.ad", new Object[0]), null);
        }
        if (!includePsiFeatures) {
            return;
        }
        if (CompletionUtil.shouldShowFeature(project2, "editing.completion.finishBySmartEnter") && StringUtil.isNotEmpty(shortcut = KeymapUtil.getFirstKeyboardShortcutText("EditorChooseLookupItemCompleteStatement"))) {
            lookup2.addAdvertisement(LangBundle.message("completion.smart.enter.ad", shortcut), null);
        }
        if ((CompletionUtil.shouldShowFeature(project2, "codeassists.quickjavadoc") || CompletionUtil.shouldShowFeature(project2, "codeassists.quickjavadoc.lookup")) && StringUtil.isNotEmpty(shortcut = KeymapUtil.getFirstKeyboardShortcutText("QuickJavaDoc"))) {
            lookup2.addAdvertisement(LangBundle.message("completion.quick.javadoc.ad", shortcut), null);
        }
        if ((CompletionUtil.shouldShowFeature(project2, "codeassists.quickdefinition") || CompletionUtil.shouldShowFeature(project2, "codeassists.quickdefinition.lookup")) && StringUtil.isNotEmpty(shortcut = KeymapUtil.getFirstKeyboardShortcutText("QuickImplementations"))) {
            lookup2.addAdvertisement(LangBundle.message("completion.quick.implementations.ad", shortcut), null);
        }
    }

    @Override
    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        LookupElement[] items;
        if (context == null) {
            DefaultCompletionContributor.$$$reportNull$$$0(0);
        }
        if ((items = context.getItems()).length == 1) {
            LookupElement item = items[0];
            if (!StringUtil.isEmpty(context.getLookup().itemPattern(item)) || context.getParameters().getCompletionType() == CompletionType.SMART) {
                return AutoCompletionDecision.insertItem(item);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/DefaultCompletionContributor", "handleAutoCompletionPossibility"));
    }
}

